/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.framing.amqp_8_0;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.qpid.AMQException;
import org.apache.qpid.codec.MarkableDataInput;
import org.apache.qpid.framing.AMQFrameDecodingException;
import org.apache.qpid.framing.AMQMethodBody;
import org.apache.qpid.framing.AMQMethodBodyInstanceFactory;
import org.apache.qpid.framing.FieldTable;
import org.apache.qpid.framing.MethodDispatcher;
import org.apache.qpid.framing.TestTableBody;
import org.apache.qpid.framing.amqp_8_0.AMQMethodBody_8_0;
import org.apache.qpid.framing.amqp_8_0.MethodDispatcher_8_0;

public class TestTableBodyImpl
extends AMQMethodBody_8_0
implements TestTableBody {
    private static final AMQMethodBodyInstanceFactory FACTORY_INSTANCE = new AMQMethodBodyInstanceFactory(){

        public AMQMethodBody newInstance(MarkableDataInput in, long size) throws AMQFrameDecodingException, IOException {
            return new TestTableBodyImpl(in);
        }
    };
    public static final int CLASS_ID = 120;
    public static final int METHOD_ID = 30;
    private final FieldTable _table;
    private final short _integerOp;
    private final short _stringOp;

    public static AMQMethodBodyInstanceFactory getFactory() {
        return FACTORY_INSTANCE;
    }

    public TestTableBodyImpl(MarkableDataInput buffer) throws AMQFrameDecodingException, IOException {
        this._table = this.readFieldTable(buffer);
        this._integerOp = this.readUnsignedByte(buffer);
        this._stringOp = this.readUnsignedByte(buffer);
    }

    public TestTableBodyImpl(FieldTable table, short integerOp, short stringOp) {
        this._table = table;
        this._integerOp = integerOp;
        this._stringOp = stringOp;
    }

    public int getClazz() {
        return 120;
    }

    public int getMethod() {
        return 30;
    }

    public final FieldTable getTable() {
        return this._table;
    }

    public final short getIntegerOp() {
        return this._integerOp;
    }

    public final short getStringOp() {
        return this._stringOp;
    }

    protected int getBodySize() {
        int size = 2;
        return size += this.getSizeOf(this._table);
    }

    public void writeMethodPayload(DataOutput buffer) throws IOException {
        this.writeFieldTable(buffer, this._table);
        this.writeUnsignedByte(buffer, this._integerOp);
        this.writeUnsignedByte(buffer, this._stringOp);
    }

    public boolean execute(MethodDispatcher dispatcher, int channelId) throws AMQException {
        return ((MethodDispatcher_8_0)dispatcher).dispatchTestTable(this, channelId);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("[TestTableBodyImpl: ");
        buf.append("table=");
        buf.append(this.getTable());
        buf.append(", ");
        buf.append("integerOp=");
        buf.append(this.getIntegerOp());
        buf.append(", ");
        buf.append("stringOp=");
        buf.append(this.getStringOp());
        buf.append("]");
        return buf.toString();
    }
}

