/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.ssl;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.qpid.transport.network.security.ssl.QpidClientX509KeyManager;
import org.apache.qpid.transport.network.security.ssl.QpidMultipleTrustManager;
import org.apache.qpid.transport.network.security.ssl.QpidPeersOnlyTrustManager;
import org.apache.qpid.transport.network.security.ssl.SSLUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SSLContextFactory {
    public static final String TRANSPORT_LAYER_SECURITY_CODE = "TLS";

    private SSLContextFactory() {
    }

    public static SSLContext buildServerContext(String keyStorePath, String keyStorePassword, String keyStoreType, String keyManagerFactoryAlgorithm) throws GeneralSecurityException, IOException {
        return SSLContextFactory.buildContext(Collections.<TrustStoreWrapper>emptyList(), keyStorePath, keyStorePassword, keyStoreType, keyManagerFactoryAlgorithm, null);
    }

    public static SSLContext buildClientContext(Collection<TrustStoreWrapper> trustStores, String keyStorePath, String keyStorePassword, String keyStoreType, String keyManagerFactoryAlgorithm, String certAlias) throws GeneralSecurityException, IOException {
        return SSLContextFactory.buildContext(trustStores, keyStorePath, keyStorePassword, keyStoreType, keyManagerFactoryAlgorithm, certAlias);
    }

    public static SSLContext buildClientContext(String trustStorePath, String trustStorePassword, String trustStoreType, String trustManagerFactoryAlgorithm, String keyStorePath, String keyStorePassword, String keyStoreType, String keyManagerFactoryAlgorithm, String certAlias) throws GeneralSecurityException, IOException {
        TrustStoreWrapper trstWrapper = new TrustStoreWrapper(trustStorePath, trustStorePassword, trustStoreType, Boolean.FALSE, trustManagerFactoryAlgorithm);
        return SSLContextFactory.buildContext(Collections.singletonList(trstWrapper), keyStorePath, keyStorePassword, keyStoreType, keyManagerFactoryAlgorithm, certAlias);
    }

    private static SSLContext buildContext(Collection<TrustStoreWrapper> trstWrappers, String keyStorePath, String keyStorePassword, String keyStoreType, String keyManagerFactoryAlgorithm, String certAlias) throws GeneralSecurityException, IOException {
        KeyManager[] keyManagers;
        SSLContext sslContext = SSLContext.getInstance(TRANSPORT_LAYER_SECURITY_CODE);
        ArrayList<TrustManager> trustManagersCol = new ArrayList<TrustManager>();
        QpidMultipleTrustManager mulTrustManager = new QpidMultipleTrustManager();
        for (TrustStoreWrapper tsw : trstWrappers) {
            TrustManager[] delegateManagers;
            if (tsw.trustStorePath == null) continue;
            KeyStore ts = SSLUtil.getInitializedKeyStore(tsw.trustStorePath, tsw.trustStorePassword, tsw.trustStoreType);
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(tsw.trustManagerFactoryAlgorithm);
            tmf.init(ts);
            for (TrustManager tm : delegateManagers = tmf.getTrustManagers()) {
                if (tm instanceof X509TrustManager) {
                    if (Boolean.TRUE.equals(tsw.trustStorePeersOnly)) {
                        mulTrustManager.addTrustManager(new QpidPeersOnlyTrustManager(ts, (X509TrustManager)tm));
                        continue;
                    }
                    mulTrustManager.addTrustManager((X509TrustManager)tm);
                    continue;
                }
                trustManagersCol.add(tm);
            }
        }
        if (!mulTrustManager.isEmpty()) {
            trustManagersCol.add(mulTrustManager);
        }
        TrustManager[] trustManagers = trustManagersCol.isEmpty() ? null : trustManagersCol.toArray(new TrustManager[trustManagersCol.size()]);
        if (keyStorePath != null) {
            if (certAlias != null) {
                keyManagers = new KeyManager[]{new QpidClientX509KeyManager(certAlias, keyStorePath, keyStoreType, keyStorePassword, keyManagerFactoryAlgorithm)};
            } else {
                KeyStore ks = SSLUtil.getInitializedKeyStore(keyStorePath, keyStorePassword, keyStoreType);
                char[] keyStoreCharPassword = keyStorePassword == null ? null : keyStorePassword.toCharArray();
                KeyManagerFactory kmf = KeyManagerFactory.getInstance(keyManagerFactoryAlgorithm);
                kmf.init(ks, keyStoreCharPassword);
                keyManagers = kmf.getKeyManagers();
            }
        } else {
            keyManagers = null;
        }
        sslContext.init(keyManagers, trustManagers, null);
        return sslContext;
    }

    public static class TrustStoreWrapper {
        private final String trustStorePath;
        private final String trustStorePassword;
        private final String trustStoreType;
        private final Boolean trustStorePeersOnly;
        private String trustManagerFactoryAlgorithm;

        public TrustStoreWrapper(String trustStorePath, String trustStorePassword, String trustStoreType, Boolean trustStorePeersOnly, String trustManagerFactoryAlgorithm) {
            this.trustStorePath = trustStorePath;
            this.trustStorePassword = trustStorePassword;
            this.trustStoreType = trustStoreType;
            this.trustStorePeersOnly = trustStorePeersOnly;
            this.trustManagerFactoryAlgorithm = trustManagerFactoryAlgorithm;
        }
    }
}

