/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.transport;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.qpid.transport.Method;
import org.apache.qpid.transport.MethodDelegate;
import org.apache.qpid.transport.Option;
import org.apache.qpid.transport.SessionDetachCode;
import org.apache.qpid.transport.codec.Decoder;
import org.apache.qpid.transport.codec.Encoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SessionDetached
extends Method {
    public static final int TYPE = 516;
    private short packing_flags = 0;
    private byte[] name;
    private SessionDetachCode code;

    @Override
    public final int getStructType() {
        return 516;
    }

    @Override
    public final int getSizeWidth() {
        return 0;
    }

    @Override
    public final int getPackWidth() {
        return 2;
    }

    @Override
    public final boolean hasPayload() {
        return false;
    }

    @Override
    public final byte getEncodedTrack() {
        return 1;
    }

    @Override
    public final boolean isConnectionControl() {
        return false;
    }

    public SessionDetached() {
    }

    public SessionDetached(byte[] name, SessionDetachCode code, Option ... _options) {
        if (name != null) {
            this.setName(name);
        }
        if (code != null) {
            this.setCode(code);
        }
        block6: for (int i = 0; i < _options.length; ++i) {
            switch (_options[i]) {
                case SYNC: {
                    this.setSync(true);
                    continue block6;
                }
                case BATCH: {
                    this.setBatch(true);
                    continue block6;
                }
                case UNRELIABLE: {
                    this.setUnreliable(true);
                    continue block6;
                }
                case NONE: {
                    continue block6;
                }
                default: {
                    throw new IllegalArgumentException("invalid option: " + (Object)((Object)_options[i]));
                }
            }
        }
    }

    @Override
    public <C> void dispatch(C context, MethodDelegate<C> delegate) {
        delegate.sessionDetached(context, this);
    }

    public final boolean hasName() {
        return (this.packing_flags & 0x100) != 0;
    }

    public final SessionDetached clearName() {
        this.packing_flags = (short)(this.packing_flags & 0xFFFFFEFF);
        this.name = null;
        this.setDirty(true);
        return this;
    }

    public final byte[] getName() {
        return this.name;
    }

    public final SessionDetached setName(byte[] value) {
        this.name = value;
        this.packing_flags = (short)(this.packing_flags | 0x100);
        this.setDirty(true);
        return this;
    }

    public final SessionDetached name(byte[] value) {
        return this.setName(value);
    }

    public final boolean hasCode() {
        return (this.packing_flags & 0x200) != 0;
    }

    public final SessionDetached clearCode() {
        this.packing_flags = (short)(this.packing_flags & 0xFFFFFDFF);
        this.code = null;
        this.setDirty(true);
        return this;
    }

    public final SessionDetachCode getCode() {
        return this.code;
    }

    public final SessionDetached setCode(SessionDetachCode value) {
        this.code = value;
        this.packing_flags = (short)(this.packing_flags | 0x200);
        this.setDirty(true);
        return this;
    }

    public final SessionDetached code(SessionDetachCode value) {
        return this.setCode(value);
    }

    @Override
    public void write(Encoder enc) {
        enc.writeUint16(this.packing_flags);
        if ((this.packing_flags & 0x100) != 0) {
            enc.writeVbin16(this.name);
        }
        if ((this.packing_flags & 0x200) != 0) {
            enc.writeUint8(this.code.getValue());
        }
    }

    @Override
    public void read(Decoder dec) {
        this.packing_flags = (short)dec.readUint16();
        if ((this.packing_flags & 0x100) != 0) {
            this.name = dec.readVbin16();
        }
        if ((this.packing_flags & 0x200) != 0) {
            this.code = SessionDetachCode.get(dec.readUint8());
        }
    }

    @Override
    public Map<String, Object> getFields() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        if ((this.packing_flags & 0x100) != 0) {
            result.put("name", this.getName());
        }
        if ((this.packing_flags & 0x200) != 0) {
            result.put("code", (Object)this.getCode());
        }
        return result;
    }
}

