/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.transport.network.security;

import java.nio.ByteBuffer;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.apache.qpid.ssl.SSLContextFactory;
import org.apache.qpid.transport.ConnectionSettings;
import org.apache.qpid.transport.Receiver;
import org.apache.qpid.transport.Sender;
import org.apache.qpid.transport.TransportException;
import org.apache.qpid.transport.network.security.SSLStatus;
import org.apache.qpid.transport.network.security.SecurityLayer;
import org.apache.qpid.transport.network.security.sasl.SASLReceiver;
import org.apache.qpid.transport.network.security.sasl.SASLSender;
import org.apache.qpid.transport.network.security.ssl.SSLReceiver;
import org.apache.qpid.transport.network.security.ssl.SSLSender;
import org.apache.qpid.transport.network.security.ssl.SSLUtil;

public class SecurityLayerFactory {
    private SecurityLayerFactory() {
    }

    public static SecurityLayer newInstance(ConnectionSettings settings) {
        SecurityLayer layer = NullSecurityLayer.getInstance();
        if (settings.isUseSSL()) {
            layer = new SSLSecurityLayer(settings, layer);
        }
        if (settings.isUseSASLEncryption()) {
            layer = new SASLSecurityLayer(layer);
        }
        return layer;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class NullSecurityLayer
    implements SecurityLayer {
        private static final NullSecurityLayer INSTANCE = new NullSecurityLayer();

        private NullSecurityLayer() {
        }

        @Override
        public Sender<ByteBuffer> sender(Sender<ByteBuffer> delegate) {
            return delegate;
        }

        @Override
        public Receiver<ByteBuffer> receiver(Receiver<ByteBuffer> delegate) {
            return delegate;
        }

        @Override
        public String getUserID() {
            return null;
        }

        public static NullSecurityLayer getInstance() {
            return INSTANCE;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SASLSecurityLayer
    implements SecurityLayer {
        private SecurityLayer _layer;

        SASLSecurityLayer(SecurityLayer layer) {
            this._layer = layer;
        }

        public SASLSender sender(Sender<ByteBuffer> delegate) {
            SASLSender sender = new SASLSender(this._layer.sender(delegate));
            return sender;
        }

        public SASLReceiver receiver(Receiver<ByteBuffer> delegate) {
            SASLReceiver receiver = new SASLReceiver(this._layer.receiver(delegate));
            return receiver;
        }

        @Override
        public String getUserID() {
            return this._layer.getUserID();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SSLSecurityLayer
    implements SecurityLayer {
        private final SSLEngine _engine;
        private final SSLStatus _sslStatus = new SSLStatus();
        private String _hostname;
        private SecurityLayer _layer;

        public SSLSecurityLayer(ConnectionSettings settings, SecurityLayer layer) {
            SSLContext sslCtx;
            this._layer = layer;
            try {
                sslCtx = SSLContextFactory.buildClientContext(settings.getTrustStorePath(), settings.getTrustStorePassword(), settings.getTrustStoreType(), settings.getTrustManagerFactoryAlgorithm(), settings.getKeyStorePath(), settings.getKeyStorePassword(), settings.getKeyStoreType(), settings.getKeyManagerFactoryAlgorithm(), settings.getCertAlias());
            }
            catch (Exception e) {
                throw new TransportException("Error creating SSL Context", e);
            }
            if (settings.isVerifyHostname()) {
                this._hostname = settings.getHost();
            }
            try {
                this._engine = sslCtx.createSSLEngine();
                this._engine.setUseClientMode(true);
            }
            catch (Exception e) {
                throw new TransportException("Error creating SSL Engine", e);
            }
        }

        @Override
        public Sender<ByteBuffer> sender(Sender<ByteBuffer> delegate) {
            SSLSender sender = new SSLSender(this._engine, this._layer.sender(delegate), this._sslStatus);
            sender.setHostname(this._hostname);
            return sender;
        }

        @Override
        public Receiver<ByteBuffer> receiver(Receiver<ByteBuffer> delegate) {
            SSLReceiver receiver = new SSLReceiver(this._engine, this._layer.receiver(delegate), this._sslStatus);
            receiver.setHostname(this._hostname);
            return receiver;
        }

        @Override
        public String getUserID() {
            return SSLUtil.retriveIdentity(this._engine);
        }
    }
}

