/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.transport.network.security.ssl;

import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.X509TrustManager;

public class QpidMultipleTrustManager
implements X509TrustManager {
    private List<X509TrustManager> trustManagers = new ArrayList<X509TrustManager>();

    public boolean isEmpty() {
        return this.trustManagers.isEmpty();
    }

    public void addTrustManager(X509TrustManager trustManager) {
        this.trustManagers.add(trustManager);
    }

    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        for (X509TrustManager trustManager : this.trustManagers) {
            try {
                trustManager.checkClientTrusted(chain, authType);
                return;
            }
            catch (CertificateException ex) {
            }
        }
        throw new CertificateException();
    }

    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        for (X509TrustManager trustManager : this.trustManagers) {
            try {
                trustManager.checkServerTrusted(chain, authType);
                return;
            }
            catch (CertificateException ex) {
            }
        }
        throw new CertificateException();
    }

    public X509Certificate[] getAcceptedIssuers() {
        ArrayList<X509Certificate> accIssuersCol = new ArrayList<X509Certificate>();
        for (X509TrustManager trustManager : this.trustManagers) {
            accIssuersCol.addAll(Arrays.asList(trustManager.getAcceptedIssuers()));
        }
        return accIssuersCol.toArray(new X509Certificate[accIssuersCol.size()]);
    }
}

