/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.util;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class ByteBufferInputStream
extends InputStream {
    private final ByteBuffer _buffer;

    public ByteBufferInputStream(ByteBuffer buffer) {
        this._buffer = buffer;
    }

    public int read() throws IOException {
        if (this._buffer.hasRemaining()) {
            return this._buffer.get() & 0xFF;
        }
        return -1;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (!this._buffer.hasRemaining()) {
            return -1;
        }
        if (this._buffer.remaining() < len) {
            len = this._buffer.remaining();
        }
        this._buffer.get(b, off, len);
        return len;
    }

    public void mark(int readlimit) {
        this._buffer.mark();
    }

    public void reset() throws IOException {
        this._buffer.reset();
    }

    public boolean markSupported() {
        return true;
    }

    public long skip(long n) throws IOException {
        this._buffer.position(this._buffer.position() + (int)n);
        return n;
    }

    public int available() throws IOException {
        return this._buffer.remaining();
    }
}

