/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.protocol;

import org.apache.ratis.protocol.ClientId;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.protocol.RaftRpcMessage;

public abstract class RaftClientMessage
implements RaftRpcMessage {
    private final ClientId clientId;
    private final RaftPeerId serverId;
    private final RaftGroupId groupId;

    public RaftClientMessage(ClientId clientId, RaftPeerId serverId, RaftGroupId groupId) {
        this.clientId = clientId;
        this.serverId = serverId;
        this.groupId = groupId;
    }

    @Override
    public String getRequestorId() {
        return this.clientId.toString();
    }

    @Override
    public String getReplierId() {
        return this.serverId.toString();
    }

    public ClientId getClientId() {
        return this.clientId;
    }

    public RaftPeerId getServerId() {
        return this.serverId;
    }

    @Override
    public RaftGroupId getRaftGroupId() {
        return this.groupId;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ":" + this.clientId + "->" + this.serverId + (this.groupId != null ? "@" + this.groupId : "");
    }
}

