/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.algorithms.implementations;

import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.algorithms.JCEMapper;
import org.apache.xml.security.algorithms.SignatureAlgorithmSpi;
import org.apache.xml.security.signature.XMLSignatureException;
import org.apache.xml.security.utils.Base64;

public abstract class SignatureECDSA
extends SignatureAlgorithmSpi {
    static Log log = LogFactory.getLog((String)(class$org$apache$xml$security$algorithms$implementations$SignatureECDSA == null ? (class$org$apache$xml$security$algorithms$implementations$SignatureECDSA = SignatureECDSA.class$("org.apache.xml.security.algorithms.implementations.SignatureECDSA")) : class$org$apache$xml$security$algorithms$implementations$SignatureECDSA).getName());
    private Signature _signatureAlgorithm = null;
    static /* synthetic */ Class class$org$apache$xml$security$algorithms$implementations$SignatureECDSA;
    static /* synthetic */ Class class$java$security$PublicKey;
    static /* synthetic */ Class class$java$security$PrivateKey;

    public abstract String engineGetURI();

    private static byte[] convertASN1toXMLDSIG(byte[] byArray) throws IOException {
        int n;
        int n2;
        int n3;
        int n4;
        for (n4 = n3 = byArray[3]; n4 > 0 && byArray[4 + n3 - n4] == 0; --n4) {
        }
        for (n2 = n = byArray[5 + n3]; n2 > 0 && byArray[6 + n3 + n - n2] == 0; --n2) {
        }
        if (byArray[0] != 48 || byArray[1] != byArray.length - 2 || byArray[2] != 2 || n4 > 24 || byArray[4 + n3] != 2 || n2 > 24) {
            throw new IOException("Invalid ASN.1 format of ECDSA signature");
        }
        byte[] byArray2 = new byte[48];
        System.arraycopy(byArray, 4 + n3 - n4, byArray2, 24 - n4, n4);
        System.arraycopy(byArray, 6 + n3 + n - n2, byArray2, 48 - n2, n2);
        return byArray2;
    }

    private static byte[] convertXMLDSIGtoASN1(byte[] byArray) throws IOException {
        int n;
        int n2;
        if (byArray.length != 48) {
            throw new IOException("Invalid XMLDSIG format of ECDSA signature");
        }
        for (n2 = 24; n2 > 0 && byArray[24 - n2] == 0; --n2) {
        }
        int n3 = n2;
        if (byArray[24 - n2] < 0) {
            ++n3;
        }
        for (n = 24; n > 0 && byArray[48 - n] == 0; --n) {
        }
        int n4 = n;
        if (byArray[48 - n] < 0) {
            ++n4;
        }
        byte[] byArray2 = new byte[6 + n3 + n4];
        byArray2[0] = 48;
        byArray2[1] = (byte)(4 + n3 + n4);
        byArray2[2] = 2;
        byArray2[3] = (byte)n3;
        System.arraycopy(byArray, 24 - n2, byArray2, 4 + n3 - n2, n2);
        byArray2[4 + n3] = 2;
        byArray2[5 + n3] = (byte)n4;
        System.arraycopy(byArray, 48 - n, byArray2, 6 + n3 + n4 - n, n);
        return byArray2;
    }

    public SignatureECDSA() throws XMLSignatureException {
        String string = JCEMapper.translateURItoJCEID(this.engineGetURI());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Created SignatureECDSA using " + string));
        }
        String string2 = JCEMapper.getProviderId();
        try {
            this._signatureAlgorithm = string2 == null ? Signature.getInstance(string) : Signature.getInstance(string, string2);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Object[] objectArray = new Object[]{string, noSuchAlgorithmException.getLocalizedMessage()};
            throw new XMLSignatureException("algorithms.NoSuchAlgorithm", objectArray);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            Object[] objectArray = new Object[]{string, noSuchProviderException.getLocalizedMessage()};
            throw new XMLSignatureException("algorithms.NoSuchAlgorithm", objectArray);
        }
    }

    protected void engineSetParameter(AlgorithmParameterSpec algorithmParameterSpec) throws XMLSignatureException {
        try {
            this._signatureAlgorithm.setParameter(algorithmParameterSpec);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new XMLSignatureException("empty", invalidAlgorithmParameterException);
        }
    }

    protected boolean engineVerify(byte[] byArray) throws XMLSignatureException {
        try {
            byte[] byArray2 = SignatureECDSA.convertXMLDSIGtoASN1(byArray);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Called ECDSA.verify() on " + Base64.encode(byArray)));
            }
            return this._signatureAlgorithm.verify(byArray2);
        }
        catch (SignatureException signatureException) {
            throw new XMLSignatureException("empty", signatureException);
        }
        catch (IOException iOException) {
            throw new XMLSignatureException("empty", iOException);
        }
    }

    protected void engineInitVerify(Key key) throws XMLSignatureException {
        if (!(key instanceof PublicKey)) {
            String string = key.getClass().getName();
            String string2 = (class$java$security$PublicKey == null ? (class$java$security$PublicKey = SignatureECDSA.class$("java.security.PublicKey")) : class$java$security$PublicKey).getName();
            Object[] objectArray = new Object[]{string, string2};
            throw new XMLSignatureException("algorithms.WrongKeyForThisOperation", objectArray);
        }
        try {
            this._signatureAlgorithm.initVerify((PublicKey)key);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new XMLSignatureException("empty", invalidKeyException);
        }
    }

    protected byte[] engineSign() throws XMLSignatureException {
        try {
            byte[] byArray = this._signatureAlgorithm.sign();
            return SignatureECDSA.convertASN1toXMLDSIG(byArray);
        }
        catch (SignatureException signatureException) {
            throw new XMLSignatureException("empty", signatureException);
        }
        catch (IOException iOException) {
            throw new XMLSignatureException("empty", iOException);
        }
    }

    protected void engineInitSign(Key key, SecureRandom secureRandom) throws XMLSignatureException {
        if (!(key instanceof PrivateKey)) {
            String string = key.getClass().getName();
            String string2 = (class$java$security$PrivateKey == null ? (class$java$security$PrivateKey = SignatureECDSA.class$("java.security.PrivateKey")) : class$java$security$PrivateKey).getName();
            Object[] objectArray = new Object[]{string, string2};
            throw new XMLSignatureException("algorithms.WrongKeyForThisOperation", objectArray);
        }
        try {
            this._signatureAlgorithm.initSign((PrivateKey)key, secureRandom);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new XMLSignatureException("empty", invalidKeyException);
        }
    }

    protected void engineInitSign(Key key) throws XMLSignatureException {
        if (!(key instanceof PrivateKey)) {
            String string = key.getClass().getName();
            String string2 = (class$java$security$PrivateKey == null ? (class$java$security$PrivateKey = SignatureECDSA.class$("java.security.PrivateKey")) : class$java$security$PrivateKey).getName();
            Object[] objectArray = new Object[]{string, string2};
            throw new XMLSignatureException("algorithms.WrongKeyForThisOperation", objectArray);
        }
        try {
            this._signatureAlgorithm.initSign((PrivateKey)key);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new XMLSignatureException("empty", invalidKeyException);
        }
    }

    protected void engineUpdate(byte[] byArray) throws XMLSignatureException {
        try {
            this._signatureAlgorithm.update(byArray);
        }
        catch (SignatureException signatureException) {
            throw new XMLSignatureException("empty", signatureException);
        }
    }

    protected void engineUpdate(byte by) throws XMLSignatureException {
        try {
            this._signatureAlgorithm.update(by);
        }
        catch (SignatureException signatureException) {
            throw new XMLSignatureException("empty", signatureException);
        }
    }

    protected void engineUpdate(byte[] byArray, int n, int n2) throws XMLSignatureException {
        try {
            this._signatureAlgorithm.update(byArray, n, n2);
        }
        catch (SignatureException signatureException) {
            throw new XMLSignatureException("empty", signatureException);
        }
    }

    protected String engineGetJCEAlgorithmString() {
        return this._signatureAlgorithm.getAlgorithm();
    }

    protected String engineGetJCEProviderName() {
        return this._signatureAlgorithm.getProvider().getName();
    }

    protected void engineSetHMACOutputLength(int n) throws XMLSignatureException {
        throw new XMLSignatureException("algorithms.HMACOutputLengthOnlyForHMAC");
    }

    protected void engineInitSign(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws XMLSignatureException {
        throw new XMLSignatureException("algorithms.CannotUseAlgorithmParameterSpecOnRSA");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class SignatureECDSASHA1
    extends SignatureECDSA {
        public String engineGetURI() {
            return "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha1";
        }
    }
}

