/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.readwritesplitting.distsql.handler.update;

import com.google.common.base.Strings;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.shardingsphere.infra.distsql.exception.DistSQLException;
import org.apache.shardingsphere.infra.distsql.exception.resource.RequiredResourceMissedException;
import org.apache.shardingsphere.infra.distsql.exception.rule.DuplicateRuleException;
import org.apache.shardingsphere.infra.distsql.exception.rule.InvalidAlgorithmConfigurationException;
import org.apache.shardingsphere.infra.distsql.exception.rule.InvalidRuleConfigurationException;
import org.apache.shardingsphere.infra.distsql.update.RuleDefinitionCreateUpdater;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.resource.ShardingSphereResource;
import org.apache.shardingsphere.infra.rule.identifier.type.ExportableRule;
import org.apache.shardingsphere.readwritesplitting.api.ReadwriteSplittingRuleConfiguration;
import org.apache.shardingsphere.readwritesplitting.api.rule.ReadwriteSplittingDataSourceRuleConfiguration;
import org.apache.shardingsphere.readwritesplitting.distsql.handler.converter.ReadwriteSplittingRuleStatementConverter;
import org.apache.shardingsphere.readwritesplitting.distsql.parser.segment.ReadwriteSplittingRuleSegment;
import org.apache.shardingsphere.readwritesplitting.distsql.parser.statement.CreateReadwriteSplittingRuleStatement;
import org.apache.shardingsphere.readwritesplitting.factory.ReplicaLoadBalanceAlgorithmFactory;

public final class CreateReadwriteSplittingRuleStatementUpdater
implements RuleDefinitionCreateUpdater<CreateReadwriteSplittingRuleStatement, ReadwriteSplittingRuleConfiguration> {
    public void checkSQLStatement(ShardingSphereDatabase database, CreateReadwriteSplittingRuleStatement sqlStatement, ReadwriteSplittingRuleConfiguration currentRuleConfig) throws DistSQLException {
        String databaseName = database.getName();
        this.checkDuplicateRuleNames(databaseName, sqlStatement, currentRuleConfig, database.getResource());
        this.checkToBeCreatedResources(databaseName, sqlStatement, database);
        this.checkToBeCreatedLoadBalancers(sqlStatement);
    }

    private void checkDuplicateRuleNames(String databaseName, CreateReadwriteSplittingRuleStatement sqlStatement, ReadwriteSplittingRuleConfiguration currentRuleConfig, ShardingSphereResource resource) throws DistSQLException {
        LinkedList currentRuleNames = new LinkedList();
        if (null != resource && null != resource.getDataSources()) {
            currentRuleNames.addAll(resource.getDataSources().keySet());
        }
        Collection duplicateRuleNames = sqlStatement.getRules().stream().map(ReadwriteSplittingRuleSegment::getName).filter(currentRuleNames::contains).collect(Collectors.toList());
        if (!duplicateRuleNames.isEmpty()) {
            throw new InvalidRuleConfigurationException("readwrite splitting", duplicateRuleNames, Collections.singleton(String.format("%s already exists in resource", duplicateRuleNames)));
        }
        if (null != currentRuleConfig) {
            currentRuleNames.addAll(currentRuleConfig.getDataSources().stream().map(ReadwriteSplittingDataSourceRuleConfiguration::getName).collect(Collectors.toList()));
        }
        duplicateRuleNames = sqlStatement.getRules().stream().map(ReadwriteSplittingRuleSegment::getName).filter(currentRuleNames::contains).collect(Collectors.toList());
        if (!duplicateRuleNames.isEmpty()) {
            throw new DuplicateRuleException("readwrite splitting", databaseName, duplicateRuleNames);
        }
    }

    private void checkToBeCreatedResources(String databaseName, CreateReadwriteSplittingRuleStatement sqlStatement, ShardingSphereDatabase database) throws DistSQLException {
        LinkedHashSet requireResources = new LinkedHashSet();
        LinkedHashSet requireDiscoverableResources = new LinkedHashSet();
        sqlStatement.getRules().forEach(each -> {
            if (Strings.isNullOrEmpty((String)each.getAutoAwareResource())) {
                requireResources.add(each.getWriteDataSource());
                requireResources.addAll(each.getReadDataSources());
            } else {
                requireDiscoverableResources.add(each.getAutoAwareResource());
            }
        });
        Collection notExistResources = database.getResource().getNotExistedResources(requireResources);
        DistSQLException.predictionThrow((boolean)notExistResources.isEmpty(), () -> new RequiredResourceMissedException(databaseName, notExistResources));
        Collection<String> logicResources = this.getLogicResources(database);
        Collection notExistLogicResources = requireDiscoverableResources.stream().filter(each -> !logicResources.contains(each)).collect(Collectors.toSet());
        DistSQLException.predictionThrow((boolean)notExistLogicResources.isEmpty(), () -> new RequiredResourceMissedException(databaseName, notExistLogicResources));
    }

    private Collection<String> getLogicResources(ShardingSphereDatabase database) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        Optional<ExportableRule> exportableRule = database.getRuleMetaData().findRules(ExportableRule.class).stream().filter(each -> each.containExportableKey(Collections.singletonList("primary_data_source"))).findAny();
        exportableRule.ifPresent(optional -> {
            Map exportData = optional.export(Collections.singletonList("primary_data_source"));
            Set logicResources = exportData.getOrDefault("primary_data_source", Collections.emptyMap()).keySet();
            result.addAll(logicResources);
        });
        return result;
    }

    private void checkToBeCreatedLoadBalancers(CreateReadwriteSplittingRuleStatement sqlStatement) throws InvalidAlgorithmConfigurationException {
        Collection notExistedLoadBalancers = sqlStatement.getRules().stream().map(ReadwriteSplittingRuleSegment::getLoadBalancer).filter(Objects::nonNull).distinct().filter(each -> !ReplicaLoadBalanceAlgorithmFactory.contains((String)each)).collect(Collectors.toList());
        if (!notExistedLoadBalancers.isEmpty()) {
            throw new InvalidAlgorithmConfigurationException("Load balancers", notExistedLoadBalancers);
        }
    }

    public ReadwriteSplittingRuleConfiguration buildToBeCreatedRuleConfiguration(CreateReadwriteSplittingRuleStatement sqlStatement) {
        return ReadwriteSplittingRuleStatementConverter.convert(sqlStatement.getRules());
    }

    public void updateCurrentRuleConfiguration(ReadwriteSplittingRuleConfiguration currentRuleConfig, ReadwriteSplittingRuleConfiguration toBeCreatedRuleConfig) {
        if (null != currentRuleConfig) {
            currentRuleConfig.getDataSources().addAll(toBeCreatedRuleConfig.getDataSources());
            currentRuleConfig.getLoadBalancers().putAll(toBeCreatedRuleConfig.getLoadBalancers());
        }
    }

    public Class<ReadwriteSplittingRuleConfiguration> getRuleConfigurationClass() {
        return ReadwriteSplittingRuleConfiguration.class;
    }

    public String getType() {
        return CreateReadwriteSplittingRuleStatement.class.getName();
    }
}

