/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.util.TimeZone;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes$class;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.FromUTCTimestamp$;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(timestamp, string timezone) - Assumes given timestamp is UTC and converts to given timezone.")
@ScalaSignature(bytes="\u0006\u0001\u0005]f\u0001B\u0001\u0003\u0001>\u0011\u0001C\u0012:p[V#6\tV5nKN$\u0018-\u001c9\u000b\u0005\r!\u0011aC3yaJ,7o]5p]NT!!\u0002\u0004\u0002\u0011\r\fG/\u00197zgRT!a\u0002\u0005\u0002\u0007M\fHN\u0003\u0002\n\u0015\u0005)1\u000f]1sW*\u00111\u0002D\u0001\u0007CB\f7\r[3\u000b\u00035\t1a\u001c:h\u0007\u0001\u0019R\u0001\u0001\t\u0015/u\u0001\"!\u0005\n\u000e\u0003\tI!a\u0005\u0002\u0003!\tKg.\u0019:z\u000bb\u0004(/Z:tS>t\u0007CA\t\u0016\u0013\t1\"A\u0001\fJ[Bd\u0017nY5u\u0007\u0006\u001cH/\u00138qkR$\u0016\u0010]3t!\tA2$D\u0001\u001a\u0015\u0005Q\u0012!B:dC2\f\u0017B\u0001\u000f\u001a\u0005\u001d\u0001&o\u001c3vGR\u0004\"\u0001\u0007\u0010\n\u0005}I\"\u0001D*fe&\fG.\u001b>bE2,\u0007\u0002C\u0011\u0001\u0005+\u0007I\u0011\u0001\u0012\u0002\t1,g\r^\u000b\u0002GA\u0011\u0011\u0003J\u0005\u0003K\t\u0011!\"\u0012=qe\u0016\u001c8/[8o\u0011!9\u0003A!E!\u0002\u0013\u0019\u0013!\u00027fMR\u0004\u0003\u0002C\u0015\u0001\u0005+\u0007I\u0011\u0001\u0012\u0002\u000bILw\r\u001b;\t\u0011-\u0002!\u0011#Q\u0001\n\r\naA]5hQR\u0004\u0003\"B\u0017\u0001\t\u0003q\u0013A\u0002\u001fj]&$h\bF\u00020aE\u0002\"!\u0005\u0001\t\u000b\u0005b\u0003\u0019A\u0012\t\u000b%b\u0003\u0019A\u0012\t\u000bM\u0002A\u0011\t\u001b\u0002\u0015%t\u0007/\u001e;UsB,7/F\u00016!\r1d(\u0011\b\u0003oqr!\u0001O\u001e\u000e\u0003eR!A\u000f\b\u0002\rq\u0012xn\u001c;?\u0013\u0005Q\u0012BA\u001f\u001a\u0003\u001d\u0001\u0018mY6bO\u0016L!a\u0010!\u0003\u0007M+\u0017O\u0003\u0002>3A\u0011!)R\u0007\u0002\u0007*\u0011AIB\u0001\u0006if\u0004Xm]\u0005\u0003\r\u000e\u0013\u0001#\u00112tiJ\f7\r\u001e#bi\u0006$\u0016\u0010]3\t\u000b!\u0003A\u0011I%\u0002\u0011\u0011\fG/\u0019+za\u0016,\u0012A\u0013\t\u0003\u0005.K!\u0001T\"\u0003\u0011\u0011\u000bG/\u0019+za\u0016DQA\u0014\u0001\u0005B=\u000b!\u0002\u001d:fiRLh*Y7f+\u0005\u0001\u0006CA)U\u001d\tA\"+\u0003\u0002T3\u00051\u0001K]3eK\u001aL!!\u0016,\u0003\rM#(/\u001b8h\u0015\t\u0019\u0016\u0004C\u0003Y\u0001\u0011\u0005\u0013,\u0001\u0007ok2d7+\u00194f\u000bZ\fG\u000eF\u0002[;~\u0003\"\u0001G.\n\u0005qK\"aA!os\")al\u0016a\u00015\u0006!A/[7f\u0011\u0015\u0001w\u000b1\u0001[\u0003!!\u0018.\\3{_:,\u0007\"\u00022\u0001\t\u0003\u001a\u0017!\u00033p\u000f\u0016t7i\u001c3f)\r!'n\u001c\t\u0003K\"l\u0011A\u001a\u0006\u0003O\n\tqaY8eK\u001e,g.\u0003\u0002jM\nAQ\t\u001f9s\u0007>$W\rC\u0003lC\u0002\u0007A.A\u0002dib\u0004\"!Z7\n\u000594'AD\"pI\u0016<WM\\\"p]R,\u0007\u0010\u001e\u0005\u0006a\u0006\u0004\r\u0001Z\u0001\u0003KZDqA\u001d\u0001\u0002\u0002\u0013\u00051/\u0001\u0003d_BLHcA\u0018uk\"9\u0011%\u001dI\u0001\u0002\u0004\u0019\u0003bB\u0015r!\u0003\u0005\ra\t\u0005\bo\u0002\t\n\u0011\"\u0001y\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\u0012!\u001f\u0016\u0003Gi\\\u0013a\u001f\t\u0004y\u0006\rQ\"A?\u000b\u0005y|\u0018!C;oG\",7m[3e\u0015\r\t\t!G\u0001\u000bC:tw\u000e^1uS>t\u0017bAA\u0003{\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0011\u0005%\u0001!%A\u0005\u0002a\fabY8qs\u0012\"WMZ1vYR$#\u0007C\u0005\u0002\u000e\u0001\t\t\u0011\"\u0011\u0002\u0010\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"!!\u0005\u0011\t\u0005M\u0011QD\u0007\u0003\u0003+QA!a\u0006\u0002\u001a\u0005!A.\u00198h\u0015\t\tY\"\u0001\u0003kCZ\f\u0017bA+\u0002\u0016!I\u0011\u0011\u0005\u0001\u0002\u0002\u0013\u0005\u00111E\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003K\u00012\u0001GA\u0014\u0013\r\tI#\u0007\u0002\u0004\u0013:$\b\"CA\u0017\u0001\u0005\u0005I\u0011AA\u0018\u00039\u0001(o\u001c3vGR,E.Z7f]R$2AWA\u0019\u0011)\t\u0019$a\u000b\u0002\u0002\u0003\u0007\u0011QE\u0001\u0004q\u0012\n\u0004\"CA\u001c\u0001\u0005\u0005I\u0011IA\u001d\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAA\u001e!\u0015\ti$a\u0011[\u001b\t\tyDC\u0002\u0002Be\t!bY8mY\u0016\u001cG/[8o\u0013\u0011\t)%a\u0010\u0003\u0011%#XM]1u_JD\u0011\"!\u0013\u0001\u0003\u0003%\t!a\u0013\u0002\u0011\r\fg.R9vC2$B!!\u0014\u0002TA\u0019\u0001$a\u0014\n\u0007\u0005E\u0013DA\u0004C_>dW-\u00198\t\u0013\u0005M\u0012qIA\u0001\u0002\u0004Q\u0006\"CA,\u0001\u0005\u0005I\u0011IA-\u0003\u0019)\u0017/^1mgR!\u0011QJA.\u0011%\t\u0019$!\u0016\u0002\u0002\u0003\u0007!\fK\u0004\u0001\u0003?\n)'a\u001a\u0011\u0007E\t\t'C\u0002\u0002d\t\u0011Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0002j\u0005\u0019wLR+O\u0007~CC/[7fgR\fW\u000e\u001d\u0017!gR\u0014\u0018N\\4!i&lWM_8oK&\u0002S\u0006I!tgVlWm\u001d\u0011hSZ,g\u000e\t;j[\u0016\u001cH/Y7qA%\u001c\b%\u0016+DA\u0005tG\rI2p]Z,'\u000f^:!i>\u0004s-\u001b<f]\u0002\"\u0018.\\3{_:,gfB\u0005\u0002n\t\t\t\u0011#\u0001\u0002p\u0005\u0001bI]8n+R\u001bE+[7fgR\fW\u000e\u001d\t\u0004#\u0005Ed\u0001C\u0001\u0003\u0003\u0003E\t!a\u001d\u0014\u000b\u0005E\u0014QO\u000f\u0011\u000f\u0005]\u0014QP\u0012$_5\u0011\u0011\u0011\u0010\u0006\u0004\u0003wJ\u0012a\u0002:v]RLW.Z\u0005\u0005\u0003\u007f\nIHA\tBEN$(/Y2u\rVt7\r^5p]JBq!LA9\t\u0003\t\u0019\t\u0006\u0002\u0002p!Q\u0011qQA9\u0003\u0003%)%!#\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!!\u0005\t\u0015\u00055\u0015\u0011OA\u0001\n\u0003\u000by)A\u0003baBd\u0017\u0010F\u00030\u0003#\u000b\u0019\n\u0003\u0004\"\u0003\u0017\u0003\ra\t\u0005\u0007S\u0005-\u0005\u0019A\u0012\t\u0015\u0005]\u0015\u0011OA\u0001\n\u0003\u000bI*A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u0005m\u0015q\u0015\t\u00061\u0005u\u0015\u0011U\u0005\u0004\u0003?K\"AB(qi&|g\u000eE\u0003\u0019\u0003G\u001b3%C\u0002\u0002&f\u0011a\u0001V;qY\u0016\u0014\u0004\"CAU\u0003+\u000b\t\u00111\u00010\u0003\rAH\u0005\r\u0005\u000b\u0003[\u000b\t(!A\u0005\n\u0005=\u0016a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!!-\u0011\t\u0005M\u00111W\u0005\u0005\u0003k\u000b)B\u0001\u0004PE*,7\r\u001e")
public class FromUTCTimestamp
extends BinaryExpression
implements ImplicitCastInputTypes,
Serializable {
    private final Expression left;
    private final Expression right;

    public static Function1<Tuple2<Expression, Expression>, FromUTCTimestamp> tupled() {
        return FromUTCTimestamp$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, FromUTCTimestamp>> curried() {
        return FromUTCTimestamp$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes$class.checkInputDataTypes(this);
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AtomicType[]{TimestampType$.MODULE$, StringType$.MODULE$}));
    }

    @Override
    public DataType dataType() {
        return TimestampType$.MODULE$;
    }

    @Override
    public String prettyName() {
        return "from_utc_timestamp";
    }

    @Override
    public Object nullSafeEval(Object time, Object timezone) {
        return BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.fromUTCTime(BoxesRunTime.unboxToLong((Object)time), ((UTF8String)timezone).toString()));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode exprCode;
        String dtu = new StringOps(Predef$.MODULE$.augmentString(DateTimeUtils$.MODULE$.getClass().getName())).stripSuffix("$");
        if (this.right().foldable()) {
            Object tz = this.right().eval(this.right().eval$default$1());
            if (tz == null) {
                exprCode = ev.copy(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           |boolean ", " = true;\n           |long ", " = 0;\n         "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ev.isNull(), ev.value()})))).stripMargin(), ev.copy$default$2(), ev.copy$default$3());
            } else {
                String tzTerm = ctx.freshName("tz");
                String utcTerm = ctx.freshName("utc");
                String tzClass = TimeZone.class.getName();
                ctx.addMutableState(tzClass, tzTerm, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = ", ".getTimeZone(\"", "\");"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tzTerm, tzClass, tz})));
                ctx.addMutableState(tzClass, utcTerm, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = ", ".getTimeZone(\"UTC\");"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{utcTerm, tzClass})));
                ExprCode eval2 = this.left().genCode(ctx);
                exprCode = ev.copy(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           |", "\n           |boolean ", " = ", ";\n           |long ", " = 0;\n           |if (!", ") {\n           |  ", " = ", ".convertTz(", ", ", ", ", ");\n           |}\n         "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{eval2.code(), ev.isNull(), eval2.isNull(), ev.value(), ev.isNull(), ev.value(), dtu, eval2.value(), utcTerm, tzTerm})))).stripMargin(), ev.copy$default$2(), ev.copy$default$3());
            }
        } else {
            exprCode = this.defineCodeGen(ctx, ev, (Function2<String, String, String>)new Serializable(this, dtu){
                public static final long serialVersionUID = 0L;
                private final String dtu$11;

                public final String apply(String timestamp, String format2) {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".fromUTCTime(", ", ", ".toString())"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.dtu$11, timestamp, format2}));
                }
                {
                    this.dtu$11 = dtu$11;
                }
            });
        }
        return exprCode;
    }

    public FromUTCTimestamp copy(Expression left, Expression right) {
        return new FromUTCTimestamp(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "FromUTCTimestamp";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 1: {
                expression = this.right();
                break;
            }
            case 0: {
                expression = this.left();
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof FromUTCTimestamp;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof FromUTCTimestamp)) return false;
        boolean bl = true;
        if (!bl) return false;
        FromUTCTimestamp fromUTCTimestamp = (FromUTCTimestamp)x$1;
        Expression expression = this.left();
        Expression expression2 = fromUTCTimestamp.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = fromUTCTimestamp.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!fromUTCTimestamp.canEqual(this)) return false;
        return true;
    }

    public FromUTCTimestamp(Expression left, Expression right) {
        this.left = left;
        this.right = right;
        ExpectsInputTypes$class.$init$(this);
    }
}

