/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.expressions.Add;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeReference$;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Divide;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.GreaterThanOrEqual;
import org.apache.spark.sql.catalyst.expressions.If;
import org.apache.spark.sql.catalyst.expressions.LessThan;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.NTile$;
import org.apache.spark.sql.catalyst.expressions.Remainder;
import org.apache.spark.sql.catalyst.expressions.RowNumberLike;
import org.apache.spark.sql.catalyst.expressions.SizeBasedWindowFunction;
import org.apache.spark.sql.catalyst.expressions.SizeBasedWindowFunction$class;
import org.apache.spark.sql.catalyst.expressions.aggregate.NoOp$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.Metadata;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(x) - The NTILE(n) function divides the rows for each window partition\n     into 'n' buckets ranging from 1 to at most 'n'.")
@ScalaSignature(bytes="\u0006\u0001\u00055g\u0001B\u0001\u0003\u0001>\u0011QA\u0014+jY\u0016T!a\u0001\u0003\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003\u000b\u0019\t\u0001bY1uC2L8\u000f\u001e\u0006\u0003\u000f!\t1a]9m\u0015\tI!\"A\u0003ta\u0006\u00148N\u0003\u0002\f\u0019\u00051\u0011\r]1dQ\u0016T\u0011!D\u0001\u0004_J<7\u0001A\n\u0006\u0001A!r#\b\t\u0003#Ii\u0011AA\u0005\u0003'\t\u0011QBU8x\u001dVl'-\u001a:MS.,\u0007CA\t\u0016\u0013\t1\"AA\fTSj,')Y:fI^Kg\u000eZ8x\rVt7\r^5p]B\u0011\u0001dG\u0007\u00023)\t!$A\u0003tG\u0006d\u0017-\u0003\u0002\u001d3\t9\u0001K]8ek\u000e$\bC\u0001\r\u001f\u0013\ty\u0012D\u0001\u0007TKJL\u0017\r\\5{C\ndW\r\u0003\u0005\"\u0001\tU\r\u0011\"\u0001#\u0003\u001d\u0011WoY6fiN,\u0012a\t\t\u0003#\u0011J!!\n\u0002\u0003\u0015\u0015C\bO]3tg&|g\u000e\u0003\u0005(\u0001\tE\t\u0015!\u0003$\u0003!\u0011WoY6fiN\u0004\u0003\"B\u0015\u0001\t\u0003Q\u0013A\u0002\u001fj]&$h\b\u0006\u0002,YA\u0011\u0011\u0003\u0001\u0005\u0006C!\u0002\ra\t\u0005\u0006S\u0001!\tA\f\u000b\u0002W!)\u0001\u0007\u0001C!c\u0005A1\r[5mIJ,g.F\u00013!\r\u00194h\t\b\u0003ier!!\u000e\u001d\u000e\u0003YR!a\u000e\b\u0002\rq\u0012xn\u001c;?\u0013\u0005Q\u0012B\u0001\u001e\u001a\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001P\u001f\u0003\u0007M+\u0017O\u0003\u0002;3!)q\b\u0001C!\u0001\u0006\u00192\r[3dW&s\u0007/\u001e;ECR\fG+\u001f9fgR\t\u0011\t\u0005\u0002C\u000b6\t1I\u0003\u0002E\t\u0005A\u0011M\\1msNL7/\u0003\u0002G\u0007\nyA+\u001f9f\u0007\",7m\u001b*fgVdG\u000fC\u0004I\u0001\t\u0007I\u0011B%\u0002\r\t,8m[3u+\u0005Q\u0005CA\tL\u0013\ta%A\u0001\nBiR\u0014\u0018NY;uKJ+g-\u001a:f]\u000e,\u0007B\u0002(\u0001A\u0003%!*A\u0004ck\u000e\\W\r\u001e\u0011\t\u000fA\u0003!\u0019!C\u0005\u0013\u0006y!-^2lKR$\u0006N]3tQ>dG\r\u0003\u0004S\u0001\u0001\u0006IAS\u0001\u0011EV\u001c7.\u001a;UQJ,7\u000f[8mI\u0002Bq\u0001\u0016\u0001C\u0002\u0013%\u0011*\u0001\u0006ck\u000e\\W\r^*ju\u0016DaA\u0016\u0001!\u0002\u0013Q\u0015a\u00032vG.,GoU5{K\u0002Bq\u0001\u0017\u0001C\u0002\u0013%\u0011*\u0001\nck\u000e\\W\r^:XSRD\u0007+\u00193eS:<\u0007B\u0002.\u0001A\u0003%!*A\nck\u000e\\W\r^:XSRD\u0007+\u00193eS:<\u0007\u0005C\u0003]\u0001\u0011%Q,\u0001\bck\u000e\\W\r^(wKJ4Gn\\<\u0015\u0005y\u000b\u0007CA\t`\u0013\t\u0001'A\u0001\u0002JM\")!m\u0017a\u0001G\u0005\tQ\rC\u0004e\u0001\t\u0007I\u0011I3\u0002'\u0005<wMQ;gM\u0016\u0014\u0018\t\u001e;sS\n,H/Z:\u0016\u0003\u0019\u00042a\u001a6K\u001b\u0005A'BA5\u001a\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003y!Da\u0001\u001c\u0001!\u0002\u00131\u0017\u0001F1hO\n+hMZ3s\u0003R$(/\u001b2vi\u0016\u001c\b\u0005C\u0004o\u0001\t\u0007I\u0011I8\u0002\u001b%t\u0017\u000e^5bYZ\u000bG.^3t+\u0005\u0001\bcA4kcJ\u0019!oI\u000f\u0007\tM\u0004\u0001!\u001d\u0002\ryI,g-\u001b8f[\u0016tGO\u0010\u0005\u0007k\u0002\u0001\u000b\u0011\u00029\u0002\u001d%t\u0017\u000e^5bYZ\u000bG.^3tA!9q\u000f\u0001b\u0001\n\u0003B\u0018!E;qI\u0006$X-\u0012=qe\u0016\u001c8/[8ogV\t\u0011\u0010E\u0002hUj\u00142a_\u0012\u001e\r\u0011\u0019\b\u0001\u0001>\t\ru\u0004\u0001\u0015!\u0003z\u0003I)\b\u000fZ1uK\u0016C\bO]3tg&|gn\u001d\u0011\t\u000f}\u0004!\u0019!C!\u0013\u0006\u0011RM^1mk\u0006$X-\u0012=qe\u0016\u001c8/[8o\u0011\u001d\t\u0019\u0001\u0001Q\u0001\n)\u000b1#\u001a<bYV\fG/Z#yaJ,7o]5p]\u0002B\u0011\"a\u0002\u0001\u0003\u0003%\t!!\u0003\u0002\t\r|\u0007/\u001f\u000b\u0004W\u0005-\u0001\u0002C\u0011\u0002\u0006A\u0005\t\u0019A\u0012\t\u0013\u0005=\u0001!%A\u0005\u0002\u0005E\u0011AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003'Q3aIA\u000bW\t\t9\u0002\u0005\u0003\u0002\u001a\u0005\rRBAA\u000e\u0015\u0011\ti\"a\b\u0002\u0013Ut7\r[3dW\u0016$'bAA\u00113\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005\u0015\u00121\u0004\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007\"CA\u0015\u0001\u0005\u0005I\u0011IA\u0016\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011Q\u0006\t\u0005\u0003_\tI$\u0004\u0002\u00022)!\u00111GA\u001b\u0003\u0011a\u0017M\\4\u000b\u0005\u0005]\u0012\u0001\u00026bm\u0006LA!a\u000f\u00022\t11\u000b\u001e:j]\u001eD\u0011\"a\u0010\u0001\u0003\u0003%\t!!\u0011\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005\r\u0003c\u0001\r\u0002F%\u0019\u0011qI\r\u0003\u0007%sG\u000fC\u0005\u0002L\u0001\t\t\u0011\"\u0001\u0002N\u0005q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BA(\u0003+\u00022\u0001GA)\u0013\r\t\u0019&\u0007\u0002\u0004\u0003:L\bBCA,\u0003\u0013\n\t\u00111\u0001\u0002D\u0005\u0019\u0001\u0010J\u0019\t\u0013\u0005m\u0003!!A\u0005B\u0005u\u0013a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005}\u0003#B4\u0002b\u0005=\u0013bAA2Q\nA\u0011\n^3sCR|'\u000fC\u0005\u0002h\u0001\t\t\u0011\"\u0001\u0002j\u0005A1-\u00198FcV\fG\u000e\u0006\u0003\u0002l\u0005E\u0004c\u0001\r\u0002n%\u0019\u0011qN\r\u0003\u000f\t{w\u000e\\3b]\"Q\u0011qKA3\u0003\u0003\u0005\r!a\u0014\t\u0013\u0005U\u0004!!A\u0005B\u0005]\u0014AB3rk\u0006d7\u000f\u0006\u0003\u0002l\u0005e\u0004BCA,\u0003g\n\t\u00111\u0001\u0002P!:\u0001!! \u0002\u0004\u0006\u0015\u0005cA\t\u0002\u0000%\u0019\u0011\u0011\u0011\u0002\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012\u0011qQ\u0001\u0002\u0004}3UKT\"`QaL\u0003%\f\u0011UQ\u0016\u0004c\nV%M\u000b\"r\u0017\u0006\t4v]\u000e$\u0018n\u001c8!I&4\u0018\u000eZ3tAQDW\r\t:poN\u0004cm\u001c:!K\u0006\u001c\u0007\u000eI<j]\u0012|w\u000f\t9beRLG/[8o\u0015\u0001\u0002\u0003\u0005\t\u0011j]R|\u0007e\n8(A\t,8m[3ug\u0002\u0012\u0018M\\4j]\u001e\u0004cM]8nAE\u0002Co\u001c\u0011bi\u0002jwn\u001d;!O9<cfB\u0005\u0002\f\n\t\t\u0011#\u0001\u0002\u000e\u0006)a\nV5mKB\u0019\u0011#a$\u0007\u0011\u0005\u0011\u0011\u0011!E\u0001\u0003#\u001bR!a$\u0002\u0014v\u0001b!!&\u0002\u001c\u000eZSBAAL\u0015\r\tI*G\u0001\beVtG/[7f\u0013\u0011\ti*a&\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t\u0017\u0007C\u0004*\u0003\u001f#\t!!)\u0015\u0005\u00055\u0005BCAS\u0003\u001f\u000b\t\u0011\"\u0012\u0002(\u0006AAo\\*ue&tw\r\u0006\u0002\u0002.!Q\u00111VAH\u0003\u0003%\t)!,\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0007-\ny\u000b\u0003\u0004\"\u0003S\u0003\ra\t\u0005\u000b\u0003g\u000by)!A\u0005\u0002\u0006U\u0016aB;oCB\u0004H.\u001f\u000b\u0005\u0003o\u000bi\f\u0005\u0003\u0019\u0003s\u001b\u0013bAA^3\t1q\n\u001d;j_:D\u0011\"a0\u00022\u0006\u0005\t\u0019A\u0016\u0002\u0007a$\u0003\u0007\u0003\u0006\u0002D\u0006=\u0015\u0011!C\u0005\u0003\u000b\f1B]3bIJ+7o\u001c7wKR\u0011\u0011q\u0019\t\u0005\u0003_\tI-\u0003\u0003\u0002L\u0006E\"AB(cU\u0016\u001cG\u000f")
public class NTile
extends RowNumberLike
implements SizeBasedWindowFunction {
    private final Expression buckets;
    private final AttributeReference bucket;
    private final AttributeReference bucketThreshold;
    private final AttributeReference bucketSize;
    private final AttributeReference bucketsWithPadding;
    private final Seq<AttributeReference> aggBufferAttributes;
    private final Seq<Expression> initialValues;
    private final Seq<Expression> updateExpressions;
    private final AttributeReference evaluateExpression;
    private final AttributeReference n;

    public static <A> Function1<Expression, A> andThen(Function1<NTile, A> function1) {
        return NTile$.MODULE$.andThen(function1);
    }

    public static <A> Function1<A, NTile> compose(Function1<A, Expression> function1) {
        return NTile$.MODULE$.compose(function1);
    }

    @Override
    public AttributeReference n() {
        return this.n;
    }

    @Override
    public void org$apache$spark$sql$catalyst$expressions$SizeBasedWindowFunction$_setter_$n_$eq(AttributeReference x$1) {
        this.n = x$1;
    }

    public Expression buckets() {
        return this.buckets;
    }

    @Override
    public Seq<Expression> children() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.buckets()}));
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        if (this.buckets().foldable()) {
            DataType dataType2 = this.buckets().dataType();
            IntegerType$ integerType$ = IntegerType$.MODULE$;
            if (!(dataType2 != null ? !dataType2.equals(integerType$) : integerType$ != null)) {
                int i = BoxesRunTime.unboxToInt((Object)this.buckets().eval(this.buckets().eval$default$1()));
                return i > 0 ? TypeCheckResult$TypeCheckSuccess$.MODULE$ : new TypeCheckResult.TypeCheckFailure(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Buckets expression must be positive, but got: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})));
            }
            return new TypeCheckResult.TypeCheckFailure(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Buckets expression must be integer type, but got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.buckets()})));
        }
        return new TypeCheckResult.TypeCheckFailure(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Buckets expression must be foldable, but got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.buckets()})));
    }

    private AttributeReference bucket() {
        return this.bucket;
    }

    private AttributeReference bucketThreshold() {
        return this.bucketThreshold;
    }

    private AttributeReference bucketSize() {
        return this.bucketSize;
    }

    private AttributeReference bucketsWithPadding() {
        return this.bucketsWithPadding;
    }

    private If bucketOverflow(Expression e) {
        return new If(new GreaterThanOrEqual(this.rowNumber(), this.bucketThreshold()), e, this.zero());
    }

    @Override
    public Seq<AttributeReference> aggBufferAttributes() {
        return this.aggBufferAttributes;
    }

    @Override
    public Seq<Expression> initialValues() {
        return this.initialValues;
    }

    @Override
    public Seq<Expression> updateExpressions() {
        return this.updateExpressions;
    }

    @Override
    public AttributeReference evaluateExpression() {
        return this.evaluateExpression;
    }

    public NTile copy(Expression buckets) {
        return new NTile(buckets);
    }

    public Expression copy$default$1() {
        return this.buckets();
    }

    @Override
    public String productPrefix() {
        return "NTile";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 0: 
        }
        return this.buckets();
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof NTile;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof NTile)) return false;
        boolean bl = true;
        if (!bl) return false;
        NTile nTile = (NTile)x$1;
        Expression expression = this.buckets();
        Expression expression2 = nTile.buckets();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!nTile.canEqual(this)) return false;
        return true;
    }

    public NTile(Expression buckets) {
        this.buckets = buckets;
        SizeBasedWindowFunction$class.$init$(this);
        String x$32 = "bucket";
        IntegerType$ x$33 = IntegerType$.MODULE$;
        boolean x$34 = false;
        Metadata x$35 = AttributeReference$.MODULE$.apply$default$4();
        ExprId x$36 = AttributeReference$.MODULE$.apply$default$5(x$32, x$33, x$34, x$35);
        Option<String> x$37 = AttributeReference$.MODULE$.apply$default$6(x$32, x$33, x$34, x$35);
        Boolean x$38 = AttributeReference$.MODULE$.apply$default$7(x$32, x$33, x$34, x$35);
        this.bucket = new AttributeReference(x$32, x$33, x$34, x$35, x$36, x$37, x$38);
        String x$39 = "bucketThreshold";
        IntegerType$ x$40 = IntegerType$.MODULE$;
        boolean x$41 = false;
        Metadata x$42 = AttributeReference$.MODULE$.apply$default$4();
        ExprId x$43 = AttributeReference$.MODULE$.apply$default$5(x$39, x$40, x$41, x$42);
        Option<String> x$44 = AttributeReference$.MODULE$.apply$default$6(x$39, x$40, x$41, x$42);
        Boolean x$45 = AttributeReference$.MODULE$.apply$default$7(x$39, x$40, x$41, x$42);
        this.bucketThreshold = new AttributeReference(x$39, x$40, x$41, x$42, x$43, x$44, x$45);
        String x$46 = "bucketSize";
        IntegerType$ x$47 = IntegerType$.MODULE$;
        boolean x$48 = false;
        Metadata x$49 = AttributeReference$.MODULE$.apply$default$4();
        ExprId x$50 = AttributeReference$.MODULE$.apply$default$5(x$46, x$47, x$48, x$49);
        Option<String> x$51 = AttributeReference$.MODULE$.apply$default$6(x$46, x$47, x$48, x$49);
        Boolean x$52 = AttributeReference$.MODULE$.apply$default$7(x$46, x$47, x$48, x$49);
        this.bucketSize = new AttributeReference(x$46, x$47, x$48, x$49, x$50, x$51, x$52);
        String x$53 = "bucketsWithPadding";
        IntegerType$ x$54 = IntegerType$.MODULE$;
        boolean x$55 = false;
        Metadata x$56 = AttributeReference$.MODULE$.apply$default$4();
        ExprId x$57 = AttributeReference$.MODULE$.apply$default$5(x$53, x$54, x$55, x$56);
        Option<String> x$58 = AttributeReference$.MODULE$.apply$default$6(x$53, x$54, x$55, x$56);
        Boolean x$59 = AttributeReference$.MODULE$.apply$default$7(x$53, x$54, x$55, x$56);
        this.bucketsWithPadding = new AttributeReference(x$53, x$54, x$55, x$56, x$57, x$58, x$59);
        this.aggBufferAttributes = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AttributeReference[]{this.rowNumber(), this.bucket(), this.bucketThreshold(), this.bucketSize(), this.bucketsWithPadding()}));
        this.initialValues = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.zero(), this.zero(), this.zero(), new Cast(new Divide(this.n(), buckets), IntegerType$.MODULE$), new Cast(new Remainder(this.n(), buckets), IntegerType$.MODULE$)}));
        this.updateExpressions = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{new Add(this.rowNumber(), this.one()), new Add(this.bucket(), this.bucketOverflow(this.one())), new Add(this.bucketThreshold(), this.bucketOverflow(new Add(this.bucketSize(), new If(new LessThan(this.bucket(), this.bucketsWithPadding()), this.one(), this.zero())))), NoOp$.MODULE$, NoOp$.MODULE$}));
        this.evaluateExpression = this.bucket();
    }

    public NTile() {
        this(Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)1)));
    }
}

