/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive.execution;

import java.io.IOException;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.exec.TaskRunner;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.spark.SparkException;
import org.apache.spark.TaskContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.catalog.CatalogTablePartition;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.physical.Partitioning;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.UnaryExecNode;
import org.apache.spark.sql.hive.HiveSessionState;
import org.apache.spark.sql.hive.HiveShim;
import org.apache.spark.sql.hive.HiveShim$;
import org.apache.spark.sql.hive.MetastoreRelation;
import org.apache.spark.sql.hive.SparkHiveDynamicPartitionWriterContainer;
import org.apache.spark.sql.hive.SparkHiveWriterContainer;
import org.apache.spark.sql.hive.SparkHiveWriterContainer$;
import org.apache.spark.sql.hive.client.HiveClient;
import org.apache.spark.sql.hive.execution.InsertIntoHiveTable$;
import org.apache.spark.util.SerializableJobConf;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple5;
import scala.collection.GenIterable;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\tEh\u0001B\u0001\u0003\u0001>\u00111#\u00138tKJ$\u0018J\u001c;p\u0011&4X\rV1cY\u0016T!a\u0001\u0003\u0002\u0013\u0015DXmY;uS>t'BA\u0003\u0007\u0003\u0011A\u0017N^3\u000b\u0005\u001dA\u0011aA:rY*\u0011\u0011BC\u0001\u0006gB\f'o\u001b\u0006\u0003\u00171\ta!\u00199bG\",'\"A\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0014\u000b\u0001\u0001R\u0003\u0007\u0010\u0011\u0005E\u0019R\"\u0001\n\u000b\u0005\r1\u0011B\u0001\u000b\u0013\u0005%\u0019\u0006/\u0019:l!2\fg\u000e\u0005\u0002\u0012-%\u0011qC\u0005\u0002\u000e+:\f'/_#yK\u000etu\u000eZ3\u0011\u0005eaR\"\u0001\u000e\u000b\u0003m\tQa]2bY\u0006L!!\b\u000e\u0003\u000fA\u0013x\u000eZ;diB\u0011\u0011dH\u0005\u0003Ai\u0011AbU3sS\u0006d\u0017N_1cY\u0016D\u0001B\t\u0001\u0003\u0016\u0004%\taI\u0001\u0006i\u0006\u0014G.Z\u000b\u0002IA\u0011QEJ\u0007\u0002\t%\u0011q\u0005\u0002\u0002\u0012\u001b\u0016$\u0018m\u001d;pe\u0016\u0014V\r\\1uS>t\u0007\u0002C\u0015\u0001\u0005#\u0005\u000b\u0011\u0002\u0013\u0002\rQ\f'\r\\3!\u0011!Y\u0003A!f\u0001\n\u0003a\u0013!\u00039beRLG/[8o+\u0005i\u0003\u0003\u0002\u00182i]r!!G\u0018\n\u0005AR\u0012A\u0002)sK\u0012,g-\u0003\u00023g\t\u0019Q*\u00199\u000b\u0005AR\u0002C\u0001\u00186\u0013\t14G\u0001\u0004TiJLgn\u001a\t\u00043a\"\u0014BA\u001d\u001b\u0005\u0019y\u0005\u000f^5p]\"A1\b\u0001B\tB\u0003%Q&\u0001\u0006qCJ$\u0018\u000e^5p]\u0002B\u0001\"\u0010\u0001\u0003\u0016\u0004%\tAP\u0001\u0006G\"LG\u000eZ\u000b\u0002!!A\u0001\t\u0001B\tB\u0003%\u0001#\u0001\u0004dQ&dG\r\t\u0005\t\u0005\u0002\u0011)\u001a!C\u0001\u0007\u0006IqN^3soJLG/Z\u000b\u0002\tB\u0011\u0011$R\u0005\u0003\rj\u0011qAQ8pY\u0016\fg\u000e\u0003\u0005I\u0001\tE\t\u0015!\u0003E\u0003)yg/\u001a:xe&$X\r\t\u0005\t\u0015\u0002\u0011)\u001a!C\u0001\u0007\u0006Y\u0011N\u001a(pi\u0016C\u0018n\u001d;t\u0011!a\u0005A!E!\u0002\u0013!\u0015\u0001D5g\u001d>$X\t_5tiN\u0004\u0003\"\u0002(\u0001\t\u0003y\u0015A\u0002\u001fj]&$h\b\u0006\u0004Q%N#VK\u0016\t\u0003#\u0002i\u0011A\u0001\u0005\u0006E5\u0003\r\u0001\n\u0005\u0006W5\u0003\r!\f\u0005\u0006{5\u0003\r\u0001\u0005\u0005\u0006\u00056\u0003\r\u0001\u0012\u0005\u0006\u00156\u0003\r\u0001\u0012\u0005\b1\u0002\u0011\r\u0011\"\u0003Z\u00031\u0019Xm]:j_:\u001cF/\u0019;f+\u0005Q\u0006CA\u0013\\\u0013\taFA\u0001\tISZ,7+Z:tS>t7\u000b^1uK\"1a\f\u0001Q\u0001\ni\u000bQb]3tg&|gn\u0015;bi\u0016\u0004\u0003FA/a!\tI\u0012-\u0003\u0002c5\tIAO]1og&,g\u000e\u001e\u0005\bI\u0002\u0011\r\u0011\"\u0003f\u0003\u0019\u0019G.[3oiV\ta\r\u0005\u0002hS6\t\u0001N\u0003\u0002e\t%\u0011!\u000e\u001b\u0002\u000b\u0011&4Xm\u00117jK:$\bB\u00027\u0001A\u0003%a-A\u0004dY&,g\u000e\u001e\u0011)\u0005-\u0004\u0007\"B8\u0001\t\u0003\u0001\u0018AB8viB,H/F\u0001r!\r\u0011(0 \b\u0003gbt!\u0001^<\u000e\u0003UT!A\u001e\b\u0002\rq\u0012xn\u001c;?\u0013\u0005Y\u0012BA=\u001b\u0003\u001d\u0001\u0018mY6bO\u0016L!a\u001f?\u0003\u0007M+\u0017O\u0003\u0002z5A\u0019a0a\u0002\u000e\u0003}TA!!\u0001\u0002\u0004\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\r\t)AB\u0001\tG\u0006$\u0018\r\\=ti&\u0019\u0011\u0011B@\u0003\u0013\u0005#HO]5ckR,\u0007\"CA\u0007\u0001\t\u0007I\u0011AA\b\u0003)\u0019H/Y4j]\u001e$\u0015N]\u000b\u0002i!9\u00111\u0003\u0001!\u0002\u0013!\u0014aC:uC\u001eLgn\u001a#je\u0002Bq!a\u0006\u0001\t\u0013\ty!A\u0006fq\u0016\u001cW\u000f^5p]&#\u0007bBA\u000e\u0001\u0011%\u0011QD\u0001\u000eO\u0016$8\u000b^1hS:<G)\u001b:\u0015\r\u0005}\u0011qFA\u001a!\u0011\t\t#a\u000b\u000e\u0005\u0005\r\"\u0002BA\u0013\u0003O\t!AZ:\u000b\u0007\u0005%\"\"\u0001\u0004iC\u0012|w\u000e]\u0005\u0005\u0003[\t\u0019C\u0001\u0003QCRD\u0007\u0002CA\u0019\u00033\u0001\r!a\b\u0002\u0013%t\u0007/\u001e;QCRD\u0007\u0002CA\u001b\u00033\u0001\r!a\u000e\u0002\u0015!\fGm\\8q\u0007>tg\r\u0005\u0003\u0002:\u0005}RBAA\u001e\u0015\u0011\ti$a\n\u0002\t\r|gNZ\u0005\u0005\u0003\u0003\nYDA\u0007D_:4\u0017nZ;sCRLwN\u001c\u0005\b\u0003\u000b\u0002A\u0011BA$\u0003U9W\r^#yi\u0016\u0014h.\u00197TGJ\fGo\u00195ESJ$b!a\b\u0002J\u0005u\u0003\u0002CA&\u0003\u0007\u0002\r!!\u0014\u0002\r\u0015DH/\u0016*J!\u0011\ty%!\u0017\u000e\u0005\u0005E#\u0002BA*\u0003+\n1A\\3u\u0015\t\t9&\u0001\u0003kCZ\f\u0017\u0002BA.\u0003#\u00121!\u0016*J\u0011!\t)$a\u0011A\u0002\u0005]\u0002bBA1\u0001\u0011\u0005\u00111M\u0001\u0013O\u0016$X\t\u001f;fe:\fG\u000eV7q!\u0006$\b\u000e\u0006\u0004\u0002 \u0005\u0015\u0014\u0011\u000e\u0005\t\u0003O\ny\u00061\u0001\u0002 \u0005!\u0001/\u0019;i\u0011!\t)$a\u0018A\u0002\u0005]\u0002bBA7\u0001\u0011\u0005\u0011qN\u0001\u0013O\u0016$X\t\u001f;U[B\u0004\u0016\r\u001e5SK2$v\u000e\u0006\u0004\u0002 \u0005E\u00141\u000f\u0005\t\u0003O\nY\u00071\u0001\u0002 !A\u0011QGA6\u0001\u0004\t9\u0004C\u0004\u0002x\u0001!I!!\u001f\u0002\u001dM\fg/Z!t\u0011&4XMR5mKRa\u00111PAA\u0003/\u000bI,a8\u0002nB\u0019\u0011$! \n\u0007\u0005}$D\u0001\u0003V]&$\b\u0002CAB\u0003k\u0002\r!!\"\u0002\u0007I$G\r\u0005\u0004\u0002\b\u0006-\u0015qR\u0007\u0003\u0003\u0013S1!a!\t\u0013\u0011\ti)!#\u0003\u0007I#E\t\u0005\u0003\u0002\u0012\u0006MUBAA\u0002\u0013\u0011\t)*a\u0001\u0003\u0017%sG/\u001a:oC2\u0014vn\u001e\u0005\t\u00033\u000b)\b1\u0001\u0002\u001c\u0006Qa/\u00197vK\u000ec\u0017m]:1\t\u0005u\u0015q\u0015\t\u0006]\u0005}\u00151U\u0005\u0004\u0003C\u001b$!B\"mCN\u001c\b\u0003BAS\u0003Oc\u0001\u0001\u0002\u0007\u0002*\u0006]\u0015\u0011!A\u0001\u0006\u0003\tYKA\u0002`IE\nB!!,\u00024B\u0019\u0011$a,\n\u0007\u0005E&DA\u0004O_RD\u0017N\\4\u0011\u0007e\t),C\u0002\u00028j\u00111!\u00118z\u0011!\tY,!\u001eA\u0002\u0005u\u0016\u0001\u00044jY\u0016\u001c\u0016N\\6D_:4\u0007\u0003BA`\u00033tA!!1\u0002V:!\u00111YAj\u001d\u0011\t)-!5\u000f\t\u0005\u001d\u0017q\u001a\b\u0005\u0003\u0013\fiMD\u0002u\u0003\u0017L\u0011!D\u0005\u0003\u00171I!!\u0003\u0006\n\u0005\u001dA\u0011BA\u0003\u0007\u0013\r\t9\u000eB\u0001\t\u0011&4Xm\u00155j[&!\u00111\\Ao\u0005A\u0019\u0006.[7GS2,7+\u001b8l\t\u0016\u001c8MC\u0002\u0002X\u0012A\u0001\"!\u0010\u0002v\u0001\u0007\u0011\u0011\u001d\t\u0005\u0003G\fI/\u0004\u0002\u0002f*\u0019\u0011q\u001d\u0005\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003W\f)OA\nTKJL\u0017\r\\5{C\ndWMS8c\u0007>tg\r\u0003\u0005\u0002p\u0006U\u0004\u0019AAy\u0003=9(/\u001b;fe\u000e{g\u000e^1j]\u0016\u0014\bcA\u0013\u0002t&\u0019\u0011Q\u001f\u0003\u00031M\u0003\u0018M]6ISZ,wK]5uKJ\u001cuN\u001c;bS:,'\u000fC\u0006\u0002z\u0002A)\u0019!C\t\r\u0005m\u0018\u0001E:jI\u0016,eMZ3diJ+7/\u001e7u+\t\ti\u0010\u0005\u0003su\u0006=\u0005B\u0003B\u0001\u0001!\u0005\t\u0015)\u0003\u0002~\u0006\t2/\u001b3f\u000b\u001a4Wm\u0019;SKN,H\u000e\u001e\u0011\t\u000f\t\u0015\u0001\u0001\"\u0011\u0003\b\u0005qQ\r_3dkR,7i\u001c7mK\u000e$HC\u0001B\u0005!\u0015I\"1BAH\u0013\r\u0011iA\u0007\u0002\u0006\u0003J\u0014\u0018-\u001f\u0005\b\u0005#\u0001A\u0011\u000bB\n\u0003%!w.\u0012=fGV$X\r\u0006\u0002\u0002\u0006\"I!q\u0003\u0001\u0002\u0002\u0013\u0005!\u0011D\u0001\u0005G>\u0004\u0018\u0010F\u0006Q\u00057\u0011iBa\b\u0003\"\t\r\u0002\u0002\u0003\u0012\u0003\u0016A\u0005\t\u0019\u0001\u0013\t\u0011-\u0012)\u0002%AA\u00025B\u0001\"\u0010B\u000b!\u0003\u0005\r\u0001\u0005\u0005\t\u0005\nU\u0001\u0013!a\u0001\t\"A!J!\u0006\u0011\u0002\u0003\u0007A\tC\u0005\u0003(\u0001\t\n\u0011\"\u0001\u0003*\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nTC\u0001B\u0016U\r!#QF\u0016\u0003\u0005_\u0001BA!\r\u0003<5\u0011!1\u0007\u0006\u0005\u0005k\u00119$A\u0005v]\u000eDWmY6fI*\u0019!\u0011\b\u000e\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003>\tM\"!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"I!\u0011\t\u0001\u0012\u0002\u0013\u0005!1I\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\u0011)EK\u0002.\u0005[A\u0011B!\u0013\u0001#\u0003%\tAa\u0013\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%gU\u0011!Q\n\u0016\u0004!\t5\u0002\"\u0003B)\u0001E\u0005I\u0011\u0001B*\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIQ*\"A!\u0016+\u0007\u0011\u0013i\u0003C\u0005\u0003Z\u0001\t\n\u0011\"\u0001\u0003T\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012*\u0004\"\u0003B/\u0001\u0005\u0005I\u0011\tB0\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011!\u0011\r\t\u0005\u0005G\u0012I'\u0004\u0002\u0003f)!!qMA+\u0003\u0011a\u0017M\\4\n\u0007Y\u0012)\u0007C\u0005\u0003n\u0001\t\t\u0011\"\u0001\u0003p\u0005a\u0001O]8ek\u000e$\u0018I]5usV\u0011!\u0011\u000f\t\u00043\tM\u0014b\u0001B;5\t\u0019\u0011J\u001c;\t\u0013\te\u0004!!A\u0005\u0002\tm\u0014A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003g\u0013i\b\u0003\u0006\u0003\u0000\t]\u0014\u0011!a\u0001\u0005c\n1\u0001\u001f\u00132\u0011%\u0011\u0019\tAA\u0001\n\u0003\u0012))A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\u00119\t\u0005\u0004\u0003\n\n=\u00151W\u0007\u0003\u0005\u0017S1A!$\u001b\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0005#\u0013YI\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0011%\u0011)\nAA\u0001\n\u0003\u00119*\u0001\u0005dC:,\u0015/^1m)\r!%\u0011\u0014\u0005\u000b\u0005\u007f\u0012\u0019*!AA\u0002\u0005M\u0006\"\u0003BO\u0001\u0005\u0005I\u0011\tBP\u0003\u0019)\u0017/^1mgR\u0019AI!)\t\u0015\t}$1TA\u0001\u0002\u0004\t\u0019lB\u0005\u0003&\n\t\t\u0011#\u0001\u0003(\u0006\u0019\u0012J\\:feRLe\u000e^8ISZ,G+\u00192mKB\u0019\u0011K!+\u0007\u0011\u0005\u0011\u0011\u0011!E\u0001\u0005W\u001bRA!+\u0003.z\u0001\"Ba,\u00036\u0012j\u0003\u0003\u0012#Q\u001b\t\u0011\tLC\u0002\u00034j\tqA];oi&lW-\u0003\u0003\u00038\nE&!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8ok!9aJ!+\u0005\u0002\tmFC\u0001BT\u0011)\u0011yL!+\u0002\u0002\u0013\u0015#\u0011Y\u0001\ti>\u001cFO]5oOR\u0011!\u0011\r\u0005\u000b\u0005\u000b\u0014I+!A\u0005\u0002\n\u001d\u0017!B1qa2LHc\u0003)\u0003J\n-'Q\u001aBh\u0005#DaA\tBb\u0001\u0004!\u0003BB\u0016\u0003D\u0002\u0007Q\u0006\u0003\u0004>\u0005\u0007\u0004\r\u0001\u0005\u0005\u0007\u0005\n\r\u0007\u0019\u0001#\t\r)\u0013\u0019\r1\u0001E\u0011)\u0011)N!+\u0002\u0002\u0013\u0005%q[\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0011IN!9\u0011\teA$1\u001c\t\t3\tuG%\f\tE\t&\u0019!q\u001c\u000e\u0003\rQ+\b\u000f\\36\u0011%\u0011\u0019Oa5\u0002\u0002\u0003\u0007\u0001+A\u0002yIAB!Ba:\u0003*\u0006\u0005I\u0011\u0002Bu\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\t-\b\u0003\u0002B2\u0005[LAAa<\u0003f\t1qJ\u00196fGR\u0004")
public class InsertIntoHiveTable
extends SparkPlan
implements UnaryExecNode {
    private final MetastoreRelation table;
    private final Map<String, Option<String>> partition;
    private final SparkPlan child;
    private final boolean overwrite;
    private final boolean ifNotExists;
    private final transient HiveSessionState sessionState;
    private final transient HiveClient client;
    private final String stagingDir;
    private Seq<InternalRow> sideEffectResult;
    private volatile boolean bitmap$0;

    public static Function1<Tuple5<MetastoreRelation, Map<String, Option<String>>, SparkPlan, Object, Object>, InsertIntoHiveTable> tupled() {
        return InsertIntoHiveTable$.MODULE$.tupled();
    }

    public static Function1<MetastoreRelation, Function1<Map<String, Option<String>>, Function1<SparkPlan, Function1<Object, Function1<Object, InsertIntoHiveTable>>>>> curried() {
        return InsertIntoHiveTable$.MODULE$.curried();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Seq sideEffectResult$lzycompute() {
        InsertIntoHiveTable insertIntoHiveTable = this;
        synchronized (insertIntoHiveTable) {
            block21: {
                if (!this.bitmap$0) {
                    BoxedUnit boxedUnit;
                    SparkHiveWriterContainer sparkHiveWriterContainer;
                    TableDesc tableDesc = this.table().tableDesc();
                    Path tableLocation = this.table().hiveQlTable().getDataLocation();
                    Configuration hadoopConf = this.sessionState().newHadoopConf();
                    Path tmpLocation = this.getExternalTmpPath(tableLocation, hadoopConf);
                    HiveShim.ShimFileSinkDesc fileSinkConf = new HiveShim.ShimFileSinkDesc(tmpLocation.toString(), tableDesc, false);
                    boolean isCompressed = new StringOps(Predef$.MODULE$.augmentString(this.sessionState().conf().getConfString("hive.exec.compress.output", "false"))).toBoolean();
                    if (isCompressed) {
                        hadoopConf.set("mapred.output.compress", "true");
                        fileSinkConf.setCompressed(true);
                        fileSinkConf.setCompressCodec(hadoopConf.get("mapred.output.compression.codec"));
                        fileSinkConf.setCompressType(hadoopConf.get("mapred.output.compression.type"));
                    }
                    int numDynamicPartitions = this.partition().values().count((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(Option<String> x$1) {
                            return x$1.isEmpty();
                        }
                    });
                    int numStaticPartitions = this.partition().values().count((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(Option<String> x$2) {
                            return x$2.nonEmpty();
                        }
                    });
                    Map partitionSpec = (Map)this.partition().map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Tuple2<String, String> apply(Tuple2<String, Option<String>> x0$1) {
                            Tuple2<String, Option<String>> tuple2;
                            block4: {
                                Tuple2 tuple22;
                                block3: {
                                    block2: {
                                        tuple2 = x0$1;
                                        if (tuple2 == null) break block2;
                                        String key = (String)tuple2._1();
                                        Option option = (Option)tuple2._2();
                                        if (!(option instanceof Some)) break block2;
                                        Some some = (Some)option;
                                        String value = (String)some.x();
                                        tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)key), (Object)value);
                                        break block3;
                                    }
                                    if (tuple2 == null) break block4;
                                    String key = (String)tuple2._1();
                                    Option option = (Option)tuple2._2();
                                    None$ none$ = None$.MODULE$;
                                    Option option2 = option;
                                    if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
                                    tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)key), (Object)"");
                                }
                                return tuple22;
                            }
                            throw new MatchError(tuple2);
                        }
                    }, Map$.MODULE$.canBuildFrom());
                    String partitionColumns = HiveShim$.MODULE$.wrapperToFileSinkDesc(fileSinkConf).getTableInfo().getProperties().getProperty("partition_columns");
                    String[] partitionColumnNames = (String[])Option$.MODULE$.apply((Object)partitionColumns).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String[] apply(String x$3) {
                            return x$3.split("/");
                        }
                    }).getOrElse((Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String[] apply() {
                            return (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class));
                        }
                    });
                    Set set = Predef$.MODULE$.refArrayOps((Object[])partitionColumnNames).toSet();
                    Set set2 = this.partition().keySet();
                    if (set != null ? !set.equals(set2) : set2 != null) break block21;
                    if (numDynamicPartitions > 0) {
                        if (!new StringOps(Predef$.MODULE$.augmentString(this.sessionState().conf().getConfString("hive.exec.dynamic.partition", "true"))).toBoolean()) {
                            throw new SparkException(ErrorMsg.DYNAMIC_PARTITION_DISABLED.getMsg());
                        }
                        if (numStaticPartitions == 0 && this.sessionState().conf().getConfString("hive.exec.dynamic.partition.mode", "strict").equalsIgnoreCase("strict")) {
                            throw new SparkException(ErrorMsg.DYNAMIC_PARTITION_STRICT_MODE.getMsg());
                        }
                        boolean[] isDynamic = (boolean[])Predef$.MODULE$.refArrayOps((Object[])partitionColumnNames).map((Function1)new Serializable(this, partitionSpec){
                            public static final long serialVersionUID = 0L;
                            private final Map partitionSpec$1;

                            public final boolean apply(String x$5) {
                                return ((String)this.partitionSpec$1.apply((Object)x$5)).isEmpty();
                            }
                            {
                                this.partitionSpec$1 = partitionSpec$1;
                            }
                        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Boolean()));
                        if (Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.booleanArrayOps((boolean[])Predef$.MODULE$.booleanArrayOps(isDynamic).init()).zip((GenIterable)Predef$.MODULE$.wrapBooleanArray((boolean[])Predef$.MODULE$.booleanArrayOps(isDynamic).tail()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).contains((Object)new Tuple2.mcZZ.sp(true, false))) {
                            throw new AnalysisException(ErrorMsg.PARTITION_DYN_STA_ORDER.getMsg(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                        }
                    }
                    JobConf jobConf = new JobConf(hadoopConf);
                    SerializableJobConf jobConfSer = new SerializableJobConf(jobConf);
                    boolean speculationEnabled = this.sqlContext().sparkContext().conf().getBoolean("spark.speculation", false);
                    String outputCommitterClass = jobConf.get("mapred.output.committer.class", "");
                    if (speculationEnabled && outputCommitterClass.contains("Direct")) {
                        String warningMessage = new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " may be an output committer that writes data directly to "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{outputCommitterClass}))).append((Object)"the final location. Because speculation is enabled, this output committer may ").append((Object)"cause data loss (see the case in SPARK-10063). If possible, please use an output ").append((Object)"committer that does not have this behavior (e.g. FileOutputCommitter).").toString();
                        this.logWarning((Function0)new Serializable(this, warningMessage){
                            public static final long serialVersionUID = 0L;
                            private final String warningMessage$1;

                            public final String apply() {
                                return this.warningMessage$1;
                            }
                            {
                                this.warningMessage$1 = warningMessage$1;
                            }
                        });
                    }
                    if (numDynamicPartitions > 0) {
                        String[] dynamicPartColNames = (String[])Predef$.MODULE$.refArrayOps((Object[])partitionColumnNames).takeRight(numDynamicPartitions);
                        sparkHiveWriterContainer = new SparkHiveDynamicPartitionWriterContainer(jobConf, fileSinkConf, dynamicPartColNames, (Seq<Attribute>)this.child().output(), this.table());
                    } else {
                        sparkHiveWriterContainer = new SparkHiveWriterContainer(jobConf, fileSinkConf, (Seq<Attribute>)this.child().output(), this.table());
                    }
                    SparkHiveWriterContainer writerContainer = sparkHiveWriterContainer;
                    Class outputClass = writerContainer.newSerializer(this.table().tableDesc()).getSerializedClass();
                    this.saveAsHiveFile((RDD<InternalRow>)this.child().execute(), outputClass, fileSinkConf, jobConfSer, writerContainer);
                    Path outputPath = FileOutputFormat.getOutputPath((JobConf)jobConf);
                    String qualifiedTableName = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.table().databaseName(), this.table().tableName()}));
                    boolean holdDDLTime = false;
                    if (this.partition().nonEmpty()) {
                        LinkedHashMap<String, String> orderedPartitionSpec = new LinkedHashMap<String, String>();
                        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.table().hiveQlTable().getPartCols()).asScala()).foreach((Function1)new Serializable(this, partitionSpec, orderedPartitionSpec){
                            public static final long serialVersionUID = 0L;
                            private final Map partitionSpec$1;
                            private final LinkedHashMap orderedPartitionSpec$1;

                            public final String apply(FieldSchema entry) {
                                return (String)this.orderedPartitionSpec$1.put(entry.getName(), this.partitionSpec$1.getOrElse((Object)entry.getName(), (Function0)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final String apply() {
                                        return "";
                                    }
                                }));
                            }
                            {
                                this.partitionSpec$1 = partitionSpec$1;
                                this.orderedPartitionSpec$1 = orderedPartitionSpec$1;
                            }
                        });
                        boolean inheritTableSpecs = true;
                        boolean isSkewedStoreAsSubdir = false;
                        if (numDynamicPartitions > 0) {
                            HiveClient hiveClient = this.client();
                            synchronized (hiveClient) {
                                this.client().loadDynamicPartitions(outputPath.toString(), qualifiedTableName, orderedPartitionSpec, this.overwrite(), numDynamicPartitions, holdDDLTime, isSkewedStoreAsSubdir);
                                BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                                // MONITOREXIT @DISABLED, blocks:[0, 1, 19, 3, 20, 4, 9] lbl61 : MonitorExitStatement: MONITOREXIT : var29_29
                                boxedUnit = boxedUnit2;
                            }
                        } else {
                            Option<CatalogTablePartition> oldPart = this.client().getPartitionOption(this.client().getTable(this.table().databaseName(), this.table().tableName()), (Map<String, String>)partitionSpec);
                            if (oldPart.isEmpty() || !this.ifNotExists()) {
                                this.client().loadPartition(outputPath.toString(), qualifiedTableName, orderedPartitionSpec, this.overwrite(), holdDDLTime, inheritTableSpecs, isSkewedStoreAsSubdir);
                            }
                            boxedUnit = BoxedUnit.UNIT;
                        }
                    } else {
                        this.client().loadTable(outputPath.toString(), qualifiedTableName, this.overwrite(), holdDDLTime);
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    this.sqlContext().sharedState().cacheManager().invalidateCache((LogicalPlan)this.table());
                    this.sqlContext().sessionState().catalog().refreshTable(this.table().catalogTable().identifier());
                    this.sideEffectResult = (Seq)Seq$.MODULE$.empty();
                    this.bitmap$0 = true;
                }
                return this.sideEffectResult;
            }
            throw new SparkException(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Requested partitioning does not match the ", " table:\n           |Requested partitions: ", "\n           |Table partitions: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.table().tableName(), this.partition().keys().mkString(","), ((TraversableOnce)this.table().partitionKeys().map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(AttributeReference x$4) {
                    return x$4.name();
                }
            }, Seq$.MODULE$.canBuildFrom())).mkString(",")})))).stripMargin());
        }
    }

    public Seq<SparkPlan> children() {
        return UnaryExecNode.class.children((UnaryExecNode)this);
    }

    public Partitioning outputPartitioning() {
        return UnaryExecNode.class.outputPartitioning((UnaryExecNode)this);
    }

    public MetastoreRelation table() {
        return this.table;
    }

    public Map<String, Option<String>> partition() {
        return this.partition;
    }

    public SparkPlan child() {
        return this.child;
    }

    public boolean overwrite() {
        return this.overwrite;
    }

    public boolean ifNotExists() {
        return this.ifNotExists;
    }

    private HiveSessionState sessionState() {
        return this.sessionState;
    }

    private HiveClient client() {
        return this.client;
    }

    public Seq<Attribute> output() {
        return (Seq)Seq$.MODULE$.empty();
    }

    public String stagingDir() {
        return this.stagingDir;
    }

    private String executionId() {
        Random rand = new Random();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss_SSS");
        String executionId = new StringBuilder().append((Object)"hive_").append((Object)format.format(new Date())).append((Object)"_").append((Object)BoxesRunTime.boxToLong((long)Math.abs(rand.nextLong()))).toString();
        return executionId;
    }

    private Path getStagingDir(Path inputPath, Configuration hadoopConf) {
        Path dir;
        block3: {
            URI inputPathUri = inputPath.toUri();
            String inputPathName = inputPathUri.getPath();
            FileSystem fs = inputPath.getFileSystem(hadoopConf);
            String stagingPathName = inputPathName.indexOf(this.stagingDir()) == -1 ? new Path(inputPathName, this.stagingDir()).toString() : inputPathName.substring(0, inputPathName.indexOf(this.stagingDir()) + this.stagingDir().length());
            dir = fs.makeQualified(new Path(new StringBuilder().append((Object)stagingPathName).append((Object)"_").append((Object)this.executionId()).append((Object)"-").append((Object)BoxesRunTime.boxToLong((long)TaskRunner.getTaskRunnerID())).toString()));
            this.logDebug((Function0)new Serializable(this, inputPath, dir){
                public static final long serialVersionUID = 0L;
                private final Path inputPath$1;
                private final Path dir$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"Created staging dir = ").append((Object)this.dir$1).append((Object)" for path = ").append((Object)this.inputPath$1).toString();
                }
                {
                    this.inputPath$1 = inputPath$1;
                    this.dir$1 = dir$1;
                }
            });
            try {
                if (!FileUtils.mkdir((FileSystem)fs, (Path)dir, (boolean)true, (Configuration)hadoopConf)) break block3;
                fs.deleteOnExit(dir);
            }
            catch (IOException iOException) {
                throw new RuntimeException(new StringBuilder().append((Object)"Cannot create staging directory '").append((Object)dir.toString()).append((Object)"': ").append((Object)iOException.getMessage()).toString(), iOException);
            }
            return dir;
        }
        throw new IllegalStateException(new StringBuilder().append((Object)"Cannot create staging directory  '").append((Object)dir.toString()).append((Object)"'").toString());
    }

    private Path getExternalScratchDir(URI extURI, Configuration hadoopConf) {
        return this.getStagingDir(new Path(extURI.getScheme(), extURI.getAuthority(), extURI.getPath()), hadoopConf);
    }

    public Path getExternalTmpPath(Path path, Configuration hadoopConf) {
        URI extURI = path.toUri();
        String string = extURI.getScheme();
        String string2 = "viewfs";
        return !(string != null ? !string.equals(string2) : string2 != null) ? this.getExtTmpPathRelTo(path.getParent(), hadoopConf) : new Path(this.getExternalScratchDir(extURI, hadoopConf), "-ext-10000");
    }

    public Path getExtTmpPathRelTo(Path path, Configuration hadoopConf) {
        return new Path(this.getStagingDir(path, hadoopConf), "-ext-10000");
    }

    private void saveAsHiveFile(RDD<InternalRow> rdd, Class<?> valueClass, HiveShim.ShimFileSinkDesc fileSinkConf, SerializableJobConf conf, SparkHiveWriterContainer writerContainer) {
        Predef$.MODULE$.assert(valueClass != null, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Output value class not set";
            }
        });
        conf.value().setOutputValueClass(valueClass);
        String outputFileFormatClassName = HiveShim$.MODULE$.wrapperToFileSinkDesc(fileSinkConf).getTableInfo().getOutputFileFormatClassName();
        Predef$.MODULE$.assert(outputFileFormatClassName != null, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Output format class not set";
            }
        });
        conf.value().set("mapred.output.format.class", outputFileFormatClassName);
        FileOutputFormat.setOutputPath((JobConf)conf.value(), (Path)SparkHiveWriterContainer$.MODULE$.createPathFromString(fileSinkConf.getDirName(), conf.value()));
        this.log().debug(new StringBuilder().append((Object)"Saving as hadoop file of type ").append((Object)valueClass.getSimpleName()).toString());
        writerContainer.driverSideSetup();
        this.sqlContext().sparkContext().runJob(rdd, (Function2)new Serializable(this, writerContainer){
            public static final long serialVersionUID = 0L;
            private final SparkHiveWriterContainer writerContainer$1;

            public final void apply(TaskContext context, Iterator<InternalRow> iterator) {
                this.writerContainer$1.writeToFile(context, iterator);
            }
            {
                this.writerContainer$1 = writerContainer$1;
            }
        }, ClassTag$.MODULE$.Unit());
        writerContainer.commitJob();
    }

    public Seq<InternalRow> sideEffectResult() {
        return this.bitmap$0 ? this.sideEffectResult : this.sideEffectResult$lzycompute();
    }

    public InternalRow[] executeCollect() {
        return (InternalRow[])this.sideEffectResult().toArray(ClassTag$.MODULE$.apply(InternalRow.class));
    }

    public RDD<InternalRow> doExecute() {
        return this.sqlContext().sparkContext().parallelize(this.sideEffectResult(), 1, ClassTag$.MODULE$.apply(InternalRow.class));
    }

    public InsertIntoHiveTable copy(MetastoreRelation table, Map<String, Option<String>> partition, SparkPlan child, boolean overwrite, boolean ifNotExists) {
        return new InsertIntoHiveTable(table, partition, child, overwrite, ifNotExists);
    }

    public MetastoreRelation copy$default$1() {
        return this.table();
    }

    public Map<String, Option<String>> copy$default$2() {
        return this.partition();
    }

    public SparkPlan copy$default$3() {
        return this.child();
    }

    public boolean copy$default$4() {
        return this.overwrite();
    }

    public boolean copy$default$5() {
        return this.ifNotExists();
    }

    public String productPrefix() {
        return "InsertIntoHiveTable";
    }

    public int productArity() {
        return 5;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 4: {
                object = BoxesRunTime.boxToBoolean((boolean)this.ifNotExists());
                break;
            }
            case 3: {
                object = BoxesRunTime.boxToBoolean((boolean)this.overwrite());
                break;
            }
            case 2: {
                object = this.child();
                break;
            }
            case 1: {
                object = this.partition();
                break;
            }
            case 0: {
                object = this.table();
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof InsertIntoHiveTable;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof InsertIntoHiveTable)) return false;
        boolean bl = true;
        if (!bl) return false;
        InsertIntoHiveTable insertIntoHiveTable = (InsertIntoHiveTable)((Object)x$1);
        MetastoreRelation metastoreRelation = this.table();
        MetastoreRelation metastoreRelation2 = insertIntoHiveTable.table();
        if (metastoreRelation == null) {
            if (metastoreRelation2 != null) {
                return false;
            }
        } else if (!((Object)((Object)metastoreRelation)).equals((Object)metastoreRelation2)) return false;
        Map<String, Option<String>> map = this.partition();
        Map<String, Option<String>> map2 = insertIntoHiveTable.partition();
        if (map == null) {
            if (map2 != null) {
                return false;
            }
        } else if (!map.equals(map2)) return false;
        SparkPlan sparkPlan = this.child();
        SparkPlan sparkPlan2 = insertIntoHiveTable.child();
        if (sparkPlan == null) {
            if (sparkPlan2 != null) {
                return false;
            }
        } else if (!sparkPlan.equals(sparkPlan2)) return false;
        if (this.overwrite() != insertIntoHiveTable.overwrite()) return false;
        if (this.ifNotExists() != insertIntoHiveTable.ifNotExists()) return false;
        if (!insertIntoHiveTable.canEqual((Object)this)) return false;
        return true;
    }

    public InsertIntoHiveTable(MetastoreRelation table, Map<String, Option<String>> partition, SparkPlan child, boolean overwrite, boolean ifNotExists) {
        this.table = table;
        this.partition = partition;
        this.child = child;
        this.overwrite = overwrite;
        this.ifNotExists = ifNotExists;
        UnaryExecNode.class.$init$((UnaryExecNode)this);
        this.sessionState = (HiveSessionState)this.sqlContext().sessionState();
        this.client = this.sessionState().metadataHive();
        this.stagingDir = this.sessionState().conf().getConfString("hive.exec.stagingdir", ".hive-staging");
    }
}

