/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.vectorized;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import org.apache.spark.memory.MemoryMode;
import org.apache.spark.sql.execution.vectorized.ColumnVector;
import org.apache.spark.sql.types.BooleanType;
import org.apache.spark.sql.types.ByteType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType;
import org.apache.spark.sql.types.FloatType;
import org.apache.spark.sql.types.IntegerType;
import org.apache.spark.sql.types.LongType;
import org.apache.spark.sql.types.ShortType;
import org.apache.spark.sql.types.TimestampType;
import org.apache.spark.unsafe.Platform;

public final class OnHeapColumnVector
extends ColumnVector {
    private static final boolean bigEndianPlatform = ByteOrder.nativeOrder().equals(ByteOrder.BIG_ENDIAN);
    private byte[] nulls;
    private byte[] byteData;
    private short[] shortData;
    private int[] intData;
    private long[] longData;
    private float[] floatData;
    private double[] doubleData;
    private int[] arrayLengths;
    private int[] arrayOffsets;

    protected OnHeapColumnVector(int capacity, DataType type) {
        super(capacity, type, MemoryMode.ON_HEAP);
        this.reserveInternal(capacity);
        this.reset();
    }

    @Override
    public long valuesNativeAddress() {
        throw new RuntimeException("Cannot get native address for on heap column");
    }

    @Override
    public long nullsNativeAddress() {
        throw new RuntimeException("Cannot get native address for on heap column");
    }

    @Override
    public void close() {
    }

    @Override
    public void putNotNull(int rowId) {
        this.nulls[rowId] = 0;
    }

    @Override
    public void putNull(int rowId) {
        this.nulls[rowId] = 1;
        ++this.numNulls;
        this.anyNullsSet = true;
    }

    @Override
    public void putNulls(int rowId, int count2) {
        for (int i = 0; i < count2; ++i) {
            this.nulls[rowId + i] = 1;
        }
        this.anyNullsSet = true;
        this.numNulls += count2;
    }

    @Override
    public void putNotNulls(int rowId, int count2) {
        if (!this.anyNullsSet) {
            return;
        }
        for (int i = 0; i < count2; ++i) {
            this.nulls[rowId + i] = 0;
        }
    }

    @Override
    public boolean isNullAt(int rowId) {
        return this.nulls[rowId] == 1;
    }

    @Override
    public void putBoolean(int rowId, boolean value) {
        this.byteData[rowId] = (byte)(value ? 1 : 0);
    }

    @Override
    public void putBooleans(int rowId, int count2, boolean value) {
        byte v = (byte)(value ? 1 : 0);
        for (int i = 0; i < count2; ++i) {
            this.byteData[i + rowId] = v;
        }
    }

    @Override
    public boolean getBoolean(int rowId) {
        return this.byteData[rowId] == 1;
    }

    @Override
    public void putByte(int rowId, byte value) {
        this.byteData[rowId] = value;
    }

    @Override
    public void putBytes(int rowId, int count2, byte value) {
        for (int i = 0; i < count2; ++i) {
            this.byteData[i + rowId] = value;
        }
    }

    @Override
    public void putBytes(int rowId, int count2, byte[] src, int srcIndex) {
        System.arraycopy(src, srcIndex, this.byteData, rowId, count2);
    }

    @Override
    public byte getByte(int rowId) {
        if (this.dictionary == null) {
            return this.byteData[rowId];
        }
        return (byte)this.dictionary.decodeToInt(this.dictionaryIds.getInt(rowId));
    }

    @Override
    public void putShort(int rowId, short value) {
        this.shortData[rowId] = value;
    }

    @Override
    public void putShorts(int rowId, int count2, short value) {
        for (int i = 0; i < count2; ++i) {
            this.shortData[i + rowId] = value;
        }
    }

    @Override
    public void putShorts(int rowId, int count2, short[] src, int srcIndex) {
        System.arraycopy(src, srcIndex, this.shortData, rowId, count2);
    }

    @Override
    public short getShort(int rowId) {
        if (this.dictionary == null) {
            return this.shortData[rowId];
        }
        return (short)this.dictionary.decodeToInt(this.dictionaryIds.getInt(rowId));
    }

    @Override
    public void putInt(int rowId, int value) {
        this.intData[rowId] = value;
    }

    @Override
    public void putInts(int rowId, int count2, int value) {
        for (int i = 0; i < count2; ++i) {
            this.intData[i + rowId] = value;
        }
    }

    @Override
    public void putInts(int rowId, int count2, int[] src, int srcIndex) {
        System.arraycopy(src, srcIndex, this.intData, rowId, count2);
    }

    @Override
    public void putIntsLittleEndian(int rowId, int count2, byte[] src, int srcIndex) {
        int srcOffset = srcIndex + Platform.BYTE_ARRAY_OFFSET;
        int i = 0;
        while (i < count2) {
            this.intData[i + rowId] = Platform.getInt((Object)src, (long)srcOffset);
            if (bigEndianPlatform) {
                this.intData[i + rowId] = Integer.reverseBytes(this.intData[i + rowId]);
            }
            ++i;
            srcOffset += 4;
        }
    }

    @Override
    public int getInt(int rowId) {
        if (this.dictionary == null) {
            return this.intData[rowId];
        }
        return this.dictionary.decodeToInt(this.dictionaryIds.getInt(rowId));
    }

    @Override
    public void putLong(int rowId, long value) {
        this.longData[rowId] = value;
    }

    @Override
    public void putLongs(int rowId, int count2, long value) {
        for (int i = 0; i < count2; ++i) {
            this.longData[i + rowId] = value;
        }
    }

    @Override
    public void putLongs(int rowId, int count2, long[] src, int srcIndex) {
        System.arraycopy(src, srcIndex, this.longData, rowId, count2);
    }

    @Override
    public void putLongsLittleEndian(int rowId, int count2, byte[] src, int srcIndex) {
        int srcOffset = srcIndex + Platform.BYTE_ARRAY_OFFSET;
        int i = 0;
        while (i < count2) {
            this.longData[i + rowId] = Platform.getLong((Object)src, (long)srcOffset);
            if (bigEndianPlatform) {
                this.longData[i + rowId] = Long.reverseBytes(this.longData[i + rowId]);
            }
            ++i;
            srcOffset += 8;
        }
    }

    @Override
    public long getLong(int rowId) {
        if (this.dictionary == null) {
            return this.longData[rowId];
        }
        return this.dictionary.decodeToLong(this.dictionaryIds.getInt(rowId));
    }

    @Override
    public void putFloat(int rowId, float value) {
        this.floatData[rowId] = value;
    }

    @Override
    public void putFloats(int rowId, int count2, float value) {
        Arrays.fill(this.floatData, rowId, rowId + count2, value);
    }

    @Override
    public void putFloats(int rowId, int count2, float[] src, int srcIndex) {
        System.arraycopy(src, srcIndex, this.floatData, rowId, count2);
    }

    @Override
    public void putFloats(int rowId, int count2, byte[] src, int srcIndex) {
        if (!bigEndianPlatform) {
            Platform.copyMemory((Object)src, (long)(Platform.BYTE_ARRAY_OFFSET + srcIndex), (Object)this.floatData, (long)(Platform.DOUBLE_ARRAY_OFFSET + rowId * 4), (long)(count2 * 4));
        } else {
            ByteBuffer bb = ByteBuffer.wrap(src).order(ByteOrder.LITTLE_ENDIAN);
            for (int i = 0; i < count2; ++i) {
                this.floatData[i + rowId] = bb.getFloat(srcIndex + 4 * i);
            }
        }
    }

    @Override
    public float getFloat(int rowId) {
        if (this.dictionary == null) {
            return this.floatData[rowId];
        }
        return this.dictionary.decodeToFloat(this.dictionaryIds.getInt(rowId));
    }

    @Override
    public void putDouble(int rowId, double value) {
        this.doubleData[rowId] = value;
    }

    @Override
    public void putDoubles(int rowId, int count2, double value) {
        Arrays.fill(this.doubleData, rowId, rowId + count2, value);
    }

    @Override
    public void putDoubles(int rowId, int count2, double[] src, int srcIndex) {
        System.arraycopy(src, srcIndex, this.doubleData, rowId, count2);
    }

    @Override
    public void putDoubles(int rowId, int count2, byte[] src, int srcIndex) {
        if (!bigEndianPlatform) {
            Platform.copyMemory((Object)src, (long)(Platform.BYTE_ARRAY_OFFSET + srcIndex), (Object)this.doubleData, (long)(Platform.DOUBLE_ARRAY_OFFSET + rowId * 8), (long)(count2 * 8));
        } else {
            ByteBuffer bb = ByteBuffer.wrap(src).order(ByteOrder.LITTLE_ENDIAN);
            for (int i = 0; i < count2; ++i) {
                this.doubleData[i + rowId] = bb.getDouble(srcIndex + 8 * i);
            }
        }
    }

    @Override
    public double getDouble(int rowId) {
        if (this.dictionary == null) {
            return this.doubleData[rowId];
        }
        return this.dictionary.decodeToDouble(this.dictionaryIds.getInt(rowId));
    }

    @Override
    public int getArrayLength(int rowId) {
        return this.arrayLengths[rowId];
    }

    @Override
    public int getArrayOffset(int rowId) {
        return this.arrayOffsets[rowId];
    }

    @Override
    public void putArray(int rowId, int offset, int length) {
        this.arrayOffsets[rowId] = offset;
        this.arrayLengths[rowId] = length;
    }

    @Override
    public void loadBytes(ColumnVector.Array array2) {
        array2.byteArray = this.byteData;
        array2.byteArrayOffset = array2.offset;
    }

    @Override
    public int putByteArray(int rowId, byte[] value, int offset, int length) {
        int result;
        this.arrayOffsets[rowId] = result = this.arrayData().appendBytes(length, value, offset);
        this.arrayLengths[rowId] = length;
        return result;
    }

    @Override
    protected void reserveInternal(int newCapacity) {
        Object[] newData;
        if (this.resultArray != null || DecimalType.isByteArrayDecimalType((DataType)this.type)) {
            int[] newLengths = new int[newCapacity];
            int[] newOffsets = new int[newCapacity];
            if (this.arrayLengths != null) {
                System.arraycopy(this.arrayLengths, 0, newLengths, 0, this.elementsAppended);
                System.arraycopy(this.arrayOffsets, 0, newOffsets, 0, this.elementsAppended);
            }
            this.arrayLengths = newLengths;
            this.arrayOffsets = newOffsets;
        } else if (this.type instanceof BooleanType) {
            if (this.byteData == null || this.byteData.length < newCapacity) {
                newData = new byte[newCapacity];
                if (this.byteData != null) {
                    System.arraycopy(this.byteData, 0, newData, 0, this.elementsAppended);
                }
                this.byteData = newData;
            }
        } else if (this.type instanceof ByteType) {
            if (this.byteData == null || this.byteData.length < newCapacity) {
                newData = new byte[newCapacity];
                if (this.byteData != null) {
                    System.arraycopy(this.byteData, 0, newData, 0, this.elementsAppended);
                }
                this.byteData = newData;
            }
        } else if (this.type instanceof ShortType) {
            if (this.shortData == null || this.shortData.length < newCapacity) {
                newData = new short[newCapacity];
                if (this.shortData != null) {
                    System.arraycopy(this.shortData, 0, newData, 0, this.elementsAppended);
                }
                this.shortData = newData;
            }
        } else if (this.type instanceof IntegerType || this.type instanceof DateType || DecimalType.is32BitDecimalType((DataType)this.type)) {
            if (this.intData == null || this.intData.length < newCapacity) {
                newData = new int[newCapacity];
                if (this.intData != null) {
                    System.arraycopy(this.intData, 0, newData, 0, this.elementsAppended);
                }
                this.intData = newData;
            }
        } else if (this.type instanceof LongType || this.type instanceof TimestampType || DecimalType.is64BitDecimalType((DataType)this.type)) {
            if (this.longData == null || this.longData.length < newCapacity) {
                newData = new long[newCapacity];
                if (this.longData != null) {
                    System.arraycopy(this.longData, 0, newData, 0, this.elementsAppended);
                }
                this.longData = newData;
            }
        } else if (this.type instanceof FloatType) {
            if (this.floatData == null || this.floatData.length < newCapacity) {
                newData = new float[newCapacity];
                if (this.floatData != null) {
                    System.arraycopy(this.floatData, 0, newData, 0, this.elementsAppended);
                }
                this.floatData = newData;
            }
        } else if (this.type instanceof DoubleType) {
            if (this.doubleData == null || this.doubleData.length < newCapacity) {
                newData = new double[newCapacity];
                if (this.doubleData != null) {
                    System.arraycopy(this.doubleData, 0, newData, 0, this.elementsAppended);
                }
                this.doubleData = newData;
            }
        } else if (this.resultStruct == null) {
            throw new RuntimeException("Unhandled " + this.type);
        }
        byte[] newNulls = new byte[newCapacity];
        if (this.nulls != null) {
            System.arraycopy(this.nulls, 0, newNulls, 0, this.elementsAppended);
        }
        this.nulls = newNulls;
        this.capacity = newCapacity;
    }
}

