/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.mapreduce.hadoop;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;

public class DeprecatedKeys {
    private static Map<String, String> mrParamToDAGParamMap = new HashMap<String, String>();
    private static Map<String, String> mrParamToTezRuntimeParamMap = new HashMap<String, String>();

    private static void populateMRToDagParamMap() {
        mrParamToDAGParamMap.put("yarn.app.mapreduce.am.job.task.listener.thread-count", "tez.am.task.listener.thread-count");
        mrParamToDAGParamMap.put("mapreduce.job.maxtaskfailures.per.tracker", "tez.am.maxtaskfailures.per.node");
        mrParamToDAGParamMap.put("yarn.app.mapreduce.am.job.node-blacklisting.enable", "tez.am.node-blacklisting.enabled");
        mrParamToDAGParamMap.put("yarn.app.mapreduce.am.job.node-blacklisting.ignore-threshold-node-percent", "tez.am.node-blacklisting.ignore-threshold-node-percent");
        mrParamToDAGParamMap.put("mapreduce.job.queuename", "tez.queue.name");
        mrParamToDAGParamMap.put("mapreduce.job.counters.max", "tez.counters.max");
        mrParamToDAGParamMap.put("mapreduce.job.counters.groups.max", "tez.counters.max.groups");
        mrParamToDAGParamMap.put("mapreduce.job.counters.counter.name.max", "tez.counters.counter-name.max-length");
        mrParamToDAGParamMap.put("mapreduce.job.counters.group.name.max", "tez.counters.group-name.max-length");
        mrParamToDAGParamMap.put("mapreduce.task.timeout", "tez.task.timeout-ms");
        mrParamToDAGParamMap.put("mapreduce.job.tags", "tez.application.tags");
        mrParamToDAGParamMap.put("mapreduce.job.user.classpath.first", "tez.user.classpath.first");
    }

    public static void init() {
    }

    private static void populateMRToTezRuntimeParamMap() {
        DeprecatedKeys.registerMRToRuntimeKeyTranslation("mapreduce.ifile.readahead", "tez.runtime.ifile.readahead");
        DeprecatedKeys.registerMRToRuntimeKeyTranslation("mapreduce.ifile.readahead.bytes", "tez.runtime.ifile.readahead.bytes");
        DeprecatedKeys.registerMRToRuntimeKeyTranslation("mapreduce.task.merge.progress.records", "tez.runtime.merge.progress.records");
        DeprecatedKeys.registerMRToRuntimeKeyTranslation("mapreduce.task.io.sort.factor", "tez.runtime.io.sort.factor");
        DeprecatedKeys.registerMRToRuntimeKeyTranslation("mapreduce.map.sort.spill.percent", "tez.runtime.sort.spill.percent");
        DeprecatedKeys.registerMRToRuntimeKeyTranslation("mapreduce.task.io.sort.mb", "tez.runtime.io.sort.mb");
        DeprecatedKeys.registerMRToRuntimeKeyTranslation("mapreduce.task.index.cache.limit.bytes", "tez.runtime.index.cache.memory.limit.bytes");
        DeprecatedKeys.registerMRToRuntimeKeyTranslation("mapreduce.map.combine.minspills", "tez.runtime.combine.min.spills");
        DeprecatedKeys.registerMRToRuntimeKeyTranslation("mapreduce.reduce.memory.totalbytes", "tez.runtime.task.memory");
        DeprecatedKeys.registerMRToRuntimeKeyTranslation("mapreduce.job.reduce.slowstart.completedmaps", "tez.shuffle-vertex-manager.min-src-fraction");
        DeprecatedKeys.registerMRToRuntimeKeyTranslation("mapreduce.reduce.shuffle.parallelcopies", "tez.runtime.shuffle.parallel.copies");
        DeprecatedKeys.registerMRToRuntimeKeyTranslation("mapreduce.reduce.shuffle.maxfetchfailures", "tez.runtime.shuffle.fetch.failures.limit");
        DeprecatedKeys.registerMRToRuntimeKeyTranslation("mapreduce.reduce.shuffle.notify.readerror", "tez.runtime.shuffle.notify.readerror");
        DeprecatedKeys.registerMRToRuntimeKeyTranslation("mapreduce.reduce.shuffle.connect.timeout", "tez.runtime.shuffle.connect.timeout");
        DeprecatedKeys.registerMRToRuntimeKeyTranslation("mapreduce.reduce.shuffle.read.timeout", "tez.runtime.shuffle.read.timeout");
        DeprecatedKeys.registerMRToRuntimeKeyTranslation("mapreduce.shuffle.ssl.enabled", "tez.runtime.shuffle.ssl.enable");
        DeprecatedKeys.registerMRToRuntimeKeyTranslation("mapreduce.reduce.shuffle.input.buffer.percent", "tez.runtime.shuffle.fetch.buffer.percent");
        DeprecatedKeys.registerMRToRuntimeKeyTranslation("mapreduce.reduce.shuffle.memory.limit.percent", "tez.runtime.shuffle.memory.limit.percent");
        DeprecatedKeys.registerMRToRuntimeKeyTranslation("mapreduce.reduce.shuffle.merge.percent", "tez.runtime.shuffle.merge.percent");
        DeprecatedKeys.registerMRToRuntimeKeyTranslation("mapreduce.reduce.merge.memtomem.threshold", "tez.runtime.shuffle.memory-to-memory.segments");
        DeprecatedKeys.registerMRToRuntimeKeyTranslation("mapreduce.reduce.merge.memtomem.enabled", "tez.runtime.shuffle.memory-to-memory.enable");
        DeprecatedKeys.registerMRToRuntimeKeyTranslation("mapreduce.reduce.input.buffer.percent", "tez.runtime.task.input.post-merge.buffer.percent");
        DeprecatedKeys.registerMRToRuntimeKeyTranslation("map.sort.class", "tez.runtime.internal.sorter.class");
        DeprecatedKeys.registerMRToRuntimeKeyTranslation("mapreduce.job.output.group.comparator.class", "tez.runtime.group.comparator.class");
        DeprecatedKeys.registerMRToRuntimeKeyTranslation("mapreduce.job.output.group.comparator.class", "tez.runtime.key.secondary.comparator.class");
        DeprecatedKeys.registerMRToRuntimeKeyTranslation("mapreduce.job.credentials.binary", "tez.credentials.path");
        DeprecatedKeys.registerMRToRuntimeKeyTranslation("mapreduce.job.output.key.comparator.class", "tez.runtime.key.comparator.class");
        DeprecatedKeys.registerMRToRuntimeKeyTranslation("mapreduce.map.output.key.class", "tez.runtime.key.class");
        DeprecatedKeys.registerMRToRuntimeKeyTranslation("mapreduce.map.output.value.class", "tez.runtime.value.class");
        DeprecatedKeys.registerMRToRuntimeKeyTranslation("mapreduce.map.output.compress", "tez.runtime.compress");
        DeprecatedKeys.registerMRToRuntimeKeyTranslation("mapreduce.map.output.compress.codec", "tez.runtime.compress.codec");
        DeprecatedKeys.registerMRToRuntimeKeyTranslation("mapreduce.job.user.classpath.first", "tez.user.classpath.first");
    }

    private static void addDeprecatedKeys() {
    }

    private static void registerMRToRuntimeKeyTranslation(String mrKey, String tezKey) {
        mrParamToTezRuntimeParamMap.put(mrKey, tezKey);
    }

    private static void _(String mrKey, String tezKey) {
        Configuration.addDeprecation((String)mrKey, (String)tezKey);
    }

    public static Map<String, String> getMRToDAGParamMap() {
        return Collections.unmodifiableMap(mrParamToDAGParamMap);
    }

    public static Map<String, String> getMRToTezRuntimeParamMap() {
        return Collections.unmodifiableMap(mrParamToTezRuntimeParamMap);
    }

    static {
        DeprecatedKeys.populateMRToTezRuntimeParamMap();
        DeprecatedKeys.populateMRToDagParamMap();
        DeprecatedKeys.addDeprecatedKeys();
    }
}

