/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles;

import java.util.ArrayList;
import java.util.EmptyStackException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayStack<T>
extends ArrayList<T> {
    private static final long serialVersionUID = 2130079159931574599L;

    public ArrayStack() {
    }

    public ArrayStack(int initialSize) {
        super(initialSize);
    }

    public boolean empty() {
        return this.isEmpty();
    }

    public T peek() {
        int n = this.size();
        if (n <= 0) {
            throw new EmptyStackException();
        }
        return (T)this.get(n - 1);
    }

    public T peek(int n) {
        int m = this.size() - n - 1;
        if (m < 0) {
            throw new EmptyStackException();
        }
        return (T)this.get(m);
    }

    public T pop() {
        int n = this.size();
        if (n <= 0) {
            throw new EmptyStackException();
        }
        return (T)this.remove(n - 1);
    }

    public T push(T item) {
        this.add(item);
        return item;
    }

    public int search(T object) {
        int i = this.size() - 1;
        int n = 1;
        while (i >= 0) {
            Object current = this.get(i);
            if (object == null && current == null || object != null && object.equals(current)) {
                return n;
            }
            --i;
            ++n;
        }
        return -1;
    }
}

