/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.r;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.apache.zeppelin.interpreter.Interpreter;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.InterpreterException;
import org.apache.zeppelin.interpreter.InterpreterOutput;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.interpreter.InterpreterResultMessage;
import org.apache.zeppelin.jupyter.IRKernelTest;
import org.apache.zeppelin.r.IRInterpreter;
import org.junit.Assert;
import org.junit.Test;

public class IRInterpreterTest
extends IRKernelTest {
    protected Interpreter createInterpreter(Properties properties) {
        return new IRInterpreter(properties);
    }

    protected InterpreterContext getInterpreterContext() {
        InterpreterContext context = InterpreterContext.builder().setNoteId("note_1").setParagraphId("paragraph_1").setInterpreterOut(new InterpreterOutput()).setLocalProperties(new HashMap()).build();
        return context;
    }

    @Test
    public void testZShow() throws InterpreterException, IOException {
        InterpreterContext context = this.getInterpreterContext();
        InterpreterResult result = this.interpreter.interpret("df=data.frame(country=c(\"US\", \"GB\", \"BR\"),\nval1=c(10,13,14),\nval2=c(23,12,32))", context);
        Assert.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)result.code());
        context = this.getInterpreterContext();
        result = this.interpreter.interpret("z.show(df)", context);
        Assert.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)result.code());
        List resultMessages = context.out.toInterpreterResultMessage();
        Assert.assertEquals((long)1L, (long)resultMessages.size());
        Assert.assertEquals((String)resultMessages.toString(), (Object)InterpreterResult.Type.TABLE, (Object)((InterpreterResultMessage)resultMessages.get(0)).getType());
        Assert.assertEquals((Object)"country\tval1\tval2\n3\t10\t23\n2\t13\t12\n1\t14\t32\n", (Object)((InterpreterResultMessage)resultMessages.get(0)).getData());
        context = this.getInterpreterContext();
        result = this.interpreter.interpret("z.show(df, maxRows=1)", context);
        Assert.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)result.code());
        resultMessages = context.out.toInterpreterResultMessage();
        Assert.assertEquals((long)2L, (long)resultMessages.size());
        Assert.assertEquals((String)resultMessages.toString(), (Object)InterpreterResult.Type.TABLE, (Object)((InterpreterResultMessage)resultMessages.get(0)).getType());
        Assert.assertEquals((Object)"country\tval1\tval2\n3\t10\t23\n", (Object)((InterpreterResultMessage)resultMessages.get(0)).getData());
        Assert.assertEquals((String)resultMessages.toString(), (Object)InterpreterResult.Type.HTML, (Object)((InterpreterResultMessage)resultMessages.get(1)).getType());
        Assert.assertEquals((Object)"<font color=red>Results are limited by 1 rows.</font>\n", (Object)((InterpreterResultMessage)resultMessages.get(1)).getData());
    }
}

