/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.r;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.InterpreterException;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.interpreter.ZeppelinContext;
import org.apache.zeppelin.interpreter.jupyter.proto.ExecuteRequest;
import org.apache.zeppelin.interpreter.jupyter.proto.ExecuteResponse;
import org.apache.zeppelin.interpreter.jupyter.proto.ExecuteStatus;
import org.apache.zeppelin.interpreter.remote.RemoteInterpreterUtils;
import org.apache.zeppelin.jupyter.JupyterKernelInterpreter;
import org.apache.zeppelin.r.RZeppelinContext;
import org.apache.zeppelin.r.SparkRBackend;
import org.apache.zeppelin.r.SparkRUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IRInterpreter
extends JupyterKernelInterpreter {
    private static final Logger LOGGER = LoggerFactory.getLogger(IRInterpreter.class);
    private static RZeppelinContext z;
    private File shinyAppFolder;
    private SparkRBackend sparkRBackend;
    private String shinyPortRange;

    public IRInterpreter(Properties properties) {
        super("ir", properties);
    }

    protected boolean isSparkSupported() {
        return false;
    }

    protected int sparkVersion() {
        return 20404;
    }

    protected boolean isSecretSupported() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() throws InterpreterException {
        super.open();
        this.sparkRBackend = SparkRBackend.get();
        Object object = this.sparkRBackend;
        synchronized (object) {
            if (!this.sparkRBackend.isStarted()) {
                try {
                    this.sparkRBackend.init(this.isSecretSupported());
                }
                catch (Exception e) {
                    throw new InterpreterException("Fail to init SparkRBackend", (Throwable)e);
                }
                this.sparkRBackend.start();
            }
        }
        object = IRInterpreter.class;
        synchronized (IRInterpreter.class) {
            if (z == null) {
                z = new RZeppelinContext(this.getInterpreterGroup().getInterpreterHookRegistry(), Integer.parseInt(this.getProperty("zeppelin.R.maxResult", "1000")));
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            try {
                this.initIRKernel();
            }
            catch (IOException e) {
                throw new InterpreterException("Fail to init IR Kernel:\n" + ExceptionUtils.getStackTrace((Throwable)e), (Throwable)e);
            }
            try {
                this.shinyAppFolder = Files.createTempDirectory("zeppelin-shiny", new FileAttribute[0]).toFile();
                this.shinyAppFolder.deleteOnExit();
                this.shinyPortRange = this.properties.getProperty("zeppelin.R.shiny.portRange", ":");
            }
            catch (IOException e) {
                throw new InterpreterException((Throwable)e);
            }
            return;
        }
    }

    protected void initIRKernel() throws IOException, InterpreterException {
        String timeout = this.getProperty("spark.r.backendConnectionTimeout", "6000");
        InputStream input = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("R/zeppelin_isparkr.R");
        String code = IOUtils.toString((InputStream)input, (Charset)StandardCharsets.UTF_8).replace("${Port}", this.sparkRBackend.port() + "").replace("${version}", this.sparkVersion() + "").replace("${libPath}", "\"" + SparkRUtils.getSparkRLib(this.isSparkSupported()) + "\"").replace("${timeout}", timeout).replace("${isSparkSupported}", "\"" + this.isSparkSupported() + "\"").replace("${authSecret}", "\"" + this.sparkRBackend.socketSecret() + "\"");
        LOGGER.debug("Init IRKernel via script:\n{}", (Object)code);
        ExecuteResponse response = this.jupyterKernelClient.block_execute(ExecuteRequest.newBuilder().setCode(code).build());
        if (response.getStatus() != ExecuteStatus.SUCCESS) {
            throw new IOException("Fail to setup JVMGateway\n" + response.getOutput());
        }
    }

    protected Map<String, String> setupKernelEnv() throws IOException {
        Map envs = super.setupKernelEnv();
        String pathEnv = envs.getOrDefault("PATH", "");
        if (this.condaEnv != null) {
            pathEnv = new File(".").getAbsolutePath() + File.separator + this.condaEnv + File.separator + "bin" + File.pathSeparator + pathEnv;
            envs.put("PATH", pathEnv);
        }
        return envs;
    }

    public String getKernelName() {
        return "ir";
    }

    public ZeppelinContext buildZeppelinContext() {
        return new RZeppelinContext(this.getInterpreterGroup().getInterpreterHookRegistry(), Integer.parseInt(this.getProperty("zeppelin.r.maxResult", "1000")));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InterpreterResult shinyUI(String st, InterpreterContext context) throws InterpreterException {
        File uiFile = new File(this.shinyAppFolder, "ui.R");
        try (FileWriter writer = new FileWriter(uiFile);){
            IOUtils.copy((Reader)new StringReader(st), (Writer)writer);
            InterpreterResult interpreterResult = new InterpreterResult(InterpreterResult.Code.SUCCESS, "Write ui.R to " + this.shinyAppFolder.getAbsolutePath() + " successfully.");
            return interpreterResult;
        }
        catch (IOException e) {
            throw new InterpreterException("Fail to write shiny file ui.R", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InterpreterResult shinyServer(String st, InterpreterContext context) throws InterpreterException {
        File serverFile = new File(this.shinyAppFolder, "server.R");
        try (FileWriter writer = new FileWriter(serverFile);){
            IOUtils.copy((Reader)new StringReader(st), (Writer)writer);
            InterpreterResult interpreterResult = new InterpreterResult(InterpreterResult.Code.SUCCESS, "Write server.R to " + this.shinyAppFolder.getAbsolutePath() + " successfully.");
            return interpreterResult;
        }
        catch (IOException e) {
            throw new InterpreterException("Fail to write shiny file server.R", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InterpreterResult runShinyApp(InterpreterContext context) throws IOException, InterpreterException {
        this.getKernelProcessLauncher().setRedirectedContext(context);
        try {
            StringBuilder builder = new StringBuilder("library(shiny)\n");
            String host = RemoteInterpreterUtils.findAvailableHostAddress();
            int port = RemoteInterpreterUtils.findAvailablePort((String)this.shinyPortRange);
            builder.append("runApp(appDir='" + this.shinyAppFolder.getAbsolutePath() + "', port=" + port + ", host='" + host + "', launch.browser=FALSE)");
            LOGGER.info("Run shiny app code: {}", (Object)builder.toString());
            InterpreterResult interpreterResult = this.internalInterpret(builder.toString(), context);
            return interpreterResult;
        }
        finally {
            this.getKernelProcessLauncher().setRedirectedContext(null);
        }
    }

    public static RZeppelinContext getRZeppelinContext() {
        return z;
    }
}

