/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.r;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.zeppelin.interpreter.AbstractInterpreter;
import org.apache.zeppelin.interpreter.Interpreter;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.InterpreterException;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.interpreter.ZeppelinContext;
import org.apache.zeppelin.interpreter.thrift.InterpreterCompletion;
import org.apache.zeppelin.r.RDisplay;
import org.apache.zeppelin.r.RZeppelinContext;
import org.apache.zeppelin.r.SparkRBackend;
import org.apache.zeppelin.r.ZeppelinR;
import org.apache.zeppelin.r.ZeppelinRDisplay;
import org.apache.zeppelin.scheduler.Scheduler;
import org.apache.zeppelin.scheduler.SchedulerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RInterpreter
extends AbstractInterpreter {
    private static final Logger LOGGER = LoggerFactory.getLogger(RInterpreter.class);
    private static RZeppelinContext z;
    private SparkRBackend sparkRBackend;
    private ZeppelinR zeppelinR;
    private String renderOptions;
    private boolean useKnitr;
    private AtomicBoolean rbackendDead = new AtomicBoolean(false);

    public RInterpreter(Properties property) {
        super(property);
    }

    protected boolean isSparkSupported() {
        return false;
    }

    protected int sparkVersion() {
        return 20403;
    }

    protected boolean isSecretSupported() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() throws InterpreterException {
        this.sparkRBackend = SparkRBackend.get();
        Object object = this.sparkRBackend;
        synchronized (object) {
            if (!this.sparkRBackend.isStarted()) {
                try {
                    this.sparkRBackend.init(this.isSecretSupported());
                }
                catch (Exception e) {
                    throw new InterpreterException("Fail to init SparkRBackend", (Throwable)e);
                }
                this.sparkRBackend.start();
            }
        }
        object = RInterpreter.class;
        synchronized (RInterpreter.class) {
            if (z == null) {
                z = new RZeppelinContext(this.getInterpreterGroup().getInterpreterHookRegistry(), Integer.parseInt(this.getProperty("zeppelin.R.maxResult", "1000")));
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            this.renderOptions = this.getProperty("zeppelin.R.render.options", "out.format = 'html', comment = NA, echo = FALSE, results = 'asis', message = F, warning = F, fig.retina = 2");
            this.useKnitr = Boolean.parseBoolean(this.getProperty("zeppelin.R.knitr", "true"));
            this.zeppelinR = new ZeppelinR(this);
            try {
                this.zeppelinR.open();
                LOGGER.info("ZeppelinR is opened successfully.");
            }
            catch (IOException e) {
                throw new InterpreterException("Exception while opening RInterpreter", (Throwable)e);
            }
            if (this.useKnitr) {
                this.zeppelinR.eval("library('knitr')");
            }
            return;
        }
    }

    public InterpreterResult internalInterpret(String lines, InterpreterContext interpreterContext) throws InterpreterException {
        String imageWidth = this.getProperty("zeppelin.R.image.width", "100%");
        if (interpreterContext.getLocalProperties().containsKey("imageWidth")) {
            imageWidth = (String)interpreterContext.getLocalProperties().get("imageWidth");
        }
        try {
            if (this.rbackendDead.get()) {
                return new InterpreterResult(InterpreterResult.Code.ERROR, "sparkR backend is dead");
            }
            if (this.useKnitr) {
                this.zeppelinR.setInterpreterOutput(null);
                this.zeppelinR.set(".zcmd", "\n```{r " + this.renderOptions + "}\n" + lines + "\n```");
                this.zeppelinR.eval(".zres <- knit2html(text=.zcmd)");
                String html = this.zeppelinR.getS0(".zres");
                RDisplay rDisplay = ZeppelinRDisplay.render(html, imageWidth);
                return new InterpreterResult(rDisplay.getCode(), rDisplay.getTyp(), rDisplay.getContent());
            }
            this.zeppelinR.setInterpreterOutput(interpreterContext.out);
            this.zeppelinR.eval(lines);
            return new InterpreterResult(InterpreterResult.Code.SUCCESS, "");
        }
        catch (Exception e) {
            LOGGER.error("Exception while connecting to R", (Throwable)e);
            return new InterpreterResult(InterpreterResult.Code.ERROR, e.getMessage());
        }
    }

    public void close() throws InterpreterException {
        if (this.zeppelinR != null) {
            this.zeppelinR.close();
        }
    }

    public void cancel(InterpreterContext context) throws InterpreterException {
    }

    public Interpreter.FormType getFormType() {
        return Interpreter.FormType.NATIVE;
    }

    public int getProgress(InterpreterContext context) throws InterpreterException {
        return 0;
    }

    public Scheduler getScheduler() {
        return SchedulerFactory.singleton().createOrGetFIFOScheduler(RInterpreter.class.getName() + ((Object)((Object)this)).hashCode());
    }

    public ZeppelinContext getZeppelinContext() {
        return z;
    }

    public List<InterpreterCompletion> completion(String buf, int cursor, InterpreterContext interpreterContext) {
        return new ArrayList<InterpreterCompletion>();
    }

    public AtomicBoolean getRbackendDead() {
        return this.rbackendDead;
    }

    public static RZeppelinContext getRZeppelinContext() {
        return z;
    }
}

