/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.r;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.zeppelin.interpreter.AbstractInterpreter;
import org.apache.zeppelin.interpreter.Interpreter;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.InterpreterException;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.interpreter.ZeppelinContext;
import org.apache.zeppelin.r.IRInterpreter;
import org.apache.zeppelin.r.RZeppelinContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShinyInterpreter
extends AbstractInterpreter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ShinyInterpreter.class);
    private static final String DEFAULT_APP_NAME = "default";
    private Map<String, IRInterpreter> shinyIRInterpreters = new HashMap<String, IRInterpreter>();
    private RZeppelinContext z;

    public ShinyInterpreter(Properties properties) {
        super(properties);
    }

    public void open() throws InterpreterException {
        this.z = new RZeppelinContext(this.getInterpreterGroup().getInterpreterHookRegistry(), 1000);
    }

    public void close() throws InterpreterException {
        for (Map.Entry<String, IRInterpreter> entry : this.shinyIRInterpreters.entrySet()) {
            LOGGER.info("Closing IRInterpreter: {}", (Object)entry.getKey());
            entry.getValue().cancel(InterpreterContext.get());
            entry.getValue().close();
        }
    }

    public void cancel(InterpreterContext context) throws InterpreterException {
        String shinyApp = context.getStringLocalProperty("app", DEFAULT_APP_NAME);
        IRInterpreter irInterpreter = this.getIRInterpreter(shinyApp);
        irInterpreter.cancel(context);
    }

    public Interpreter.FormType getFormType() throws InterpreterException {
        return Interpreter.FormType.NATIVE;
    }

    public int getProgress(InterpreterContext context) throws InterpreterException {
        return 0;
    }

    public ZeppelinContext getZeppelinContext() {
        return this.z;
    }

    public InterpreterResult internalInterpret(String st, InterpreterContext context) throws InterpreterException {
        String shinyApp = context.getStringLocalProperty("app", DEFAULT_APP_NAME);
        String shinyType = context.getStringLocalProperty("type", "");
        IRInterpreter irInterpreter = this.getIRInterpreter(shinyApp);
        if (StringUtils.isBlank((CharSequence)shinyType)) {
            return irInterpreter.internalInterpret(st, context);
        }
        if (shinyType.equals("run")) {
            try {
                return irInterpreter.runShinyApp(context);
            }
            catch (IOException e) {
                throw new InterpreterException((Throwable)e);
            }
        }
        if (shinyType.equals("ui")) {
            return irInterpreter.shinyUI(st, context);
        }
        if (shinyType.equals("server")) {
            return irInterpreter.shinyServer(st, context);
        }
        throw new InterpreterException("Unknown shiny type: " + shinyType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IRInterpreter getIRInterpreter(String shinyApp) throws InterpreterException {
        IRInterpreter irInterpreter = null;
        Map<String, IRInterpreter> map = this.shinyIRInterpreters;
        synchronized (map) {
            irInterpreter = this.shinyIRInterpreters.get(shinyApp);
            if (irInterpreter == null) {
                irInterpreter = this.createIRInterpreter();
                irInterpreter.setInterpreterGroup(this.getInterpreterGroup());
                irInterpreter.open();
                this.shinyIRInterpreters.put(shinyApp, irInterpreter);
            }
        }
        return irInterpreter;
    }

    protected IRInterpreter createIRInterpreter() {
        return new IRInterpreter(this.properties);
    }
}

