/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.r;

import org.apache.spark.api.r.RBackend;
import scala.Tuple2;

public class SparkRBackend {
    private static SparkRBackend singleton;
    private RBackend backend = new RBackend();
    private boolean started = false;
    private int portNumber = 0;
    private String secret = "";
    private Thread backendThread = new Thread("SparkRBackend"){

        @Override
        public void run() {
            SparkRBackend.this.backend.run();
        }
    };

    public static synchronized SparkRBackend get() {
        if (singleton == null) {
            singleton = new SparkRBackend();
        }
        return singleton;
    }

    private SparkRBackend() {
    }

    public void init(boolean isSecretSocketSupported) throws Exception {
        Class<RBackend> rBackendClass = RBackend.class;
        if (isSecretSocketSupported) {
            Tuple2 result = (Tuple2)rBackendClass.getMethod("init", new Class[0]).invoke((Object)this.backend, new Object[0]);
            this.portNumber = (Integer)result._1;
            Object rAuthHelper = result._2;
            this.secret = (String)rAuthHelper.getClass().getMethod("secret", new Class[0]).invoke(rAuthHelper, new Object[0]);
        } else {
            this.portNumber = (Integer)rBackendClass.getMethod("init", new Class[0]).invoke((Object)this.backend, new Object[0]);
        }
    }

    public void start() {
        this.backendThread.start();
        this.started = true;
    }

    public void close() {
        this.backend.close();
        try {
            this.backendThread.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public boolean isStarted() {
        return this.started;
    }

    public int port() {
        return this.portNumber;
    }

    public String socketSecret() {
        return this.secret;
    }
}

