/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.r;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.r.RDisplay;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.safety.Whitelist;

public class ZeppelinRDisplay {
    private static Pattern pattern = Pattern.compile("^ *\\[\\d*\\]");

    public static RDisplay render(String html, String imageWidth) {
        Document document = Jsoup.parse((String)html);
        document.outputSettings().prettyPrint(false);
        Element body = document.body();
        if (body.getElementsByTag("p").isEmpty()) {
            return new RDisplay(body.html(), InterpreterResult.Type.HTML, InterpreterResult.Code.SUCCESS);
        }
        String bodyHtml = body.html();
        if (!(bodyHtml.contains("<img") || bodyHtml.contains("<script") || bodyHtml.contains("%html ") || bodyHtml.contains("%table ") || bodyHtml.contains("%img "))) {
            return ZeppelinRDisplay.textDisplay(body);
        }
        if (bodyHtml.contains("%table")) {
            return ZeppelinRDisplay.tableDisplay(body);
        }
        if (bodyHtml.contains("%img")) {
            return ZeppelinRDisplay.imgDisplay(body);
        }
        return ZeppelinRDisplay.htmlDisplay(body, imageWidth);
    }

    private static RDisplay textDisplay(Element body) {
        String text = Jsoup.clean((String)body.html(), (String)"", (Whitelist)Whitelist.none(), (Document.OutputSettings)new Document.OutputSettings().prettyPrint(false));
        return new RDisplay(text, InterpreterResult.Type.TEXT, InterpreterResult.Code.SUCCESS);
    }

    private static RDisplay tableDisplay(Element body) {
        String p = body.getElementsByTag("p").first().html().replace("\u201c%table ", "").replace("\u201d", "");
        Matcher matcher = pattern.matcher(p);
        if (matcher.matches()) {
            p = p.replace(matcher.group(), "");
        }
        String table = p.replace("\\t", "\t").replace("\\n", "\n");
        return new RDisplay(table, InterpreterResult.Type.TABLE, InterpreterResult.Code.SUCCESS);
    }

    private static RDisplay imgDisplay(Element body) {
        String p = body.getElementsByTag("p").first().html().replace("\u201c%img ", "").replace("\u201d", "");
        Matcher matcher = pattern.matcher(p);
        if (matcher.matches()) {
            p = p.replace(matcher.group(), "");
        }
        return new RDisplay(p, InterpreterResult.Type.IMG, InterpreterResult.Code.SUCCESS);
    }

    private static RDisplay htmlDisplay(Element body, String imageWidth) {
        String div = "";
        for (Element element : body.children()) {
            String eHtml = element.html();
            String eOuterHtml = element.outerHtml();
            eOuterHtml = eOuterHtml.replace("\u201c%html ", "").replace("\u201d", "");
            Matcher matcher = pattern.matcher(eHtml);
            if (matcher.matches()) {
                eOuterHtml = eOuterHtml.replace(matcher.group(), "");
            }
            div = div + eOuterHtml;
        }
        String content = div.replaceAll("src=\"//", "src=\"http://").replaceAll("href=\"//", "href=\"http://");
        body.html(content);
        for (Element image : body.getElementsByTag("img")) {
            image.attr("width", imageWidth);
        }
        return new RDisplay(body.html(), InterpreterResult.Type.HTML, InterpreterResult.Code.SUCCESS);
    }
}

