/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajde.ui.javaoptions;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import org.aspectj.ajde.ui.javaoptions.JavaBuildOptions;
import org.aspectj.ajde.ui.swing.OptionsPanel;

public class JavaCompilerWarningsOptionsPanel
extends OptionsPanel {
    private final String[] ignoreOrWarning = new String[]{"ignore", "warning"};
    private static final long serialVersionUID = 4491319302490183151L;
    private JPanel parentPanel;
    private Border warningsEtchedBorder;
    private TitledBorder warningsTitleBorder;
    private Border warningsCompoundBorder;
    private JPanel warningsPanel;
    private Box warningsBox = Box.createVerticalBox();
    private JavaBuildOptions javaBuildOptions;
    private Map warningComboBoxes = new HashMap();

    public JavaCompilerWarningsOptionsPanel(JavaBuildOptions javaBuildOptions) {
        this.javaBuildOptions = javaBuildOptions;
        try {
            this.jbInit();
            this.setName("Java Compiler Warning Options");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void loadOptions() throws IOException {
        this.createWarningContents();
    }

    @Override
    public void saveOptions() throws IOException {
        Set s = this.warningComboBoxes.entrySet();
        for (Map.Entry entry : s) {
            String javaOption = (String)entry.getKey();
            JComboBox combo = (JComboBox)entry.getValue();
            String value = (String)combo.getSelectedItem();
            this.javaBuildOptions.setOption(javaOption, value);
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(new BorderLayout());
        this.createBorders();
        this.addBordersToPanel();
        this.add((Component)this.parentPanel, "North");
    }

    private void createWarningContents() {
        this.createWarningsEntry("Method with a constructor name", "org.eclipse.jdt.core.compiler.problem.methodWithConstructorName");
        this.createWarningsEntry("Method overriden but not package visible", "org.eclipse.jdt.core.compiler.problem.overridingPackageDefaultMethod");
        this.createWarningsEntry("Deprecated API's", "org.eclipse.jdt.core.compiler.problem.deprecation");
        this.createWarningsEntry("Hidden catch block", "org.eclipse.jdt.core.compiler.problem.hiddenCatchBlock");
        this.createWarningsEntry("Unused local or private member", "org.eclipse.jdt.core.compiler.problem.unusedLocal");
        this.createWarningsEntry("Parameter is never read", "org.eclipse.jdt.core.compiler.problem.unusedParameter");
        this.createWarningsEntry("Unused import", "org.eclipse.jdt.core.compiler.problem.unusedImport");
        this.createWarningsEntry("Synthetic access", "org.eclipse.jdt.core.compiler.problem.syntheticAccessEmulation");
        this.createWarningsEntry("Assert identifier", "org.eclipse.jdt.core.compiler.problem.assertIdentifier");
        this.createWarningsEntry("Non-externalized strings", "org.eclipse.jdt.core.compiler.problem.nonExternalizedStringLiteral");
        this.warningsPanel.add((Component)this.warningsBox, null);
    }

    private void createWarningsEntry(String labelText, String javaOptionToSet) {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        JLabel label = new JLabel();
        label.setFont(new Font("Dialog", 0, 11));
        label.setText(labelText);
        panel.add((Component)label, "West");
        JComboBox<String> warnings = new JComboBox<String>(this.ignoreOrWarning);
        String value = this.javaBuildOptions.getJavaBuildOptionsMap().get(javaOptionToSet);
        if (value.equals("ignore")) {
            warnings.setSelectedIndex(0);
        } else {
            warnings.setSelectedIndex(1);
        }
        panel.add(warnings, "East");
        this.warningsBox.add((Component)panel, null);
        this.warningComboBoxes.put(javaOptionToSet, warnings);
    }

    private void createBorders() {
        this.warningsEtchedBorder = BorderFactory.createEtchedBorder(Color.white, new Color(156, 156, 158));
        this.warningsTitleBorder = new TitledBorder(this.warningsEtchedBorder, "Warning Options");
        this.warningsCompoundBorder = BorderFactory.createCompoundBorder(this.warningsTitleBorder, BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.warningsTitleBorder.setTitleFont(new Font("Dialog", 0, 11));
    }

    private void addBordersToPanel() {
        this.parentPanel = new JPanel();
        this.parentPanel.setLayout(new BorderLayout());
        this.warningsPanel = new JPanel();
        this.warningsPanel.setBorder(this.warningsCompoundBorder);
        this.parentPanel.add((Component)this.warningsPanel, "Center");
    }
}

