/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.core.nd.java;

import java.util.List;
import org.aspectj.org.eclipse.jdt.internal.core.nd.Nd;
import org.aspectj.org.eclipse.jdt.internal.core.nd.NdNode;
import org.aspectj.org.eclipse.jdt.internal.core.nd.db.IString;
import org.aspectj.org.eclipse.jdt.internal.core.nd.field.FieldByte;
import org.aspectj.org.eclipse.jdt.internal.core.nd.field.FieldManyToOne;
import org.aspectj.org.eclipse.jdt.internal.core.nd.field.FieldOneToMany;
import org.aspectj.org.eclipse.jdt.internal.core.nd.field.FieldString;
import org.aspectj.org.eclipse.jdt.internal.core.nd.field.StructDef;
import org.aspectj.org.eclipse.jdt.internal.core.nd.java.NdAnnotationInMethodParameter;
import org.aspectj.org.eclipse.jdt.internal.core.nd.java.NdMethod;
import org.aspectj.org.eclipse.jdt.internal.core.nd.java.NdTypeSignature;
import org.aspectj.org.eclipse.jdt.internal.core.util.CharArrayBuffer;

public class NdMethodParameter
extends NdNode {
    public static final FieldManyToOne<NdMethod> PARENT;
    public static final FieldManyToOne<NdTypeSignature> ARGUMENT_TYPE;
    public static final FieldString NAME;
    public static final FieldOneToMany<NdAnnotationInMethodParameter> ANNOTATIONS;
    public static final FieldByte FLAGS;
    private static final byte FLG_COMPILER_DEFINED = 1;
    public static StructDef<NdMethodParameter> type;

    static {
        type = StructDef.create(NdMethodParameter.class, NdNode.type);
        PARENT = FieldManyToOne.create(type, NdMethod.PARAMETERS);
        ARGUMENT_TYPE = FieldManyToOne.create(type, NdTypeSignature.USED_AS_METHOD_ARGUMENT);
        NAME = type.addString();
        ANNOTATIONS = FieldOneToMany.create(type, NdAnnotationInMethodParameter.OWNER);
        FLAGS = type.addByte();
        type.done();
    }

    public NdMethodParameter(Nd nd, long address) {
        super(nd, address);
    }

    public NdMethodParameter(NdMethod parent, NdTypeSignature argumentType) {
        super(parent.getNd());
        PARENT.put(this.getNd(), this.address, parent);
        ARGUMENT_TYPE.put(this.getNd(), this.address, argumentType);
    }

    public NdTypeSignature getType() {
        return ARGUMENT_TYPE.get(this.getNd(), this.address);
    }

    public void setName(char[] name) {
        NAME.put(this.getNd(), this.address, name);
    }

    public IString getName() {
        return NAME.get(this.getNd(), this.address);
    }

    public List<NdAnnotationInMethodParameter> getAnnotations() {
        return ANNOTATIONS.asList(this.getNd(), this.address);
    }

    private void setFlag(byte flagConstant, boolean value) {
        byte oldFlags = FLAGS.get(this.getNd(), this.address);
        int newFlags = oldFlags & ~flagConstant | (value ? flagConstant : (byte)0);
        FLAGS.put(this.getNd(), this.address, (byte)newFlags);
    }

    private boolean getFlag(byte flagConstant) {
        return (FLAGS.get(this.getNd(), this.address) & flagConstant) != 0;
    }

    public void setCompilerDefined(boolean isCompilerDefined) {
        this.setFlag((byte)1, isCompilerDefined);
    }

    public boolean isCompilerDefined() {
        return this.getFlag((byte)1);
    }

    public String toString() {
        try {
            CharArrayBuffer buf = new CharArrayBuffer();
            buf.append(this.getType().toString());
            buf.append(" ");
            buf.append(this.getName().toString());
            return buf.toString();
        }
        catch (RuntimeException e) {
            return super.toString();
        }
    }
}

