/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.resources.mapping;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public final class CompositeResourceMapping
extends ResourceMapping {
    private final ResourceMapping[] mappings;
    private final Object modelObject;
    private IProject[] projects;
    private String providerId;

    public CompositeResourceMapping(String providerId, Object modelObject, ResourceMapping[] mappings) {
        this.modelObject = modelObject;
        this.mappings = mappings;
        this.providerId = providerId;
    }

    @Override
    public boolean contains(ResourceMapping mapping) {
        int i = 0;
        while (i < this.mappings.length) {
            ResourceMapping childMapping = this.mappings[i];
            if (childMapping.contains(mapping)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public ResourceMapping[] getMappings() {
        return this.mappings;
    }

    @Override
    public Object getModelObject() {
        return this.modelObject;
    }

    @Override
    public String getModelProviderId() {
        return this.providerId;
    }

    @Override
    public IProject[] getProjects() {
        if (this.projects == null) {
            HashSet<IProject> result = new HashSet<IProject>();
            int i = 0;
            while (i < this.mappings.length) {
                ResourceMapping mapping = this.mappings[i];
                result.addAll(Arrays.asList(mapping.getProjects()));
                ++i;
            }
            this.projects = result.toArray(new IProject[result.size()]);
        }
        return this.projects;
    }

    @Override
    public ResourceTraversal[] getTraversals(ResourceMappingContext context, IProgressMonitor monitor) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert(monitor, this.mappings.length);
        ArrayList result = new ArrayList();
        int i = 0;
        while (i < this.mappings.length) {
            ResourceMapping mapping = this.mappings[i];
            Collections.addAll(result, mapping.getTraversals(context, subMonitor.newChild(1)));
            ++i;
        }
        return result.toArray(new ResourceTraversal[result.size()]);
    }
}

