/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.core.dom;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.aspectj.org.eclipse.jdt.core.dom.AST;
import org.aspectj.org.eclipse.jdt.core.dom.ASTNode;
import org.aspectj.org.eclipse.jdt.core.dom.ASTVisitor;
import org.aspectj.org.eclipse.jdt.core.dom.AdviceDeclaration;
import org.aspectj.org.eclipse.jdt.core.dom.AjTypeDeclaration;
import org.aspectj.org.eclipse.jdt.core.dom.ChildPropertyDescriptor;
import org.aspectj.org.eclipse.jdt.core.dom.Javadoc;
import org.aspectj.org.eclipse.jdt.core.dom.Name;
import org.aspectj.org.eclipse.jdt.core.dom.SimpleName;
import org.aspectj.org.eclipse.jdt.core.dom.SimplePropertyDescriptor;
import org.aspectj.org.eclipse.jdt.core.dom.Type;

public class AspectDeclaration
extends AjTypeDeclaration {
    public static final ChildPropertyDescriptor PERCLAUSE_PROPERTY = new ChildPropertyDescriptor(AspectDeclaration.class, "perClause", ASTNode.class, false, false);
    public static final SimplePropertyDescriptor PRIVILEGED_PROPERTY = new SimplePropertyDescriptor(AspectDeclaration.class, "privileged", Boolean.TYPE, true);
    protected static List aspectPROPERTY_DESCRIPTORS_2_0;
    protected static List aspectPROPERTY_DESCRIPTORS_3_0;
    protected ASTNode perClause = null;
    private boolean isPrivileged = false;

    AspectDeclaration(AST ast) {
        super(ast);
    }

    AspectDeclaration(AST ast, ASTNode perClause) {
        this(ast);
        this.perClause = perClause;
        this.setAspect(true);
    }

    AspectDeclaration(AST ast, ASTNode perClause, boolean isPrivileged) {
        this(ast, perClause);
        this.isPrivileged = isPrivileged;
    }

    ASTNode clone0(AST target) {
        AspectDeclaration result = new AspectDeclaration(target, this.perClause);
        result.setSourceRange(this.getStartPosition(), this.getLength());
        result.setJavadoc((Javadoc)ASTNode.copySubtree(target, this.getJavadoc()));
        if (this.ast.apiLevel == 2) {
            result.internalSetModifiers(this.getModifiers());
            result.setSuperclass((Name)ASTNode.copySubtree(target, this.getSuperclass()));
            result.superInterfaces().addAll(ASTNode.copySubtrees(target, this.superInterfaces()));
        }
        result.setInterface(this.isInterface());
        result.setAspect(this.isAspect());
        result.setPrivileged(this.isPrivileged());
        result.setName((SimpleName)this.getName().clone(target));
        if (this.ast.apiLevel >= 3) {
            result.modifiers().addAll(ASTNode.copySubtrees(target, this.modifiers()));
            result.typeParameters().addAll(ASTNode.copySubtrees(target, this.typeParameters()));
            result.setSuperclassType((Type)ASTNode.copySubtree(target, this.getSuperclassType()));
            result.superInterfaceTypes().addAll(ASTNode.copySubtrees(target, this.superInterfaceTypes()));
        }
        result.bodyDeclarations().addAll(ASTNode.copySubtrees(target, this.bodyDeclarations()));
        result.setPerClause(this.getPerClause().clone(target));
        return result;
    }

    void accept0(ASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            if (this.ast.apiLevel == 2) {
                this.acceptChild(visitor, this.getJavadoc());
                this.acceptChild(visitor, this.getName());
                this.acceptChild(visitor, this.getSuperclass());
                this.acceptChildren(visitor, this.superInterfaceNames);
                this.acceptChild(visitor, this.perClause);
                this.acceptChildren(visitor, this.bodyDeclarations);
            }
            if (this.ast.apiLevel >= 3) {
                this.acceptChild(visitor, this.getJavadoc());
                this.acceptChildren(visitor, this.modifiers);
                this.acceptChild(visitor, this.getName());
                this.acceptChildren(visitor, this.typeParameters);
                this.acceptChild(visitor, this.getSuperclassType());
                this.acceptChildren(visitor, this.superInterfaceTypes);
                this.acceptChild(visitor, this.perClause);
                this.acceptChildren(visitor, this.bodyDeclarations);
            }
        }
        visitor.endVisit(this);
    }

    final boolean internalGetSetBooleanProperty(SimplePropertyDescriptor property, boolean get, boolean value) {
        if (property == PRIVILEGED_PROPERTY) {
            if (get) {
                return this.isPrivileged();
            }
            this.setPrivileged(value);
            return false;
        }
        return super.internalGetSetBooleanProperty(property, get, value);
    }

    final ASTNode internalGetSetChildProperty(ChildPropertyDescriptor property, boolean get, ASTNode child) {
        if (property == PERCLAUSE_PROPERTY) {
            if (get) {
                return this.getPerClause();
            }
            this.setPerClause(child);
            return null;
        }
        return super.internalGetSetChildProperty(property, get, child);
    }

    public static List propertyDescriptors(int apiLevel) {
        if (apiLevel == 2) {
            return aspectPROPERTY_DESCRIPTORS_2_0;
        }
        return aspectPROPERTY_DESCRIPTORS_3_0;
    }

    public ASTNode getPerClause() {
        return this.perClause;
    }

    public void setPerClause(ASTNode perClause) {
        if (perClause == null) {
            throw new IllegalArgumentException();
        }
        ASTNode oldChild = this.perClause;
        this.preReplaceChild(oldChild, perClause, PERCLAUSE_PROPERTY);
        this.perClause = perClause;
        this.postReplaceChild(oldChild, perClause, PERCLAUSE_PROPERTY);
    }

    public boolean isPrivileged() {
        return this.isPrivileged;
    }

    public void setPrivileged(boolean isPrivileged) {
        this.preValueChange(PRIVILEGED_PROPERTY);
        this.isPrivileged = isPrivileged;
        this.postValueChange(PRIVILEGED_PROPERTY);
    }

    public List getAdvice() {
        List bd = this.bodyDeclarations();
        ArrayList advice = new ArrayList();
        ListIterator it = bd.listIterator();
        while (it.hasNext()) {
            Object decl = it.next();
            if (!(decl instanceof AdviceDeclaration)) continue;
            advice.add(decl);
        }
        return advice;
    }

    static {
        ArrayList temporary = new ArrayList();
        AspectDeclaration.createPropertyList(AspectDeclaration.class, temporary);
        temporary.addAll(ajPROPERTY_DESCRIPTORS_2_0);
        AspectDeclaration.addProperty(PERCLAUSE_PROPERTY, temporary);
        AspectDeclaration.addProperty(PRIVILEGED_PROPERTY, temporary);
        aspectPROPERTY_DESCRIPTORS_2_0 = AspectDeclaration.reapPropertyList(temporary);
        temporary.clear();
        AspectDeclaration.createPropertyList(AspectDeclaration.class, temporary);
        temporary.addAll(ajPROPERTY_DESCRIPTORS_3_0);
        AspectDeclaration.addProperty(PERCLAUSE_PROPERTY, temporary);
        AspectDeclaration.addProperty(PRIVILEGED_PROPERTY, temporary);
        aspectPROPERTY_DESCRIPTORS_3_0 = AspectDeclaration.reapPropertyList(temporary);
    }
}

