/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.core.dom;

import org.aspectj.org.eclipse.jdt.core.dom.AST;
import org.aspectj.org.eclipse.jdt.core.dom.ASTVisitor;
import org.aspectj.org.eclipse.jdt.core.dom.AjASTVisitor;
import org.aspectj.org.eclipse.jdt.core.dom.Name;
import org.aspectj.org.eclipse.jdt.core.dom.SimpleName;
import org.aspectj.org.eclipse.jdt.core.dom.SimpleType;
import org.aspectj.org.eclipse.jdt.core.dom.Type;
import org.aspectj.org.eclipse.jdt.core.dom.TypePattern;

public abstract class IdentifierTypePattern
extends TypePattern {
    private Type type;

    IdentifierTypePattern(AST ast, Type type) {
        super(ast);
        this.type = type;
        this.setTypePatternExpression(this.generateTypePatternExpression(this.type));
    }

    public Type getType() {
        return this.type;
    }

    protected String generateTypePatternExpression(Type type) {
        Name name;
        String typeExpression = null;
        if (type instanceof SimpleType && (name = ((SimpleType)type).getName()) instanceof SimpleName) {
            typeExpression = ((SimpleName)name).getIdentifier();
        }
        if (typeExpression == null && type != null) {
            typeExpression = type.toString();
        }
        return typeExpression;
    }

    int memSize() {
        int memSize = super.memSize();
        Type type = this.getType();
        if (type != null) {
            memSize += type.memSize();
        }
        return memSize;
    }

    void accept0(ASTVisitor visitor) {
        if (visitor instanceof AjASTVisitor) {
            AjASTVisitor ajVisitor = (AjASTVisitor)visitor;
            boolean visited = ajVisitor.visit(this);
            Type type = this.getType();
            if (visited && type != null) {
                ajVisitor.visit(type);
            }
            ajVisitor.endVisit(this);
        }
    }
}

