/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.core.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.aspectj.org.eclipse.jdt.core.ICompilationUnit;
import org.aspectj.org.eclipse.jdt.core.IJavaElement;
import org.aspectj.org.eclipse.jdt.core.IJavaProject;
import org.aspectj.org.eclipse.jdt.core.IPackageFragment;
import org.aspectj.org.eclipse.jdt.core.IPackageFragmentRoot;
import org.aspectj.org.eclipse.jdt.core.compiler.CharOperation;
import org.aspectj.org.eclipse.jdt.internal.compiler.CompilationResult;
import org.aspectj.org.eclipse.jdt.internal.compiler.Compiler;
import org.aspectj.org.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.aspectj.org.eclipse.jdt.internal.compiler.ICompilerRequestor;
import org.aspectj.org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.aspectj.org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.aspectj.org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.aspectj.org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.aspectj.org.eclipse.jdt.internal.core.BasicCompilationUnit;
import org.aspectj.org.eclipse.jdt.internal.core.ClasspathEntry;
import org.aspectj.org.eclipse.jdt.internal.core.CompilationGroup;
import org.aspectj.org.eclipse.jdt.internal.core.builder.NameEnvironment;
import org.aspectj.org.eclipse.jdt.internal.core.builder.ProblemFactory;
import org.eclipse.core.runtime.CoreException;

public class ModuleUtil {
    private static Compiler newCompiler(ModuleAccumulatorEnvironment environment, IJavaProject javaProject) {
        Map<String, String> projectOptions = javaProject.getOptions(true);
        CompilerOptions compilerOptions = new CompilerOptions(projectOptions);
        compilerOptions.performMethodsFullRecovery = true;
        compilerOptions.performStatementsRecovery = true;
        ICompilerRequestor requestor = new ICompilerRequestor(){

            @Override
            public void acceptResult(CompilationResult result) {
            }
        };
        Compiler newCompiler = new Compiler((INameEnvironment)environment, DefaultErrorHandlingPolicies.proceedWithAllProblems(), compilerOptions, requestor, (IProblemFactory)ProblemFactory.getProblemFactory(Locale.getDefault()));
        return newCompiler;
    }

    public static String[] getReferencedModules(IJavaProject project) throws CoreException {
        String[] mods;
        IPackageFragmentRoot[] roots;
        ModuleAccumulatorEnvironment environment = new ModuleAccumulatorEnvironment(project);
        Compiler compiler = ModuleUtil.newCompiler(environment, project);
        ArrayList<String> required = new ArrayList<String>();
        HashSet<BasicCompilationUnit> toCompile = new HashSet<BasicCompilationUnit>();
        IPackageFragmentRoot[] iPackageFragmentRootArray = roots = project.getPackageFragmentRoots();
        int n = roots.length;
        int n2 = 0;
        while (n2 < n) {
            IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
            if (root.getKind() == 1) {
                IJavaElement[] children;
                IJavaElement[] iJavaElementArray = children = root.getChildren();
                int n3 = children.length;
                int n4 = 0;
                while (n4 < n3) {
                    ICompilationUnit[] units;
                    IPackageFragment fragment;
                    IJavaElement child = iJavaElementArray[n4];
                    if (child instanceof IPackageFragment && !(fragment = (IPackageFragment)child).isDefaultPackage() && (units = fragment.getCompilationUnits()).length != 0) {
                        String pack = fragment.getElementName();
                        ICompilationUnit[] iCompilationUnitArray = units;
                        int n5 = units.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            ICompilationUnit iUnit = iCompilationUnitArray[n6];
                            BasicCompilationUnit sourceFile = new BasicCompilationUnit(iUnit.getSource().toCharArray(), CharOperation.splitOn('.', pack.toCharArray()), iUnit.getPath().toOSString(), iUnit);
                            toCompile.add(sourceFile);
                            ++n6;
                        }
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        org.aspectj.org.eclipse.jdt.internal.compiler.env.ICompilationUnit[] sources = new org.aspectj.org.eclipse.jdt.internal.compiler.env.ICompilationUnit[toCompile.size()];
        toCompile.toArray(sources);
        compiler.compile(sources);
        String[] stringArray = mods = environment.getModules();
        int n7 = mods.length;
        int n8 = 0;
        while (n8 < n7) {
            String string = stringArray[n8];
            required.add(string);
            ++n8;
        }
        Collections.sort(required, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareTo(o2);
            }
        });
        return required.toArray(new String[required.size()]);
    }

    static class ModuleAccumulatorEnvironment
    extends NameEnvironment {
        Set<String> modules = new HashSet<String>();

        public ModuleAccumulatorEnvironment(IJavaProject javaProject) {
            super(javaProject, CompilationGroup.MAIN);
        }

        public String[] getModules() {
            this.modules.remove(String.valueOf(TypeConstants.JAVA_BASE));
            String[] mods = new String[this.modules.size()];
            return this.modules.toArray(mods);
        }

        @Override
        protected boolean isOnModulePath(ClasspathEntry entry) {
            return true;
        }

        @Override
        public void cleanup() {
            this.modules.clear();
        }

        @Override
        public NameEnvironmentAnswer findType(char[][] compoundTypeName, char[] moduleName) {
            NameEnvironmentAnswer answer = super.findType(compoundTypeName, moduleName);
            if (answer != null && answer.moduleName() != null) {
                this.modules.add(String.valueOf(answer.moduleName()));
            }
            return answer;
        }

        @Override
        public NameEnvironmentAnswer findType(char[] typeName, char[][] packageName, char[] moduleName) {
            NameEnvironmentAnswer answer = super.findType(typeName, packageName, moduleName);
            if (answer != null && answer.moduleName() != null) {
                this.modules.add(String.valueOf(answer.moduleName()));
            }
            return answer;
        }
    }
}

