/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajde.ui;

import java.util.List;
import org.aspectj.ajde.Ajde;
import org.aspectj.ajde.ui.AbstractIcon;
import org.aspectj.ajde.ui.AbstractIconRegistry;
import org.aspectj.ajde.ui.IStructureViewNode;
import org.aspectj.asm.AsmManager;
import org.aspectj.asm.IProgramElement;
import org.aspectj.asm.IRelationship;
import org.aspectj.asm.IRelationshipMap;

public abstract class StructureViewNodeFactory {
    private final AbstractIconRegistry iconRegistry;

    public StructureViewNodeFactory(AbstractIconRegistry iconRegistry) {
        this.iconRegistry = iconRegistry;
    }

    public IStructureViewNode createNode(IProgramElement node) {
        return this.createNode(node, null);
    }

    public IStructureViewNode createNode(IProgramElement node, List children) {
        AbstractIcon icon = this.iconRegistry.getStructureIcon(node.getKind(), node.getAccessibility());
        IStructureViewNode svNode = this.createDeclaration(node, icon, children);
        String nodeHandle = node.getHandleIdentifier();
        if (nodeHandle != null && !node.getKind().equals(IProgramElement.Kind.FIELD)) {
            List<IRelationship> relationships;
            AsmManager manager = Ajde.getDefault().getModel();
            IRelationshipMap relMap = manager == null ? null : manager.getRelationshipMap();
            List<IRelationship> list = relationships = relMap == null ? null : relMap.get(nodeHandle);
            if (relationships != null) {
                for (IRelationship relationship : relationships) {
                    IStructureViewNode relNode;
                    IRelationship rel = relationship;
                    if (rel == null || rel.getTargets().size() <= 0 || (relNode = this.createRelationship(rel, this.iconRegistry.getIcon(rel.getKind()))) == null) continue;
                    svNode.add(relNode, 0);
                    for (String handle : rel.getTargets()) {
                        IProgramElement link = Ajde.getDefault().getModel().getHierarchy().findElementForHandle(handle);
                        if (link == null) continue;
                        IStructureViewNode linkNode = this.createLink(link, this.iconRegistry.getStructureIcon(link.getKind(), link.getAccessibility()));
                        relNode.add(linkNode);
                    }
                }
            }
        }
        return svNode;
    }

    protected abstract IStructureViewNode createLink(IProgramElement var1, AbstractIcon var2);

    protected abstract IStructureViewNode createRelationship(IRelationship var1, AbstractIcon var2);

    protected abstract IStructureViewNode createDeclaration(IProgramElement var1, AbstractIcon var2, List var3);

    public static boolean acceptNode(IProgramElement parent, IProgramElement child) {
        return parent.getKind() != IProgramElement.Kind.CLASS || child.getKind() != IProgramElement.Kind.CODE;
    }
}

