/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.compiler.parser;

import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import org.aspectj.ajdt.internal.compiler.parser.AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions;
import org.aspectj.org.eclipse.jdt.core.compiler.CharOperation;
import org.aspectj.org.eclipse.jdt.internal.compiler.CompilationResult;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Argument;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ConstructorDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Expression;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Literal;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.SingleTypeReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeParameter;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.parser.RecoveredType;
import org.aspectj.org.eclipse.jdt.internal.compiler.parser.Scanner;
import org.aspectj.org.eclipse.jdt.internal.compiler.parser.TheOriginalJDTParserClass;
import org.aspectj.org.eclipse.jdt.internal.compiler.problem.ProblemReporter;

public class Parser
extends TheOriginalJDTParserClass {
    private static final String ASPECTJ_DECLARATION_FACTORY = "org.aspectj.ajdt.internal.compiler.parser.DeclarationFactory";
    private static IDeclarationFactory declarationFactory;
    protected int aspectIntPtr;
    protected int[] aspectIntStack;
    private static final boolean AJ_DEBUG = false;

    static {
        try {
            Parser.initTables(Parser.class);
            declarationFactory = (IDeclarationFactory)Class.forName(ASPECTJ_DECLARATION_FACTORY).newInstance();
        }
        catch (IOException ex) {
            throw new ExceptionInInitializerError(ex.getMessage());
        }
        catch (InstantiationException ex) {
            throw new ExceptionInInitializerError(ex.getMessage());
        }
        catch (IllegalAccessException ex) {
            throw new ExceptionInInitializerError(ex.getMessage());
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("Warning: AspectJ declaration factory class not found on classpath");
        }
    }

    @Override
    public void initialize() {
        super.initialize();
        this.aspectIntPtr = -1;
        this.aspectIntStack = new int[4];
    }

    @Override
    public void initialize(boolean initializeNLS) {
        super.initialize(initializeNLS);
        this.aspectIntPtr = -1;
        this.aspectIntStack = new int[4];
    }

    @Override
    public void initializeScanner() {
        this.scanner = new Scanner(false, false, this.options.getSeverity(256) != 256, this.options.sourceLevel, this.options.taskTags, this.options.taskPriorities, this.options.isTaskCaseSensitive, this.options.enablePreviewFeatures);
    }

    void println(Object o) {
    }

    private void printStack(Object[] s, int p) {
        List<Object> list = Arrays.asList(s);
        System.out.println("  " + list.subList(0, p + 1));
    }

    private void printStack(int[] s, int p) {
        StringBuffer buf = new StringBuffer("[");
        int i = 0;
        while (i < p + 1) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(Integer.toString(s[i]));
            ++i;
        }
        buf.append("]");
        System.out.println("  " + buf);
    }

    private void printStack(long[] s, int p) {
        StringBuffer buf = new StringBuffer("[");
        int i = 0;
        while (i < p + 1) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(Long.toString(s[i]));
            ++i;
        }
        buf.append("]");
        System.out.println("  " + buf);
    }

    private void printStack(char[][] s, int p) {
        StringBuffer buf = new StringBuffer("[");
        int i = 0;
        while (i < p + 1) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(new String(s[i]));
            ++i;
        }
        buf.append("]");
        System.out.println("  " + buf);
    }

    public void display() {
    }

    @Override
    protected MethodDeclaration createMethodDeclaration(CompilationResult result) {
        return declarationFactory.createMethodDeclaration(result);
    }

    @Override
    protected ConstructorDeclaration createConstructorDeclaration(CompilationResult result) {
        return declarationFactory.createConstructorDeclaration(result);
    }

    @Override
    protected void consumeMethodInvocationName() {
        super.consumeMethodInvocationName();
        MessageSend m = (MessageSend)this.expressionStack[this.expressionPtr];
        if (CharOperation.equals(m.selector, "proceed".toCharArray())) {
            this.expressionStack[this.expressionPtr] = declarationFactory.createProceed(m);
        }
    }

    @Override
    protected void consumeToken(int type) {
        this.currentTokenStart = this.scanner.startPosition;
        super.consumeToken(type);
        switch (type) {
            case 24: {
                this.pushOnAspectIntStack(this.scanner.currentPosition - 1);
                this.pushOnAspectIntStack(this.scanner.startPosition);
            }
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                this.pushIdentifier();
                this.flushCommentsDefinedPriorTo(this.currentTokenStart);
                this.scanner.commentPtr = -1;
            }
        }
    }

    protected void consumeAspectDeclaration() {
        this.consumeClassDeclaration();
    }

    protected void consumeAspectHeader() {
        this.consumeClassHeader();
    }

    protected void consumeAspectHeaderName(boolean isPrivileged) {
        TypeDeclaration aspectDecl = declarationFactory.createAspect(this.compilationUnit.compilationResult);
        if (this.nestedMethod[this.nestedType] == 0) {
            if (this.nestedType != 0) {
                aspectDecl.bits |= 0x400;
            }
        } else {
            aspectDecl.bits |= 0x100;
            this.markEnclosingMemberWithLocalType();
            this.blockReal();
        }
        this.println("aspect header name: ");
        this.display();
        long pos = this.identifierPositionStack[this.identifierPtr];
        aspectDecl.sourceEnd = (int)pos;
        aspectDecl.sourceStart = (int)(pos >>> 32);
        aspectDecl.name = this.identifierStack[this.identifierPtr--];
        --this.identifierLengthPtr;
        aspectDecl.declarationSourceStart = this.aspectIntStack[this.aspectIntPtr--];
        --this.aspectIntPtr;
        this.eatIdentifier();
        if (isPrivileged) {
            pos = this.eatIdentifier();
            declarationFactory.setPrivileged(aspectDecl, true);
        }
        aspectDecl.modifiersSourceStart = this.intStack[this.intPtr--];
        aspectDecl.modifiers = this.intStack[this.intPtr--];
        if (isPrivileged) {
            aspectDecl.modifiersSourceStart = this.intStack[this.intPtr--];
            aspectDecl.modifiers |= this.intStack[this.intPtr--];
        }
        if (aspectDecl.modifiersSourceStart >= 0) {
            aspectDecl.declarationSourceStart = aspectDecl.modifiersSourceStart;
        }
        this.println("modifiers: " + aspectDecl.modifiers);
        int length = this.expressionLengthStack[this.expressionLengthPtr--];
        if (length != 0) {
            aspectDecl.annotations = new Annotation[length];
            System.arraycopy(this.expressionStack, (this.expressionPtr -= length) + 1, aspectDecl.annotations, 0, length);
        }
        aspectDecl.bodyStart = aspectDecl.sourceEnd + 1;
        this.pushOnAstStack(aspectDecl);
        this.listLength = 0;
        if (this.currentElement != null) {
            this.lastCheckPoint = aspectDecl.bodyStart;
            this.currentElement = this.currentElement.add(aspectDecl, 0);
            this.lastIgnoredToken = -1;
        }
        aspectDecl.javadoc = this.javadoc;
        this.javadoc = null;
        this.display();
    }

    protected void consumeAspectHeaderNameWithTypeParameters(boolean isPriviliged) {
        TypeDeclaration typeDecl = (TypeDeclaration)this.astStack[this.astPtr];
        int length = this.genericsLengthStack[this.genericsLengthPtr--];
        this.genericsPtr -= length;
        typeDecl.typeParameters = new TypeParameter[length];
        System.arraycopy(this.genericsStack, this.genericsPtr + 1, typeDecl.typeParameters, 0, length);
        typeDecl.bodyStart = typeDecl.typeParameters[length - 1].declarationSourceEnd + 1;
        this.listTypeParameterLength = 0;
        if (this.currentElement != null) {
            this.lastCheckPoint = typeDecl.bodyStart;
        }
    }

    private long eatIdentifier() {
        long pos = this.identifierPositionStack[this.identifierPtr];
        --this.identifierPtr;
        --this.identifierLengthPtr;
        return pos;
    }

    protected void consumeAspectHeaderRest() {
        this.concatNodeLists();
        this.display();
        ASTNode pseudoTokens = this.popPseudoTokens("{");
        this.println("pseudo: " + pseudoTokens);
        TypeDeclaration aspectDecl = (TypeDeclaration)this.astStack[this.astPtr];
        declarationFactory.setDominatesPatternFrom(aspectDecl, pseudoTokens, this);
        declarationFactory.setPerClauseFrom(aspectDecl, pseudoTokens, this);
    }

    protected void consumePointcutDeclaration() {
        this.consumePointcutDesignatorOnDeclaration();
        AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions.aspectOf().ajc$afterReturning$org_aspectj_ajdt_internal_compiler_parser_AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions$2$133468e6();
    }

    public int getCurrentTokenStart() {
        return this.currentTokenStart;
    }

    protected void consumeEmptyPointcutDeclaration() {
        MethodDeclaration pcutDecl = (MethodDeclaration)this.astStack[this.astPtr];
        pcutDecl.bodyEnd = this.endStatementPosition;
    }

    protected void consumePointcutHeader() {
        MethodDeclaration ret = declarationFactory.createPointcutDeclaration(this.compilationUnit.compilationResult);
        long pos = this.identifierPositionStack[this.identifierPtr];
        ret.sourceStart = (int)(pos >>> 32);
        ret.selector = this.identifierStack[this.identifierPtr--];
        --this.identifierLengthPtr;
        ret.javadoc = this.javadoc;
        this.javadoc = null;
        this.eatIdentifier();
        ret.declarationSourceStart = this.intStack[this.intPtr--];
        ret.modifiers = this.intStack[this.intPtr--];
        int length = this.expressionLengthStack[this.expressionLengthPtr--];
        if (length != 0) {
            ret.annotations = new Annotation[length];
            System.arraycopy(this.expressionStack, (this.expressionPtr -= length) + 1, ret.annotations, 0, length);
        }
        this.pushOnAstStack(ret);
        AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions.aspectOf().ajc$afterReturning$org_aspectj_ajdt_internal_compiler_parser_AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions$2$133468e6();
    }

    protected void consumeAroundDeclaration() {
        this.consumeMethodDeclaration(true, false);
    }

    protected void consumeAroundHeader() {
        this.consumePointcutDesignatorOnAdvice();
        this.resetModifiers();
        this.consumeMethodHeader();
    }

    protected void consumeAroundHeaderName() {
        int length;
        MethodDeclaration adviceDecl = declarationFactory.createAroundAdviceDeclaration(this.compilationUnit.compilationResult);
        long pos = this.eatIdentifier();
        adviceDecl.sourceStart = (int)(pos >>> 32);
        adviceDecl.selector = new char[]{'a', 'j', 'c', '$', 'a', 'd', 'v', 'i', 'c', 'e'};
        TypeReference returnType = this.getTypeReference(this.intStack[this.intPtr--]);
        adviceDecl.declarationSourceStart = this.intStack[this.intPtr--];
        adviceDecl.modifiers = this.intStack[this.intPtr--];
        adviceDecl.returnType = returnType;
        if ((length = this.expressionLengthStack[this.expressionLengthPtr--]) != 0) {
            adviceDecl.annotations = new Annotation[length];
            System.arraycopy(this.expressionStack, (this.expressionPtr -= length) + 1, adviceDecl.annotations, 0, length);
        }
        adviceDecl.javadoc = this.javadoc;
        this.javadoc = null;
        this.pushOnAstStack(adviceDecl);
    }

    protected void consumePointcutDesignatorOnAdvice() {
        ASTNode des = this.popPointcutDesignator("{");
        MethodDeclaration adviceDecl = (MethodDeclaration)this.astStack[this.astPtr];
        declarationFactory.setPointcutDesignatorOnAdvice(adviceDecl, des);
        adviceDecl.sourceEnd = des.sourceEnd;
        adviceDecl.bodyStart = des.sourceEnd + 1;
        AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions.aspectOf().ajc$afterReturning$org_aspectj_ajdt_internal_compiler_parser_AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions$2$133468e6();
    }

    protected void consumePointcutDesignatorOnDeclaration() {
        ASTNode des = this.popPointcutDesignator(";");
        MethodDeclaration pcutDecl = (MethodDeclaration)this.astStack[this.astPtr];
        declarationFactory.setPointcutDesignatorOnPointcut(pcutDecl, des);
        pcutDecl.sourceEnd = des.sourceEnd;
        pcutDecl.bodyStart = des.sourceEnd + 1;
        pcutDecl.bodyEnd = this.endPosition;
        pcutDecl.declarationSourceEnd = this.flushCommentsDefinedPriorTo(this.endStatementPosition);
        AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions.aspectOf().ajc$afterReturning$org_aspectj_ajdt_internal_compiler_parser_AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions$2$133468e6();
    }

    protected void consumeBasicAdviceDeclaration() {
        this.consumeMethodDeclaration(true, false);
        AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions.aspectOf().ajc$afterReturning$org_aspectj_ajdt_internal_compiler_parser_AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions$2$133468e6();
    }

    protected void consumeBasicAdviceHeader() {
        this.consumePointcutDesignatorOnAdvice();
        this.resetModifiers();
        this.consumeMethodHeader();
        AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions.aspectOf().ajc$afterReturning$org_aspectj_ajdt_internal_compiler_parser_AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions$2$133468e6();
    }

    protected void consumeBasicAdviceHeaderName(boolean isAfter) {
        int length;
        MethodDeclaration adviceDecl = isAfter ? declarationFactory.createAfterAdviceDeclaration(this.compilationUnit.compilationResult) : declarationFactory.createBeforeAdviceDeclaration(this.compilationUnit.compilationResult);
        long pos = this.eatIdentifier();
        adviceDecl.selector = new char[]{'a', 'j', 'c', '$', 'a', 'd', 'v', 'i', 'c', 'e'};
        adviceDecl.sourceStart = (int)(pos >>> 32);
        adviceDecl.declarationSourceStart = this.intStack[this.intPtr--];
        adviceDecl.modifiers = this.intStack[this.intPtr--];
        if ((length = this.expressionLengthStack[this.expressionLengthPtr--]) != 0) {
            adviceDecl.annotations = new Annotation[length];
            System.arraycopy(this.expressionStack, (this.expressionPtr -= length) + 1, adviceDecl.annotations, 0, length);
        }
        adviceDecl.javadoc = this.javadoc;
        this.javadoc = null;
        this.pushOnAstStack(adviceDecl);
        AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions.aspectOf().ajc$afterReturning$org_aspectj_ajdt_internal_compiler_parser_AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions$2$133468e6();
    }

    protected void consumeExtraParameterWithFormal() {
        Argument arg = (Argument)this.astStack[this.astPtr--];
        --this.astLengthPtr;
        declarationFactory.setExtraArgument((MethodDeclaration)this.astStack[this.astPtr], arg);
        this.consumeExtraParameterNoFormal();
    }

    protected void consumeExtraParameterNoFormal() {
        long pos = this.identifierPositionStack[this.identifierPtr];
        int end = (int)pos;
        int start = (int)(pos >>> 32);
        char[] name = this.identifierStack[this.identifierPtr--];
        --this.identifierLengthPtr;
        MethodDeclaration adviceDecl = (MethodDeclaration)this.astStack[this.astPtr];
        declarationFactory.isAfterAdvice(adviceDecl);
        if (CharOperation.equals(name, "throwing".toCharArray())) {
            declarationFactory.setAfterThrowingAdviceKind(adviceDecl);
        } else if (CharOperation.equals(name, "returning".toCharArray())) {
            declarationFactory.setAfterReturningAdviceKind(adviceDecl);
        } else {
            this.problemReporter().parseError(start, end, this.currentToken, name, String.valueOf(name), new String[]{"throwing", "returning", ":"});
        }
    }

    protected void consumeClassBodyDeclarationInAspect() {
    }

    protected void consumeDeclareDeclaration() {
        this.concatNodeLists();
        ASTNode tokens = this.popPseudoTokens(";");
        MethodDeclaration declareDecl = declarationFactory.createDeclareDeclaration(this.compilationUnit.compilationResult, tokens, this);
        this.display();
        this.pushOnAstStack(declareDecl);
    }

    protected void consumeDeclareAnnotation(char kind) {
        this.concatNodeLists();
        ASTNode tokens = this.popPseudoTokens(";");
        Annotation[] annotations = new Annotation[1];
        int length = this.expressionLengthStack[this.expressionLengthPtr--];
        if (length != 0) {
            annotations = new Annotation[length];
            System.arraycopy(this.expressionStack, (this.expressionPtr -= length) + 1, annotations, 0, length);
        }
        MethodDeclaration declareDecl = declarationFactory.createDeclareAnnotationDeclaration(this.compilationUnit.compilationResult, tokens, annotations[0], this, kind);
        this.pushOnAstStack(declareDecl);
    }

    protected void consumeDeclareAnnotationHeader() {
        this.consumePseudoTokenIdentifier();
        this.consumePseudoTokenIdentifier();
        this.swapAstStack();
        this.consumePseudoTokens();
        this.consumePseudoToken("@", 0, false);
        this.swapAstStack();
        this.consumePseudoTokens();
        this.consumePseudoToken(":", 0, false);
        this.consumePseudoTokens();
        this.display();
    }

    protected void consumeDeclareHeader() {
        this.consumePseudoTokenIdentifier();
        this.consumePseudoTokenIdentifier();
        this.swapAstStack();
        this.consumePseudoTokens();
        this.consumePseudoToken(":", 0, false);
        this.consumePseudoTokens();
        this.display();
    }

    protected void consumeInterTypeFieldHeader(boolean hasTypeParameters) {
        this.display();
        long pos = this.identifierPositionStack[this.identifierPtr];
        int end = (int)pos;
        int start = (int)(pos >>> 32);
        char[] identifierName = this.identifierStack[this.identifierPtr--];
        --this.identifierLengthPtr;
        if (hasTypeParameters) {
            this.pushOnGenericsIdentifiersLengthStack(this.identifierLengthStack[this.identifierLengthPtr]);
        } else {
            this.consumeClassOrInterfaceName();
        }
        TypeReference onType = this.getTypeReference(0);
        TypeReference returnType = this.getTypeReference(this.intStack[this.intPtr--]);
        this.display();
        int decSourceStart = this.intStack[this.intPtr--];
        int fieldModifiers = this.intStack[this.intPtr--];
        MethodDeclaration dec = declarationFactory.createInterTypeFieldDeclaration(this.compilationUnit.compilationResult, onType);
        dec.returnType = returnType;
        dec.sourceStart = start;
        dec.sourceEnd = end;
        declarationFactory.setSelector(dec, identifierName);
        dec.declarationSourceStart = decSourceStart;
        declarationFactory.setDeclaredModifiers(dec, fieldModifiers);
        dec.bodyEnd = this.endPosition;
        dec.javadoc = this.javadoc;
        this.javadoc = null;
        int length = this.expressionLengthStack[this.expressionLengthPtr--];
        if (length != 0) {
            dec.annotations = new Annotation[length];
            System.arraycopy(this.expressionStack, (this.expressionPtr -= length) + 1, dec.annotations, 0, length);
        }
        this.pushOnAstStack(dec);
        this.println("consumed field: " + dec);
        this.display();
    }

    protected void consumeExitITDVariableWithoutInitializer() {
        MethodDeclaration itdDecl = (MethodDeclaration)this.astStack[this.astPtr];
        declarationFactory.setInitialization(itdDecl, null);
    }

    protected void consumeExitITDVariableWithInitializer() {
        --this.expressionLengthPtr;
        MethodDeclaration itdDecl = (MethodDeclaration)this.astStack[this.astPtr];
        Expression initialization = this.expressionStack[this.expressionPtr--];
        declarationFactory.setInitialization(itdDecl, initialization);
        itdDecl.declarationSourceEnd = initialization.sourceEnd;
    }

    protected void consumeInterTypeFieldDeclaration() {
        MethodDeclaration dec = (MethodDeclaration)this.astStack[this.astPtr];
        dec.bodyEnd = this.endPosition;
        dec.declarationSourceEnd = this.flushCommentsDefinedPriorTo(this.endStatementPosition);
    }

    protected void consumeInterTypeMethodDeclaration(boolean isNotAbstract) {
        this.consumeMethodDeclaration(isNotAbstract, false);
    }

    protected void consumeInterTypeMethodHeader() {
        this.consumeMethodHeader();
    }

    protected void consumeInterTypeConstructorDeclaration() {
        this.consumeMethodDeclaration(true, false);
    }

    protected void consumeInterTypeConstructorHeader() {
        this.consumeMethodHeader();
    }

    protected void consumeInterTypeMethodHeaderName(boolean hasMethodTypeParameters, boolean hasGenericTypeParameters) {
        this.display();
        MethodDeclaration md = declarationFactory.createInterTypeMethodDeclaration(this.compilationUnit.compilationResult);
        char[] name = this.identifierStack[this.identifierPtr];
        long selectorSource = this.identifierPositionStack[this.identifierPtr--];
        --this.identifierLengthPtr;
        if (hasGenericTypeParameters) {
            this.pushOnGenericsIdentifiersLengthStack(this.identifierLengthStack[this.identifierLengthPtr]);
        } else {
            this.consumeClassOrInterfaceName();
        }
        TypeReference onType = this.getTypeReference(0);
        md.returnType = this.getTypeReference(this.intStack[this.intPtr--]);
        if (hasMethodTypeParameters) {
            int tp_length = this.genericsLengthStack[this.genericsLengthPtr--];
            this.genericsPtr -= tp_length;
            md.typeParameters = new TypeParameter[tp_length];
            System.arraycopy(this.genericsStack, this.genericsPtr + 1, md.typeParameters, 0, tp_length);
        }
        declarationFactory.setOnType(md, onType);
        md.declarationSourceStart = this.intStack[this.intPtr--];
        declarationFactory.setDeclaredModifiers(md, this.intStack[this.intPtr--]);
        md.sourceStart = (int)(selectorSource >>> 32);
        this.pushOnAstStack(md);
        md.sourceEnd = this.lParenPos;
        md.bodyStart = this.lParenPos + 1;
        declarationFactory.setSelector(md, name);
        this.listLength = 0;
        md.javadoc = this.javadoc;
        this.javadoc = null;
        int length = this.expressionLengthStack[this.expressionLengthPtr--];
        if (length != 0) {
            md.annotations = new Annotation[length];
            System.arraycopy(this.expressionStack, (this.expressionPtr -= length) + 1, md.annotations, 0, length);
        }
        if (this.currentElement != null) {
            if (this.currentElement instanceof RecoveredType || this.scanner.getLineNumber(md.returnType.sourceStart) == this.scanner.getLineNumber(md.sourceStart)) {
                this.lastCheckPoint = md.bodyStart;
                this.currentElement = this.currentElement.add(md, 0);
                this.lastIgnoredToken = -1;
            } else {
                this.lastCheckPoint = md.sourceStart;
                this.restartRecovery = true;
            }
        }
    }

    protected void consumeInterTypeConstructorHeaderName(boolean hasConstructorTypeParameters, boolean hasTargetTypeParameters) {
        this.display();
        MethodDeclaration md = declarationFactory.createInterTypeConstructorDeclaration(this.compilationUnit.compilationResult);
        if (!hasTargetTypeParameters) {
            this.consumeClassOrInterfaceName();
        }
        TypeReference onType = this.getTypeReference(0);
        declarationFactory.setOnType(md, onType);
        this.println("got onType: " + onType);
        this.display();
        --this.intPtr;
        md.returnType = TypeReference.baseTypeReference(6, 0, null);
        if (hasConstructorTypeParameters) {
            int tp_length = this.genericsLengthStack[this.genericsLengthPtr--];
            this.genericsPtr -= tp_length;
            md.typeParameters = new TypeParameter[tp_length];
            System.arraycopy(this.genericsStack, this.genericsPtr + 1, md.typeParameters, 0, tp_length);
        }
        md.declarationSourceStart = this.intStack[this.intPtr--];
        declarationFactory.setDeclaredModifiers(md, this.intStack[this.intPtr--]);
        int length = this.expressionLengthStack[this.expressionLengthPtr--];
        if (length != 0) {
            md.annotations = new Annotation[length];
            System.arraycopy(this.expressionStack, (this.expressionPtr -= length) + 1, md.annotations, 0, length);
        }
        md.sourceStart = onType.sourceStart;
        this.pushOnAstStack(md);
        md.sourceEnd = this.lParenPos;
        md.bodyStart = this.lParenPos + 1;
        this.listLength = 0;
        declarationFactory.setSelector(md, (String.valueOf(new String(CharOperation.concatWith(onType.getTypeName(), '_'))) + "_new").toCharArray());
        if (this.currentElement != null) {
            if (this.currentElement instanceof RecoveredType) {
                this.currentElement = this.currentElement.add(md, 0);
                this.lastIgnoredToken = -1;
            } else {
                this.lastCheckPoint = md.sourceStart;
                this.restartRecovery = true;
            }
        }
    }

    protected void consumePseudoToken(String value) {
        AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions.aspectOf().ajc$before$org_aspectj_ajdt_internal_compiler_parser_AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions$1$8c8140c9();
        this.consumePseudoToken(value, 0, false);
    }

    protected void consumePseudoToken(String value, int popFromIntStack, boolean isIdentifier) {
        AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions.aspectOf().ajc$before$org_aspectj_ajdt_internal_compiler_parser_AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions$1$8c8140c9();
        this.intPtr -= popFromIntStack;
        int start = this.currentTokenStart;
        int end = start + value.length() - 1;
        ASTNode tok = declarationFactory.createPseudoToken(this, value, isIdentifier);
        tok.sourceStart = start;
        tok.sourceEnd = end;
        this.pushOnAstStack(tok);
    }

    protected void consumePseudoTokenIdentifier() {
        AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions.aspectOf().ajc$before$org_aspectj_ajdt_internal_compiler_parser_AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions$1$8c8140c9();
        long pos = this.identifierPositionStack[this.identifierPtr];
        int end = (int)pos;
        int start = (int)(pos >>> 32);
        char[] name = this.identifierStack[this.identifierPtr--];
        --this.identifierLengthPtr;
        ASTNode tok = declarationFactory.createPseudoToken(this, new String(name), true);
        tok.sourceStart = start;
        tok.sourceEnd = end;
        this.pushOnAstStack(tok);
    }

    protected void consumePseudoTokenIf() {
        AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions.aspectOf().ajc$before$org_aspectj_ajdt_internal_compiler_parser_AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions$1$8c8140c9();
        Expression expr = this.expressionStack[this.expressionPtr--];
        --this.expressionLengthPtr;
        this.println("expr: " + expr);
        int start = this.intStack[this.intPtr--];
        ASTNode tok = declarationFactory.createIfPseudoToken(this, expr);
        tok.sourceStart = start;
        tok.sourceEnd = this.rParenPos;
        this.pushOnAstStack(tok);
    }

    protected void consumePseudoTokenLiteral() {
        AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions.aspectOf().ajc$before$org_aspectj_ajdt_internal_compiler_parser_AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions$1$8c8140c9();
        Literal literal = (Literal)this.expressionStack[this.expressionPtr--];
        --this.expressionLengthPtr;
        ASTNode tok = declarationFactory.createPseudoToken(this, new String(literal.source()), false);
        declarationFactory.setLiteralKind(tok, "string");
        tok.sourceStart = literal.sourceStart;
        tok.sourceEnd = literal.sourceEnd;
        this.pushOnAstStack(tok);
    }

    protected void consumePseudoTokenModifier() {
        AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions.aspectOf().ajc$before$org_aspectj_ajdt_internal_compiler_parser_AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions$1$8c8140c9();
        this.consumePseudoToken(Modifier.toString(this.modifiers), 0, true);
        this.modifiers = 0;
    }

    protected void consumePseudoTokenPrimitiveType() {
        AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions.aspectOf().ajc$before$org_aspectj_ajdt_internal_compiler_parser_AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions$1$8c8140c9();
        TypeReference type = this.getTypeReference(0);
        ASTNode tok = declarationFactory.createPseudoToken(this, type.toString(), true);
        tok.sourceStart = type.sourceStart;
        tok.sourceEnd = type.sourceEnd;
        this.pushOnAstStack(tok);
    }

    protected void consumePseudoTokens() {
        AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions.aspectOf().ajc$before$org_aspectj_ajdt_internal_compiler_parser_AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions$1$8c8140c9();
        this.optimizedConcatNodeLists();
    }

    @Override
    protected void consumeRule(int act) {
        switch (act) {
            case 46: {
                this.consumePrimitiveType();
                break;
            }
            case 60: {
                this.consumeReferenceType();
                break;
            }
            case 64: {
                this.consumeClassOrInterfaceName();
                break;
            }
            case 65: {
                this.consumeClassOrInterface();
                break;
            }
            case 66: {
                this.consumeGenericType();
                break;
            }
            case 67: {
                this.consumeGenericTypeWithDiamond();
                break;
            }
            case 68: {
                this.consumeArrayTypeWithTypeArgumentsName();
                break;
            }
            case 69: {
                this.consumePrimitiveArrayType();
                break;
            }
            case 70: {
                this.consumeNameArrayType();
                break;
            }
            case 71: {
                this.consumeGenericTypeNameArrayType();
                break;
            }
            case 72: {
                this.consumeGenericTypeArrayType();
                break;
            }
            case 78: {
                this.consumeZeroTypeAnnotations();
                break;
            }
            case 79: {
                this.consumeZeroTypeAnnotations();
                break;
            }
            case 88: {
                this.consumeQualifiedName();
                break;
            }
            case 91: {
                this.consumeZeroTypeAnnotations();
                break;
            }
            case 96: {
                this.consumeUnannotatableQualifiedName();
                break;
            }
            case 97: {
                this.consumeQualifiedName(false);
                break;
            }
            case 98: {
                this.consumeQualifiedName(true);
                break;
            }
            case 99: {
                this.consumeZeroTypeAnnotations();
                break;
            }
            case 103: {
                this.consumeOneMoreTypeAnnotation();
                break;
            }
            case 104: {
                this.consumeTypeAnnotation();
                break;
            }
            case 105: {
                this.consumeTypeAnnotation();
                break;
            }
            case 106: {
                this.consumeTypeAnnotation();
                break;
            }
            case 107: {
                this.consumeAnnotationName();
                break;
            }
            case 108: {
                this.consumeNormalAnnotation(true);
                break;
            }
            case 109: {
                this.consumeMarkerAnnotation(true);
                break;
            }
            case 110: {
                this.consumeSingleMemberAnnotation(true);
                break;
            }
            case 111: {
                this.consumeNonTypeUseName();
                break;
            }
            case 112: {
                this.consumeZeroTypeAnnotations();
                break;
            }
            case 113: {
                this.consumeExplicitThisParameter(false);
                break;
            }
            case 114: {
                this.consumeExplicitThisParameter(true);
                break;
            }
            case 115: {
                this.consumeVariableDeclaratorIdParameter();
                break;
            }
            case 116: {
                this.consumeCompilationUnit();
                break;
            }
            case 117: {
                this.consumeInternalCompilationUnit();
                break;
            }
            case 118: {
                this.consumeInternalCompilationUnit();
                break;
            }
            case 119: {
                this.consumeInternalCompilationUnitWithTypes();
                break;
            }
            case 120: {
                this.consumeInternalCompilationUnitWithTypes();
                break;
            }
            case 121: {
                this.consumeInternalCompilationUnit();
                break;
            }
            case 122: {
                this.consumeInternalCompilationUnitWithTypes();
                break;
            }
            case 123: {
                this.consumeInternalCompilationUnitWithTypes();
                break;
            }
            case 124: {
                this.consumeEmptyInternalCompilationUnit();
                break;
            }
            case 125: {
                this.consumeInternalCompilationUnitWithModuleDeclaration();
                break;
            }
            case 126: {
                this.consumeInternalCompilationUnitWithModuleDeclaration();
                break;
            }
            case 127: {
                this.consumeModuleDeclaration();
                break;
            }
            case 128: {
                this.consumeModuleHeader();
                break;
            }
            case 130: {
                this.consumeModuleModifiers();
                break;
            }
            case 133: {
                this.consumeEmptyModuleStatementsOpt();
                break;
            }
            case 136: {
                this.consumeModuleStatements();
                break;
            }
            case 142: {
                this.consumeRequiresStatement();
                break;
            }
            case 143: {
                this.consumeSingleRequiresModuleName();
                break;
            }
            case 144: {
                this.consumeModifiers();
                break;
            }
            case 145: {
                this.consumeDefaultModifiers();
                break;
            }
            case 147: {
                this.consumeModifiers2();
                break;
            }
            case 150: {
                this.consumeExportsStatement();
                break;
            }
            case 151: {
                this.consumeExportsHeader();
                break;
            }
            case 153: {
                this.consumeTargetModuleList();
                break;
            }
            case 154: {
                this.consumeSingleTargetModuleName();
                break;
            }
            case 156: {
                this.consumeTargetModuleNameList();
                break;
            }
            case 157: {
                this.consumeSinglePkgName();
                break;
            }
            case 158: {
                this.consumeOpensStatement();
                break;
            }
            case 159: {
                this.consumeOpensHeader();
                break;
            }
            case 160: {
                this.consumeUsesStatement();
                break;
            }
            case 161: {
                this.consumeUsesHeader();
                break;
            }
            case 162: {
                this.consumeProvidesStatement();
                break;
            }
            case 163: {
                this.consumeProvidesInterface();
                break;
            }
            case 164: {
                this.consumeSingleServiceImplName();
                break;
            }
            case 166: {
                this.consumeServiceImplNameList();
                break;
            }
            case 167: {
                this.consumeWithClause();
                break;
            }
            case 168: {
                this.consumeReduceImports();
                break;
            }
            case 169: {
                this.consumeEnterCompilationUnit();
                break;
            }
            case 192: {
                this.consumeCatchHeader();
                break;
            }
            case 194: {
                this.consumeImportDeclarations();
                break;
            }
            case 196: {
                this.consumeTypeDeclarations();
                break;
            }
            case 197: {
                this.consumePackageDeclaration();
                break;
            }
            case 198: {
                this.consumePackageDeclarationNameWithModifiers();
                break;
            }
            case 199: {
                this.consumePackageDeclarationName();
                break;
            }
            case 200: {
                this.consumePackageComment();
                break;
            }
            case 205: {
                this.consumeImportDeclaration();
                break;
            }
            case 206: {
                this.consumeSingleTypeImportDeclarationName();
                break;
            }
            case 207: {
                this.consumeImportDeclaration();
                break;
            }
            case 208: {
                this.consumeTypeImportOnDemandDeclarationName();
                break;
            }
            case 211: {
                this.consumeEmptyTypeDeclaration();
                break;
            }
            case 216: {
                this.consumeModifiers2();
                break;
            }
            case 231: {
                this.consumeAnnotationAsModifier();
                break;
            }
            case 244: {
                this.consumeAspectDeclaration();
                break;
            }
            case 245: {
                this.consumeAspectHeader();
                break;
            }
            case 248: {
                this.consumeAspectHeaderNameWithTypeParameters(false);
                break;
            }
            case 249: {
                this.consumeAspectHeaderNameWithTypeParameters(true);
                break;
            }
            case 250: {
                this.consumeAspectHeaderName(false);
                break;
            }
            case 251: {
                this.consumeAspectHeaderName(true);
                break;
            }
            case 253: {
                this.consumeAspectHeaderRest();
                break;
            }
            case 254: {
                this.consumePseudoTokenIdentifier();
                break;
            }
            case 257: {
                this.consumeClassBodyDeclarations();
                break;
            }
            case 258: {
                this.consumeEmptyClassBodyDeclarationsopt();
                break;
            }
            case 259: {
                this.consumeClassBodyDeclarationsopt();
                break;
            }
            case 260: {
                this.consumeClassBodyDeclarationInAspect();
                break;
            }
            case 264: {
                this.consumeClassBodyDeclaration();
                break;
            }
            case 275: {
                this.consumeEmptyTypeDeclaration();
                break;
            }
            case 277: {
                this.consumeMethodDeclaration(true, false);
                break;
            }
            case 278: {
                this.consumeMethodDeclaration(false, false);
                break;
            }
            case 279: {
                this.consumeMethodHeader();
                break;
            }
            case 280: {
                this.consumeMethodHeaderNameWithTypeParameters(false);
                break;
            }
            case 281: {
                this.consumeMethodHeaderName(false);
                break;
            }
            case 282: {
                this.consumeEmptyPointcutDeclaration();
                break;
            }
            case 283: {
                this.consumePointcutDeclaration();
                break;
            }
            case 284: {
                this.consumePointcutHeader();
                break;
            }
            case 287: {
                this.consumeAroundDeclaration();
                break;
            }
            case 288: {
                this.consumeAroundHeader();
                break;
            }
            case 289: {
                this.consumeAroundHeaderName();
                break;
            }
            case 290: {
                this.consumeAroundHeaderNameMissingReturnType();
                break;
            }
            case 291: {
                this.consumeBasicAdviceDeclaration();
                break;
            }
            case 294: {
                this.consumeBasicAdviceHeader();
                break;
            }
            case 295: {
                this.consumeBasicAdviceHeader();
                break;
            }
            case 296: {
                this.consumeBasicAdviceHeaderName(false);
                break;
            }
            case 297: {
                this.consumeBasicAdviceHeaderName(true);
                break;
            }
            case 298: {
                this.consumeExtraParameterWithFormal();
                break;
            }
            case 299: {
                this.consumeExtraParameterNoFormal();
                break;
            }
            case 300: {
                this.consumeExtraParameterNoFormal();
                break;
            }
            case 302: {
                this.consumeZeroTypeAnnotations();
                break;
            }
            case 303: {
                this.consumeZeroTypeAnnotations();
                this.consumeQualifiedName();
                break;
            }
            case 308: {
                this.consumeInterTypeMethodDeclaration(true);
                break;
            }
            case 309: {
                this.consumeInterTypeMethodHeader();
                break;
            }
            case 310: {
                this.consumeInterTypeMethodHeaderName(false, false);
                break;
            }
            case 311: {
                this.consumeInterTypeMethodHeaderNameIllegallyUsingTypePattern("*");
                break;
            }
            case 312: {
                this.consumeInterTypeMethodHeaderNameIllegallyUsingTypePattern("+");
                break;
            }
            case 313: {
                this.consumeInterTypeMethodHeaderName(false, true);
                break;
            }
            case 314: {
                this.consumeInterTypeMethodHeaderName(true, false);
                break;
            }
            case 315: {
                this.consumeInterTypeMethodHeaderName(true, true);
                break;
            }
            case 316: {
                this.consumeInterTypeMethodDeclaration(false);
                break;
            }
            case 317: {
                this.convertTypeParametersToSingleTypeReferences();
                break;
            }
            case 318: {
                this.consumeInterTypeConstructorDeclaration();
                break;
            }
            case 319: {
                this.consumeInterTypeConstructorHeader();
                break;
            }
            case 320: {
                this.consumeInterTypeConstructorHeaderName(false, false);
                break;
            }
            case 321: {
                this.consumeInterTypeConstructorHeaderNameIllegallyUsingTypePattern("*");
                break;
            }
            case 322: {
                this.consumeInterTypeConstructorHeaderNameIllegallyUsingTypePattern("+");
                break;
            }
            case 323: {
                this.consumeInterTypeConstructorHeaderName(true, false);
                break;
            }
            case 324: {
                this.consumeInterTypeConstructorHeaderName(false, true);
                break;
            }
            case 325: {
                this.consumeInterTypeConstructorHeaderName(true, true);
                break;
            }
            case 326: {
                this.consumeInterTypeFieldDeclaration();
                break;
            }
            case 327: {
                this.consumeInterTypeFieldHeader(false);
                break;
            }
            case 328: {
                this.consumeInterTypeFieldHeaderIllegallyAttemptingToUseATypePattern("*");
                break;
            }
            case 329: {
                this.consumeInterTypeFieldHeaderIllegallyAttemptingToUseATypePattern("+");
                break;
            }
            case 330: {
                this.consumeInterTypeFieldHeader(true);
                break;
            }
            case 331: {
                this.consumeExitITDVariableWithoutInitializer();
                break;
            }
            case 332: {
                this.consumeExitITDVariableWithInitializer();
                break;
            }
            case 334: {
                this.consumeDeclareDeclaration();
                break;
            }
            case 335: {
                this.consumeDeclareHeader();
                break;
            }
            case 336: {
                this.consumeDeclareAnnotation(' ');
                break;
            }
            case 337: {
                this.consumeDeclareAnnotation('+');
                break;
            }
            case 338: {
                this.consumeDeclareAnnotation('-');
                break;
            }
            case 341: {
                this.consumeDeclareAnnotationHeader();
                break;
            }
            case 344: {
                this.consumePseudoTokens();
                break;
            }
            case 345: {
                this.consumePseudoTokens();
                break;
            }
            case 347: {
                this.consumePseudoTokens();
                break;
            }
            case 348: {
                this.consumePseudoToken(":");
                break;
            }
            case 349: {
                this.consumePseudoTokenIdentifier();
                break;
            }
            case 350: {
                this.consumePseudoToken("(");
                break;
            }
            case 351: {
                this.consumePseudoToken(")");
                break;
            }
            case 352: {
                this.consumePseudoToken(".");
                break;
            }
            case 353: {
                this.consumePseudoToken("*");
                break;
            }
            case 354: {
                this.consumePseudoToken("+");
                break;
            }
            case 355: {
                this.consumePseudoToken("=");
                break;
            }
            case 356: {
                this.consumePseudoToken("&&");
                break;
            }
            case 357: {
                this.consumePseudoToken("||");
                break;
            }
            case 358: {
                this.consumePseudoToken("!");
                break;
            }
            case 359: {
                this.consumePseudoToken(",");
                break;
            }
            case 360: {
                this.consumePseudoToken("[");
                break;
            }
            case 361: {
                this.consumePseudoToken("]");
                break;
            }
            case 362: {
                this.consumePseudoToken("@");
                break;
            }
            case 363: {
                this.consumePseudoToken("...");
                break;
            }
            case 364: {
                this.consumePseudoToken("?");
                break;
            }
            case 365: {
                this.consumePseudoToken("<");
                break;
            }
            case 366: {
                this.consumePseudoToken(">");
                break;
            }
            case 367: {
                this.consumePseudoToken(">>");
                break;
            }
            case 368: {
                this.consumePseudoToken(">>>");
                break;
            }
            case 369: {
                this.consumePseudoToken("&");
                break;
            }
            case 370: {
                this.consumePseudoToken("!=");
                break;
            }
            case 371: {
                this.consumePseudoTokenPrimitiveType();
                break;
            }
            case 372: {
                this.consumePseudoTokenModifier();
                break;
            }
            case 373: {
                this.consumePseudoTokenLiteral();
                break;
            }
            case 374: {
                this.consumePseudoToken("this", 1, true);
                break;
            }
            case 375: {
                this.consumePseudoToken("class", 1, true);
                break;
            }
            case 376: {
                this.consumePseudoToken("super", 1, true);
                break;
            }
            case 377: {
                this.consumePseudoTokenIf();
                break;
            }
            case 378: {
                this.consumePseudoToken("assert", 1, true);
                break;
            }
            case 379: {
                this.consumePseudoToken("import", 1, true);
                break;
            }
            case 380: {
                this.consumePseudoToken("package", 1, true);
                break;
            }
            case 381: {
                this.consumePseudoToken("throw", 1, true);
                break;
            }
            case 382: {
                this.consumePseudoToken("new", 1, true);
                break;
            }
            case 383: {
                this.consumePseudoToken("do", 1, true);
                break;
            }
            case 384: {
                this.consumePseudoToken("for", 1, true);
                break;
            }
            case 385: {
                this.consumePseudoToken("switch", 1, true);
                break;
            }
            case 386: {
                this.consumePseudoToken("try", 1, true);
                break;
            }
            case 387: {
                this.consumePseudoToken("while", 1, true);
                break;
            }
            case 388: {
                this.consumePseudoToken("break", 1, true);
                break;
            }
            case 389: {
                this.consumePseudoToken("continue", 1, true);
                break;
            }
            case 390: {
                this.consumePseudoToken("return", 1, true);
                break;
            }
            case 391: {
                this.consumePseudoToken("case", 1, true);
                break;
            }
            case 392: {
                this.consumePseudoToken("catch", 0, true);
                break;
            }
            case 393: {
                this.consumePseudoToken("instanceof", 0, true);
                break;
            }
            case 394: {
                this.consumePseudoToken("else", 0, true);
                break;
            }
            case 395: {
                this.consumePseudoToken("extends", 0, true);
                break;
            }
            case 396: {
                this.consumePseudoToken("finally", 0, true);
                break;
            }
            case 397: {
                this.consumePseudoToken("implements", 0, true);
                break;
            }
            case 398: {
                this.consumePseudoToken("throws", 0, true);
                break;
            }
            case 399: {
                this.consumeClassDeclaration();
                break;
            }
            case 400: {
                this.consumeIntertypeClassDeclaration();
                break;
            }
            case 401: {
                this.consumeIntertypeClassHeader();
                break;
            }
            case 402: {
                this.consumeIntertypeTypeHeaderNameWithTypeParameters();
                break;
            }
            case 404: {
                this.consumeIntertypeClassHeaderName(false);
                break;
            }
            case 405: {
                this.consumeIntertypeClassHeaderName(true);
                break;
            }
            case 406: {
                this.consumeClassHeader();
                break;
            }
            case 407: {
                this.consumeTypeHeaderNameWithTypeParameters();
                break;
            }
            case 409: {
                this.consumeClassHeaderName1();
                break;
            }
            case 410: {
                this.consumeClassHeaderExtends();
                break;
            }
            case 411: {
                this.consumeClassHeaderImplements();
                break;
            }
            case 413: {
                this.consumeInterfaceTypeList();
                break;
            }
            case 414: {
                this.consumeInterfaceType();
                break;
            }
            case 417: {
                this.consumeClassBodyDeclarations();
                break;
            }
            case 421: {
                this.consumeClassBodyDeclaration();
                break;
            }
            case 422: {
                this.consumeDiet();
                break;
            }
            case 423: {
                this.consumeClassBodyDeclaration();
                break;
            }
            case 424: {
                this.consumeCreateInitializer();
                break;
            }
            case 432: {
                this.consumeEmptyTypeDeclaration();
                break;
            }
            case 435: {
                this.consumeFieldDeclaration();
                break;
            }
            case 437: {
                this.consumeVariableDeclarators();
                break;
            }
            case 440: {
                this.consumeEnterVariable();
                break;
            }
            case 441: {
                this.consumeExitVariableWithInitialization();
                break;
            }
            case 442: {
                this.consumeExitVariableWithoutInitialization();
                break;
            }
            case 443: {
                this.consumeForceNoDiet();
                break;
            }
            case 444: {
                this.consumeRestoreDiet();
                break;
            }
            case 449: {
                this.consumeMethodDeclaration(true, false);
                break;
            }
            case 450: {
                this.consumeMethodDeclaration(true, true);
                break;
            }
            case 451: {
                this.consumeMethodDeclaration(false, false);
                break;
            }
            case 452: {
                this.consumeMethodHeader();
                break;
            }
            case 453: {
                this.consumeMethodHeader();
                break;
            }
            case 454: {
                this.consumeMethodHeaderNameWithTypeParameters(false);
                break;
            }
            case 455: {
                this.consumeMethodHeaderName(false);
                break;
            }
            case 456: {
                this.consumeMethodHeaderNameWithTypeParameters(false);
                break;
            }
            case 457: {
                this.consumeMethodHeaderName(false);
                break;
            }
            case 458: {
                this.consumePushCombineModifiers();
                break;
            }
            case 459: {
                this.consumeMethodHeaderRightParen();
                break;
            }
            case 460: {
                this.consumeMethodHeaderExtendedDims();
                break;
            }
            case 461: {
                this.consumeMethodHeaderThrowsClause();
                break;
            }
            case 462: {
                this.consumeConstructorHeader();
                break;
            }
            case 463: {
                this.consumeConstructorHeaderNameWithTypeParameters();
                break;
            }
            case 464: {
                this.consumeConstructorHeaderName();
                break;
            }
            case 465: {
                this.consumeConstructorHeaderName();
                break;
            }
            case 467: {
                this.consumeFormalParameterList();
                break;
            }
            case 468: {
                this.consumeFormalParameter(false);
                break;
            }
            case 469: {
                this.consumeFormalParameter(true);
                break;
            }
            case 470: {
                this.consumeFormalParameter(true);
                break;
            }
            case 471: {
                this.consumeCatchFormalParameter();
                break;
            }
            case 472: {
                this.consumeCatchType();
                break;
            }
            case 473: {
                this.consumeUnionTypeAsClassType();
                break;
            }
            case 474: {
                this.consumeUnionType();
                break;
            }
            case 476: {
                this.consumeClassTypeList();
                break;
            }
            case 477: {
                this.consumeClassTypeElt();
                break;
            }
            case 478: {
                this.consumeMethodBody();
                break;
            }
            case 479: {
                this.consumeNestedMethod();
                break;
            }
            case 480: {
                this.consumeStaticInitializer();
                break;
            }
            case 481: {
                this.consumeStaticOnly();
                break;
            }
            case 482: {
                this.consumeConstructorDeclaration();
                break;
            }
            case 483: {
                this.consumeInvalidConstructorDeclaration();
                break;
            }
            case 484: {
                this.consumeExplicitConstructorInvocation(0, 3);
                break;
            }
            case 485: {
                this.consumeExplicitConstructorInvocationWithTypeArguments(0, 3);
                break;
            }
            case 486: {
                this.consumeExplicitConstructorInvocation(0, 2);
                break;
            }
            case 487: {
                this.consumeExplicitConstructorInvocationWithTypeArguments(0, 2);
                break;
            }
            case 488: {
                this.consumeExplicitConstructorInvocation(1, 2);
                break;
            }
            case 489: {
                this.consumeExplicitConstructorInvocationWithTypeArguments(1, 2);
                break;
            }
            case 490: {
                this.consumeExplicitConstructorInvocation(2, 2);
                break;
            }
            case 491: {
                this.consumeExplicitConstructorInvocationWithTypeArguments(2, 2);
                break;
            }
            case 492: {
                this.consumeExplicitConstructorInvocation(1, 3);
                break;
            }
            case 493: {
                this.consumeExplicitConstructorInvocationWithTypeArguments(1, 3);
                break;
            }
            case 494: {
                this.consumeExplicitConstructorInvocation(2, 3);
                break;
            }
            case 495: {
                this.consumeExplicitConstructorInvocationWithTypeArguments(2, 3);
                break;
            }
            case 496: {
                this.consumeInterfaceDeclaration();
                break;
            }
            case 497: {
                this.consumeInterfaceHeader();
                break;
            }
            case 498: {
                this.consumeTypeHeaderNameWithTypeParameters();
                break;
            }
            case 500: {
                this.consumeInterfaceHeaderName1();
                break;
            }
            case 501: {
                this.consumeInterfaceHeaderExtends();
                break;
            }
            case 504: {
                this.consumeInterfaceMemberDeclarations();
                break;
            }
            case 505: {
                this.consumeEmptyTypeDeclaration();
                break;
            }
            case 507: {
                this.consumeInterfaceMethodDeclaration(false);
                break;
            }
            case 508: {
                this.consumeInterfaceMethodDeclaration(false);
                break;
            }
            case 509: {
                this.consumeInterfaceMethodDeclaration(true);
                break;
            }
            case 510: {
                this.consumeInvalidConstructorDeclaration(true);
                break;
            }
            case 511: {
                this.consumeInvalidConstructorDeclaration(false);
                break;
            }
            case 522: {
                this.consumeRecordDeclaration();
                break;
            }
            case 523: {
                this.consumeRecordHeaderPart();
                break;
            }
            case 524: {
                this.consumeRecordHeaderNameWithTypeParameters();
                break;
            }
            case 526: {
                this.consumeRecordHeaderName1();
                break;
            }
            case 527: {
                this.consumeRecordComponentHeaderRightParen();
                break;
            }
            case 528: {
                this.consumeRecordHeader();
                break;
            }
            case 529: {
                this.consumeRecordComponentsopt();
                break;
            }
            case 532: {
                this.consumeRecordComponents();
                break;
            }
            case 534: {
                this.consumeRecordComponent(false);
                break;
            }
            case 535: {
                this.consumeRecordComponent(true);
                break;
            }
            case 536: {
                this.consumeRecordComponent(true);
                break;
            }
            case 537: {
                this.consumeRecordBody();
                break;
            }
            case 538: {
                this.consumeEmptyRecordBodyDeclaration();
                break;
            }
            case 541: {
                this.consumeRecordBodyDeclarations();
                break;
            }
            case 542: {
                this.consumeRecordBodyDeclaration();
                break;
            }
            case 543: {
                this.consumeRecordBodyDeclaration();
                break;
            }
            case 544: {
                this.consumeCompactConstructorDeclaration();
                break;
            }
            case 545: {
                this.consumeCompactConstructorHeader();
                break;
            }
            case 546: {
                this.consumeCompactConstructorHeaderName();
                break;
            }
            case 547: {
                this.consumeCompactConstructorHeaderNameWithTypeParameters();
                break;
            }
            case 549: {
                this.consumeInstanceOfExpression();
                break;
            }
            case 552: {
                this.consumeInstanceOfRHS();
                break;
            }
            case 553: {
                this.consumeInstanceOfClassic();
                break;
            }
            case 554: {
                this.consumeInstanceofPrimaryTypePattern();
                break;
            }
            case 555: {
                this.consumeInstanceofPrimaryParenPattern();
                break;
            }
            case 559: {
                this.consumePrimaryPattern();
                break;
            }
            case 560: {
                this.consumeParenthesizedPattern();
                break;
            }
            case 561: {
                this.consumeTypePattern();
                break;
            }
            case 562: {
                this.consumeGuardedPattern();
                break;
            }
            case 564: {
                this.consumePushLeftBrace();
                break;
            }
            case 565: {
                this.consumeEmptyArrayInitializer();
                break;
            }
            case 566: {
                this.consumeArrayInitializer();
                break;
            }
            case 567: {
                this.consumeArrayInitializer();
                break;
            }
            case 569: {
                this.consumeVariableInitializers();
                break;
            }
            case 570: {
                this.consumeBlock();
                break;
            }
            case 571: {
                this.consumeOpenBlock();
                break;
            }
            case 572: {
                this.consumeBlockStatement();
                break;
            }
            case 573: {
                this.consumeBlockStatements();
                break;
            }
            case 581: {
                this.consumeInvalidInterfaceDeclaration();
                break;
            }
            case 582: {
                this.consumeInvalidAnnotationTypeDeclaration();
                break;
            }
            case 583: {
                this.consumeInvalidEnumDeclaration();
                break;
            }
            case 584: {
                this.consumeLocalVariableDeclarationStatement();
                break;
            }
            case 585: {
                this.consumeLocalVariableDeclaration();
                break;
            }
            case 586: {
                this.consumeLocalVariableDeclaration();
                break;
            }
            case 587: {
                this.consumePushModifiers();
                break;
            }
            case 588: {
                this.consumePushModifiersForHeader();
                break;
            }
            case 589: {
                this.consumePushRealModifiers();
                break;
            }
            case 617: {
                this.consumeEmptyStatement();
                break;
            }
            case 618: {
                this.consumeStatementLabel();
                break;
            }
            case 619: {
                this.consumeStatementLabel();
                break;
            }
            case 620: {
                this.consumeLabel();
                break;
            }
            case 621: {
                this.consumeExpressionStatement();
                break;
            }
            case 630: {
                this.consumeStatementIfNoElse();
                break;
            }
            case 631: {
                this.consumeStatementIfWithElse();
                break;
            }
            case 632: {
                this.consumeStatementIfWithElse();
                break;
            }
            case 633: {
                this.consumeStatementSwitch();
                break;
            }
            case 634: {
                this.consumeEmptySwitchBlock();
                break;
            }
            case 637: {
                this.consumeSwitchBlock();
                break;
            }
            case 639: {
                this.consumeSwitchBlockStatements();
                break;
            }
            case 641: {
                this.consumeSwitchBlockStatement();
                break;
            }
            case 643: {
                this.consumeSwitchLabels();
                break;
            }
            case 644: {
                this.consumeCaseLabel();
                break;
            }
            case 645: {
                this.consumeDefaultLabel();
                break;
            }
            case 648: {
                this.consumeSwitchExpression();
                break;
            }
            case 651: {
                this.consumeSwitchLabeledRule();
                break;
            }
            case 652: {
                this.consumeSwitchLabeledExpression();
                break;
            }
            case 653: {
                this.consumeSwitchLabeledBlock();
                break;
            }
            case 654: {
                this.consumeSwitchLabeledThrowStatement();
                break;
            }
            case 655: {
                this.consumeDefaultLabelExpr();
                break;
            }
            case 656: {
                this.consumeCaseLabelExpr();
                break;
            }
            case 657: {
                this.consumeSwitchLabelCaseLhs();
                break;
            }
            case 659: {
                this.consumeCaseLabelElements();
                break;
            }
            case 660: {
                this.consumeCaseLabelElement(TheOriginalJDTParserClass.CaseLabelKind.CASE_EXPRESSION);
                break;
            }
            case 661: {
                this.consumeCaseLabelElement(TheOriginalJDTParserClass.CaseLabelKind.CASE_DEFAULT);
                break;
            }
            case 662: {
                this.consumeCaseLabelElement(TheOriginalJDTParserClass.CaseLabelKind.CASE_PATTERN);
                break;
            }
            case 663: {
                this.consumeStatementYield();
                break;
            }
            case 664: {
                this.consumeStatementWhile();
                break;
            }
            case 665: {
                this.consumeStatementWhile();
                break;
            }
            case 666: {
                this.consumeStatementDo();
                break;
            }
            case 667: {
                this.consumeStatementFor();
                break;
            }
            case 668: {
                this.consumeStatementFor();
                break;
            }
            case 669: {
                this.consumeForInit();
                break;
            }
            case 673: {
                this.consumeStatementExpressionList();
                break;
            }
            case 674: {
                this.consumeSimpleAssertStatement();
                break;
            }
            case 675: {
                this.consumeAssertStatement();
                break;
            }
            case 676: {
                this.consumeStatementBreak();
                break;
            }
            case 677: {
                this.consumeStatementBreakWithLabel();
                break;
            }
            case 678: {
                this.consumeStatementContinue();
                break;
            }
            case 679: {
                this.consumeStatementContinueWithLabel();
                break;
            }
            case 680: {
                this.consumeStatementReturn();
                break;
            }
            case 681: {
                this.consumeStatementThrow();
                break;
            }
            case 682: {
                this.consumeThrowExpression();
                break;
            }
            case 683: {
                this.consumeStatementSynchronized();
                break;
            }
            case 684: {
                this.consumeOnlySynchronized();
                break;
            }
            case 685: {
                this.consumeStatementTry(false, false);
                break;
            }
            case 686: {
                this.consumeStatementTry(true, false);
                break;
            }
            case 687: {
                this.consumeStatementTry(false, true);
                break;
            }
            case 688: {
                this.consumeStatementTry(true, true);
                break;
            }
            case 689: {
                this.consumeResourceSpecification();
                break;
            }
            case 690: {
                this.consumeResourceOptionalTrailingSemiColon(false);
                break;
            }
            case 691: {
                this.consumeResourceOptionalTrailingSemiColon(true);
                break;
            }
            case 692: {
                this.consumeSingleResource();
                break;
            }
            case 693: {
                this.consumeMultipleResources();
                break;
            }
            case 694: {
                this.consumeResourceOptionalTrailingSemiColon(true);
                break;
            }
            case 695: {
                this.consumeResourceAsLocalVariableDeclaration();
                break;
            }
            case 696: {
                this.consumeResourceAsLocalVariableDeclaration();
                break;
            }
            case 697: {
                this.consumeResourceAsLocalVariable();
                break;
            }
            case 698: {
                this.consumeResourceAsFieldAccess();
                break;
            }
            case 700: {
                this.consumeExitTryBlock();
                break;
            }
            case 702: {
                this.consumeCatches();
                break;
            }
            case 703: {
                this.consumeStatementCatch();
                break;
            }
            case 705: {
                this.consumeLeftParen();
                break;
            }
            case 706: {
                this.consumeRightParen();
                break;
            }
            case 711: {
                this.consumePrimaryNoNewArrayThis();
                break;
            }
            case 712: {
                this.consumePrimaryNoNewArray();
                break;
            }
            case 713: {
                this.consumePrimaryNoNewArrayWithName();
                break;
            }
            case 716: {
                this.consumePrimaryNoNewArrayNameThis();
                break;
            }
            case 717: {
                this.consumeQualifiedSuperReceiver();
                break;
            }
            case 718: {
                this.consumePrimaryNoNewArrayName();
                break;
            }
            case 719: {
                this.consumePrimaryNoNewArrayArrayType();
                break;
            }
            case 720: {
                this.consumePrimaryNoNewArrayPrimitiveArrayType();
                break;
            }
            case 721: {
                this.consumePrimaryNoNewArrayPrimitiveType();
                break;
            }
            case 727: {
                this.consumeReferenceExpressionTypeArgumentsAndTrunk(false);
                break;
            }
            case 728: {
                this.consumeReferenceExpressionTypeArgumentsAndTrunk(true);
                break;
            }
            case 729: {
                this.consumeReferenceExpressionTypeForm(true);
                break;
            }
            case 730: {
                this.consumeReferenceExpressionTypeForm(false);
                break;
            }
            case 731: {
                this.consumeReferenceExpressionGenericTypeForm();
                break;
            }
            case 732: {
                this.consumeReferenceExpressionPrimaryForm();
                break;
            }
            case 733: {
                this.consumeReferenceExpressionPrimaryForm();
                break;
            }
            case 734: {
                this.consumeReferenceExpressionSuperForm();
                break;
            }
            case 735: {
                this.consumeEmptyTypeArguments();
                break;
            }
            case 737: {
                this.consumeIdentifierOrNew(false);
                break;
            }
            case 738: {
                this.consumeIdentifierOrNew(true);
                break;
            }
            case 739: {
                this.consumeLambdaExpression();
                break;
            }
            case 740: {
                this.consumeNestedLambda();
                break;
            }
            case 741: {
                this.consumeTypeElidedLambdaParameter(false);
                break;
            }
            case 747: {
                this.consumeFormalParameterList();
                break;
            }
            case 748: {
                this.consumeTypeElidedLambdaParameter(true);
                break;
            }
            case 751: {
                this.consumeElidedLeftBraceAndReturn();
                break;
            }
            case 752: {
                this.consumeAllocationHeader();
                break;
            }
            case 753: {
                this.consumeClassInstanceCreationExpressionWithTypeArguments();
                break;
            }
            case 754: {
                this.consumeClassInstanceCreationExpression();
                break;
            }
            case 755: {
                this.consumeClassInstanceCreationExpressionQualifiedWithTypeArguments();
                break;
            }
            case 756: {
                this.consumeClassInstanceCreationExpressionQualified();
                break;
            }
            case 757: {
                this.consumeClassInstanceCreationExpressionQualified();
                break;
            }
            case 758: {
                this.consumeClassInstanceCreationExpressionQualifiedWithTypeArguments();
                break;
            }
            case 759: {
                this.consumeEnterInstanceCreationArgumentList();
                break;
            }
            case 760: {
                this.consumeClassInstanceCreationExpressionName();
                break;
            }
            case 761: {
                this.consumeClassBodyopt();
                break;
            }
            case 763: {
                this.consumeEnterAnonymousClassBody(false);
                break;
            }
            case 764: {
                this.consumeClassBodyopt();
                break;
            }
            case 766: {
                this.consumeEnterAnonymousClassBody(true);
                break;
            }
            case 768: {
                this.consumeArgumentList();
                break;
            }
            case 769: {
                this.consumeArrayCreationHeader();
                break;
            }
            case 770: {
                this.consumeArrayCreationHeader();
                break;
            }
            case 771: {
                this.consumeArrayCreationExpressionWithoutInitializer();
                break;
            }
            case 772: {
                this.consumeArrayCreationExpressionWithInitializer();
                break;
            }
            case 773: {
                this.consumeArrayCreationExpressionWithoutInitializer();
                break;
            }
            case 774: {
                this.consumeArrayCreationExpressionWithInitializer();
                break;
            }
            case 776: {
                this.consumeDimWithOrWithOutExprs();
                break;
            }
            case 778: {
                this.consumeDimWithOrWithOutExpr();
                break;
            }
            case 779: {
                this.consumeDims();
                break;
            }
            case 782: {
                this.consumeOneDimLoop(false);
                break;
            }
            case 783: {
                this.consumeOneDimLoop(true);
                break;
            }
            case 784: {
                this.consumeFieldAccess(false);
                break;
            }
            case 785: {
                this.consumeFieldAccess(true);
                break;
            }
            case 786: {
                this.consumeFieldAccess(false);
                break;
            }
            case 787: {
                this.consumeMethodInvocationName();
                break;
            }
            case 788: {
                this.consumeMethodInvocationNameWithTypeArguments();
                break;
            }
            case 789: {
                this.consumeMethodInvocationPrimaryWithTypeArguments();
                break;
            }
            case 790: {
                this.consumeMethodInvocationPrimary();
                break;
            }
            case 791: {
                this.consumeMethodInvocationPrimary();
                break;
            }
            case 792: {
                this.consumeMethodInvocationPrimaryWithTypeArguments();
                break;
            }
            case 793: {
                this.consumeMethodInvocationSuperWithTypeArguments();
                break;
            }
            case 794: {
                this.consumeMethodInvocationSuper();
                break;
            }
            case 795: {
                this.consumeArrayAccess(true);
                break;
            }
            case 796: {
                this.consumeArrayAccess(true);
                break;
            }
            case 797: {
                this.consumeArrayAccess(false);
                break;
            }
            case 798: {
                this.consumeArrayAccess(false);
                break;
            }
            case 800: {
                this.consumePostfixExpression();
                break;
            }
            case 803: {
                this.consumeUnaryExpression(14, true);
                break;
            }
            case 804: {
                this.consumeUnaryExpression(13, true);
                break;
            }
            case 805: {
                this.consumePushPosition();
                break;
            }
            case 808: {
                this.consumeUnaryExpression(14);
                break;
            }
            case 809: {
                this.consumeUnaryExpression(13);
                break;
            }
            case 811: {
                this.consumeUnaryExpression(14, false);
                break;
            }
            case 812: {
                this.consumeUnaryExpression(13, false);
                break;
            }
            case 814: {
                this.consumeUnaryExpression(12);
                break;
            }
            case 815: {
                this.consumeUnaryExpression(11);
                break;
            }
            case 817: {
                this.consumeCastExpressionWithPrimitiveType();
                break;
            }
            case 818: {
                this.consumeCastExpressionWithGenericsArray();
                break;
            }
            case 819: {
                this.consumeCastExpressionWithQualifiedGenericsArray();
                break;
            }
            case 820: {
                this.consumeCastExpressionLL1();
                break;
            }
            case 821: {
                this.consumeCastExpressionLL1WithBounds();
                break;
            }
            case 822: {
                this.consumeCastExpressionWithNameArray();
                break;
            }
            case 823: {
                this.consumeZeroAdditionalBounds();
                break;
            }
            case 827: {
                this.consumeOnlyTypeArgumentsForCastExpression();
                break;
            }
            case 828: {
                this.consumeInsideCastExpression();
                break;
            }
            case 829: {
                this.consumeInsideCastExpressionLL1();
                break;
            }
            case 830: {
                this.consumeInsideCastExpressionLL1WithBounds();
                break;
            }
            case 831: {
                this.consumeInsideCastExpressionWithQualifiedGenerics();
                break;
            }
            case 833: {
                this.consumeBinaryExpression(15);
                break;
            }
            case 834: {
                this.consumeBinaryExpression(9);
                break;
            }
            case 835: {
                this.consumeBinaryExpression(16);
                break;
            }
            case 837: {
                this.consumeBinaryExpression(14);
                break;
            }
            case 838: {
                this.consumeBinaryExpression(13);
                break;
            }
            case 840: {
                this.consumeBinaryExpression(10);
                break;
            }
            case 841: {
                this.consumeBinaryExpression(17);
                break;
            }
            case 842: {
                this.consumeBinaryExpression(19);
                break;
            }
            case 844: {
                this.consumeBinaryExpression(4);
                break;
            }
            case 845: {
                this.consumeBinaryExpression(6);
                break;
            }
            case 846: {
                this.consumeBinaryExpression(5);
                break;
            }
            case 847: {
                this.consumeBinaryExpression(7);
                break;
            }
            case 849: {
                this.consumeEqualityExpression(18);
                break;
            }
            case 850: {
                this.consumeEqualityExpression(29);
                break;
            }
            case 852: {
                this.consumeBinaryExpression(2);
                break;
            }
            case 854: {
                this.consumeBinaryExpression(8);
                break;
            }
            case 856: {
                this.consumeBinaryExpression(3);
                break;
            }
            case 858: {
                this.consumeBinaryExpression(0);
                break;
            }
            case 860: {
                this.consumeBinaryExpression(1);
                break;
            }
            case 862: {
                this.consumeConditionalExpression(23);
                break;
            }
            case 865: {
                this.consumeAssignment();
                break;
            }
            case 867: {
                this.ignoreExpressionAssignment();
                break;
            }
            case 868: {
                this.consumeAssignmentOperator(30);
                break;
            }
            case 869: {
                this.consumeAssignmentOperator(15);
                break;
            }
            case 870: {
                this.consumeAssignmentOperator(9);
                break;
            }
            case 871: {
                this.consumeAssignmentOperator(16);
                break;
            }
            case 872: {
                this.consumeAssignmentOperator(14);
                break;
            }
            case 873: {
                this.consumeAssignmentOperator(13);
                break;
            }
            case 874: {
                this.consumeAssignmentOperator(10);
                break;
            }
            case 875: {
                this.consumeAssignmentOperator(17);
                break;
            }
            case 876: {
                this.consumeAssignmentOperator(19);
                break;
            }
            case 877: {
                this.consumeAssignmentOperator(2);
                break;
            }
            case 878: {
                this.consumeAssignmentOperator(8);
                break;
            }
            case 879: {
                this.consumeAssignmentOperator(3);
                break;
            }
            case 880: {
                this.consumeExpression();
                break;
            }
            case 883: {
                this.consumeEmptyExpression();
                break;
            }
            case 888: {
                this.consumeEmptyClassBodyDeclarationsopt();
                break;
            }
            case 889: {
                this.consumeClassBodyDeclarationsopt();
                break;
            }
            case 890: {
                this.consumeDefaultModifiers();
                break;
            }
            case 891: {
                this.consumeModifiers();
                break;
            }
            case 892: {
                this.consumeEmptyBlockStatementsopt();
                break;
            }
            case 894: {
                this.consumeEmptyDimsopt();
                break;
            }
            case 896: {
                this.consumeEmptyArgumentListopt();
                break;
            }
            case 900: {
                this.consumeFormalParameterListopt();
                break;
            }
            case 907: {
                this.consumeClassHeaderPermittedSubclasses();
                break;
            }
            case 910: {
                this.consumeInterfaceHeaderPermittedSubClassesAndSubInterfaces();
                break;
            }
            case 911: {
                this.consumeEmptyInterfaceMemberDeclarationsopt();
                break;
            }
            case 912: {
                this.consumeInterfaceMemberDeclarationsopt();
                break;
            }
            case 913: {
                this.consumeNestedType();
                break;
            }
            case 914: {
                this.consumeEmptyForInitopt();
                break;
            }
            case 916: {
                this.consumeEmptyForUpdateopt();
                break;
            }
            case 920: {
                this.consumeEmptyCatchesopt();
                break;
            }
            case 922: {
                this.consumeEnumDeclaration();
                break;
            }
            case 923: {
                this.consumeEnumHeader();
                break;
            }
            case 924: {
                this.consumeEnumHeaderName();
                break;
            }
            case 925: {
                this.consumeEnumHeaderNameWithTypeParameters();
                break;
            }
            case 926: {
                this.consumeEnumBodyNoConstants();
                break;
            }
            case 927: {
                this.consumeEnumBodyNoConstants();
                break;
            }
            case 928: {
                this.consumeEnumBodyWithConstants();
                break;
            }
            case 929: {
                this.consumeEnumBodyWithConstants();
                break;
            }
            case 931: {
                this.consumeEnumConstants();
                break;
            }
            case 932: {
                this.consumeEnumConstantHeaderName();
                break;
            }
            case 933: {
                this.consumeEnumConstantHeader();
                break;
            }
            case 934: {
                this.consumeEnumConstantWithClassBody();
                break;
            }
            case 935: {
                this.consumeEnumConstantNoClassBody();
                break;
            }
            case 936: {
                this.consumeArguments();
                break;
            }
            case 937: {
                this.consumeEmptyArguments();
                break;
            }
            case 939: {
                this.consumeEnumDeclarations();
                break;
            }
            case 940: {
                this.consumeEmptyEnumDeclarations();
                break;
            }
            case 942: {
                this.consumeEnhancedForStatement();
                break;
            }
            case 943: {
                this.consumeEnhancedForStatement();
                break;
            }
            case 944: {
                this.consumeEnhancedForStatementHeaderInit(false);
                break;
            }
            case 945: {
                this.consumeEnhancedForStatementHeaderInit(true);
                break;
            }
            case 946: {
                this.consumeEnhancedForStatementHeader();
                break;
            }
            case 947: {
                this.consumeImportDeclaration();
                break;
            }
            case 948: {
                this.consumeSingleStaticImportDeclarationName();
                break;
            }
            case 949: {
                this.consumeImportDeclaration();
                break;
            }
            case 950: {
                this.consumeStaticImportOnDemandDeclarationName();
                break;
            }
            case 951: {
                this.consumeTypeArguments();
                break;
            }
            case 952: {
                this.consumeOnlyTypeArguments();
                break;
            }
            case 954: {
                this.consumeTypeArgumentList1();
                break;
            }
            case 956: {
                this.consumeTypeArgumentList();
                break;
            }
            case 957: {
                this.consumeTypeArgument();
                break;
            }
            case 961: {
                this.consumeReferenceType1();
                break;
            }
            case 962: {
                this.consumeTypeArgumentReferenceType1();
                break;
            }
            case 964: {
                this.consumeTypeArgumentList2();
                break;
            }
            case 967: {
                this.consumeReferenceType2();
                break;
            }
            case 968: {
                this.consumeTypeArgumentReferenceType2();
                break;
            }
            case 970: {
                this.consumeTypeArgumentList3();
                break;
            }
            case 973: {
                this.consumeReferenceType3();
                break;
            }
            case 974: {
                this.consumeWildcard();
                break;
            }
            case 975: {
                this.consumeWildcardWithBounds();
                break;
            }
            case 976: {
                this.consumeWildcardBoundsExtends();
                break;
            }
            case 977: {
                this.consumeWildcardBoundsSuper();
                break;
            }
            case 978: {
                this.consumeWildcard1();
                break;
            }
            case 979: {
                this.consumeWildcard1WithBounds();
                break;
            }
            case 980: {
                this.consumeWildcardBounds1Extends();
                break;
            }
            case 981: {
                this.consumeWildcardBounds1Super();
                break;
            }
            case 982: {
                this.consumeWildcard2();
                break;
            }
            case 983: {
                this.consumeWildcard2WithBounds();
                break;
            }
            case 984: {
                this.consumeWildcardBounds2Extends();
                break;
            }
            case 985: {
                this.consumeWildcardBounds2Super();
                break;
            }
            case 986: {
                this.consumeWildcard3();
                break;
            }
            case 987: {
                this.consumeWildcard3WithBounds();
                break;
            }
            case 988: {
                this.consumeWildcardBounds3Extends();
                break;
            }
            case 989: {
                this.consumeWildcardBounds3Super();
                break;
            }
            case 990: {
                this.consumeTypeParameterHeader();
                break;
            }
            case 991: {
                this.consumeTypeParameters();
                break;
            }
            case 993: {
                this.consumeTypeParameterList();
                break;
            }
            case 995: {
                this.consumeTypeParameterWithExtends();
                break;
            }
            case 996: {
                this.consumeTypeParameterWithExtendsAndBounds();
                break;
            }
            case 998: {
                this.consumeAdditionalBoundList();
                break;
            }
            case 999: {
                this.consumeAdditionalBound();
                break;
            }
            case 1001: {
                this.consumeTypeParameterList1();
                break;
            }
            case 1002: {
                this.consumeTypeParameter1();
                break;
            }
            case 1003: {
                this.consumeTypeParameter1WithExtends();
                break;
            }
            case 1004: {
                this.consumeTypeParameter1WithExtendsAndBounds();
                break;
            }
            case 1006: {
                this.consumeAdditionalBoundList1();
                break;
            }
            case 1007: {
                this.consumeAdditionalBound1();
                break;
            }
            case 1013: {
                this.consumeUnaryExpression(14);
                break;
            }
            case 1014: {
                this.consumeUnaryExpression(13);
                break;
            }
            case 1017: {
                this.consumeUnaryExpression(12);
                break;
            }
            case 1018: {
                this.consumeUnaryExpression(11);
                break;
            }
            case 1021: {
                this.consumeBinaryExpression(15);
                break;
            }
            case 1022: {
                this.consumeBinaryExpressionWithName(15);
                break;
            }
            case 1023: {
                this.consumeBinaryExpression(9);
                break;
            }
            case 1024: {
                this.consumeBinaryExpressionWithName(9);
                break;
            }
            case 1025: {
                this.consumeBinaryExpression(16);
                break;
            }
            case 1026: {
                this.consumeBinaryExpressionWithName(16);
                break;
            }
            case 1028: {
                this.consumeBinaryExpression(14);
                break;
            }
            case 1029: {
                this.consumeBinaryExpressionWithName(14);
                break;
            }
            case 1030: {
                this.consumeBinaryExpression(13);
                break;
            }
            case 1031: {
                this.consumeBinaryExpressionWithName(13);
                break;
            }
            case 1033: {
                this.consumeBinaryExpression(10);
                break;
            }
            case 1034: {
                this.consumeBinaryExpressionWithName(10);
                break;
            }
            case 1035: {
                this.consumeBinaryExpression(17);
                break;
            }
            case 1036: {
                this.consumeBinaryExpressionWithName(17);
                break;
            }
            case 1037: {
                this.consumeBinaryExpression(19);
                break;
            }
            case 1038: {
                this.consumeBinaryExpressionWithName(19);
                break;
            }
            case 1040: {
                this.consumeBinaryExpression(4);
                break;
            }
            case 1041: {
                this.consumeBinaryExpressionWithName(4);
                break;
            }
            case 1042: {
                this.consumeBinaryExpression(6);
                break;
            }
            case 1043: {
                this.consumeBinaryExpressionWithName(6);
                break;
            }
            case 1044: {
                this.consumeBinaryExpression(5);
                break;
            }
            case 1045: {
                this.consumeBinaryExpressionWithName(5);
                break;
            }
            case 1046: {
                this.consumeBinaryExpression(7);
                break;
            }
            case 1047: {
                this.consumeBinaryExpressionWithName(7);
                break;
            }
            case 1049: {
                this.consumeInstanceOfExpressionWithName();
                break;
            }
            case 1050: {
                this.consumeInstanceOfExpression();
                break;
            }
            case 1052: {
                this.consumeEqualityExpression(18);
                break;
            }
            case 1053: {
                this.consumeEqualityExpressionWithName(18);
                break;
            }
            case 1054: {
                this.consumeEqualityExpression(29);
                break;
            }
            case 1055: {
                this.consumeEqualityExpressionWithName(29);
                break;
            }
            case 1057: {
                this.consumeBinaryExpression(2);
                break;
            }
            case 1058: {
                this.consumeBinaryExpressionWithName(2);
                break;
            }
            case 1060: {
                this.consumeBinaryExpression(8);
                break;
            }
            case 1061: {
                this.consumeBinaryExpressionWithName(8);
                break;
            }
            case 1063: {
                this.consumeBinaryExpression(3);
                break;
            }
            case 1064: {
                this.consumeBinaryExpressionWithName(3);
                break;
            }
            case 1066: {
                this.consumeBinaryExpression(0);
                break;
            }
            case 1067: {
                this.consumeBinaryExpressionWithName(0);
                break;
            }
            case 1069: {
                this.consumeBinaryExpression(1);
                break;
            }
            case 1070: {
                this.consumeBinaryExpressionWithName(1);
                break;
            }
            case 1072: {
                this.consumeConditionalExpression(23);
                break;
            }
            case 1073: {
                this.consumeConditionalExpressionWithName(23);
                break;
            }
            case 1077: {
                this.consumeAnnotationTypeDeclarationHeaderName();
                break;
            }
            case 1078: {
                this.consumeAnnotationTypeDeclarationHeaderNameWithTypeParameters();
                break;
            }
            case 1079: {
                this.consumeAnnotationTypeDeclarationHeaderNameWithTypeParameters();
                break;
            }
            case 1080: {
                this.consumeAnnotationTypeDeclarationHeaderName();
                break;
            }
            case 1081: {
                this.consumeAnnotationTypeDeclarationHeader();
                break;
            }
            case 1082: {
                this.consumeAnnotationTypeDeclaration();
                break;
            }
            case 1084: {
                this.consumeEmptyAnnotationTypeMemberDeclarationsopt();
                break;
            }
            case 1085: {
                this.consumeAnnotationTypeMemberDeclarationsopt();
                break;
            }
            case 1087: {
                this.consumeAnnotationTypeMemberDeclarations();
                break;
            }
            case 1088: {
                this.consumeMethodHeaderNameWithTypeParameters(true);
                break;
            }
            case 1089: {
                this.consumeMethodHeaderName(true);
                break;
            }
            case 1090: {
                this.consumeEmptyMethodHeaderDefaultValue();
                break;
            }
            case 1091: {
                this.consumeMethodHeaderDefaultValue();
                break;
            }
            case 1092: {
                this.consumeMethodHeader();
                break;
            }
            case 1093: {
                this.consumeAnnotationTypeMemberDeclaration();
                break;
            }
            case 1101: {
                this.consumeAnnotationName();
                break;
            }
            case 1102: {
                this.consumeNormalAnnotation(false);
                break;
            }
            case 1103: {
                this.consumeEmptyMemberValuePairsopt();
                break;
            }
            case 1106: {
                this.consumeMemberValuePairs();
                break;
            }
            case 1107: {
                this.consumeMemberValuePair();
                break;
            }
            case 1108: {
                this.consumeEnterMemberValue();
                break;
            }
            case 1109: {
                this.consumeExitMemberValue();
                break;
            }
            case 1111: {
                this.consumeMemberValueAsName();
                break;
            }
            case 1114: {
                this.consumeMemberValueArrayInitializer();
                break;
            }
            case 1115: {
                this.consumeMemberValueArrayInitializer();
                break;
            }
            case 1116: {
                this.consumeEmptyMemberValueArrayInitializer();
                break;
            }
            case 1117: {
                this.consumeEmptyMemberValueArrayInitializer();
                break;
            }
            case 1118: {
                this.consumeEnterMemberValueArrayInitializer();
                break;
            }
            case 1120: {
                this.consumeMemberValues();
                break;
            }
            case 1121: {
                this.consumeMarkerAnnotation(false);
                break;
            }
            case 1122: {
                this.consumeSingleMemberAnnotationMemberValue();
                break;
            }
            case 1123: {
                this.consumeSingleMemberAnnotation(false);
                break;
            }
            case 1124: {
                this.consumeRecoveryMethodHeaderNameWithTypeParameters();
                break;
            }
            case 1125: {
                this.consumeRecoveryMethodHeaderName();
                break;
            }
            case 1126: {
                this.consumeRecoveryMethodHeaderNameWithTypeParameters();
                break;
            }
            case 1127: {
                this.consumeRecoveryMethodHeaderName();
                break;
            }
            case 1128: {
                this.consumeMethodHeader();
                break;
            }
            case 1129: {
                this.consumeMethodHeader();
            }
        }
    }

    protected void consumeQualifiedName() {
        this.consumeQualifiedName(false);
    }

    private void consumeIntertypeClassHeader() {
        TypeDeclaration typeDecl = (TypeDeclaration)this.astStack[this.astPtr];
        if (this.currentToken == 58) {
            typeDecl.bodyStart = this.scanner.currentPosition;
        }
        if (this.currentElement != null) {
            this.restartRecovery = true;
        }
        this.scanner.commentPtr = -1;
    }

    private void consumeIntertypeClassDeclaration() {
        TypeDeclaration typeDecl;
        boolean hasConstructor;
        int length;
        if ((length = this.astLengthStack[this.astLengthPtr--]) != 0) {
            this.dispatchDeclarationInto(length);
        }
        if (!(hasConstructor = (typeDecl = (TypeDeclaration)this.astStack[this.astPtr]).checkConstructors(this))) {
            switch (TypeDeclaration.kind(typeDecl.modifiers)) {
                case 1: 
                case 3: {
                    boolean insideFieldInitializer = false;
                    if (this.diet) {
                        int i = this.nestedType;
                        while (i > 0) {
                            if (this.variablesCounter[i] > 0) {
                                insideFieldInitializer = true;
                                break;
                            }
                            --i;
                        }
                    }
                    typeDecl.createDefaultConstructor(!this.diet || insideFieldInitializer, true);
                }
            }
        }
        if (this.scanner.containsAssertKeyword) {
            typeDecl.bits |= 1;
        }
        typeDecl.addClinit();
        typeDecl.bodyEnd = this.endStatementPosition;
        if (length == 0 && !this.containsComment(typeDecl.bodyStart, typeDecl.bodyEnd)) {
            typeDecl.bits |= 8;
        }
        typeDecl.declarationSourceEnd = this.flushCommentsDefinedPriorTo(this.endStatementPosition);
    }

    private void consumeIntertypeTypeHeaderNameWithTypeParameters() {
        TypeDeclaration typeDecl = (TypeDeclaration)this.astStack[this.astPtr];
        int length = this.genericsLengthStack[this.genericsLengthPtr--];
        this.genericsPtr -= length;
        typeDecl.typeParameters = new TypeParameter[length];
        System.arraycopy(this.genericsStack, this.genericsPtr + 1, typeDecl.typeParameters, 0, length);
        typeDecl.bodyStart = typeDecl.typeParameters[length - 1].declarationSourceEnd + 1;
        this.listTypeParameterLength = 0;
        if (this.currentElement != null) {
            RecoveredType recoveredType = (RecoveredType)this.currentElement;
            recoveredType.pendingTypeParameters = null;
            this.lastCheckPoint = typeDecl.bodyStart;
        }
    }

    private void consumeIntertypeClassHeaderName(boolean b) {
        int length;
        TypeDeclaration typeDecl = declarationFactory.createIntertypeMemberClassDeclaration(this.compilationUnit.compilationResult);
        if (this.nestedMethod[this.nestedType] == 0) {
            if (this.nestedType != 0) {
                typeDecl.bits |= 0x400;
            }
        } else {
            typeDecl.bits |= 0x100;
            this.markEnclosingMemberWithLocalType();
            this.blockReal();
        }
        this.display();
        long pos = this.identifierPositionStack[this.identifierPtr];
        typeDecl.sourceEnd = (int)pos;
        typeDecl.sourceStart = (int)(pos >>> 32);
        typeDecl.name = this.identifierStack[this.identifierPtr--];
        --this.identifierLengthPtr;
        if (b) {
            this.pushOnGenericsIdentifiersLengthStack(this.identifierLengthStack[this.identifierLengthPtr]);
        } else {
            this.consumeClassOrInterfaceName();
        }
        TypeReference onType = this.getTypeReference(0);
        declarationFactory.setOnType(typeDecl, onType);
        typeDecl.declarationSourceStart = this.intStack[this.intPtr--];
        --this.intPtr;
        typeDecl.modifiersSourceStart = this.intStack[this.intPtr--];
        typeDecl.modifiers = this.intStack[this.intPtr--];
        if (typeDecl.modifiersSourceStart >= 0) {
            typeDecl.declarationSourceStart = typeDecl.modifiersSourceStart;
        }
        if ((typeDecl.bits & 0x400) == 0 && (typeDecl.bits & 0x100) == 0 && this.compilationUnit != null && !CharOperation.equals(typeDecl.name, this.compilationUnit.getMainTypeName())) {
            typeDecl.bits |= 0x1000;
        }
        if ((length = this.expressionLengthStack[this.expressionLengthPtr--]) != 0) {
            typeDecl.annotations = new Annotation[length];
            System.arraycopy(this.expressionStack, (this.expressionPtr -= length) + 1, typeDecl.annotations, 0, length);
        }
        typeDecl.bodyStart = typeDecl.sourceEnd + 1;
        this.pushOnAstStack(typeDecl);
        this.listLength = 0;
        if (this.currentElement != null) {
            this.lastCheckPoint = typeDecl.bodyStart;
            this.currentElement = this.currentElement.add(typeDecl, 0);
            this.lastIgnoredToken = -1;
        }
        typeDecl.javadoc = this.javadoc;
        this.javadoc = null;
        this.display();
    }

    protected ASTNode popPointcutDesignator(String terminator) {
        ASTNode tokens = this.popPseudoTokens(terminator);
        return declarationFactory.createPointcutDesignator(this, tokens);
    }

    protected ASTNode popPseudoTokens(String terminator) {
        this.consumePseudoToken(terminator);
        this.consumePseudoTokens();
        int length = this.astLengthStack[this.astLengthPtr--];
        this.astPtr -= length;
        ASTNode[] tokens = new ASTNode[length];
        System.arraycopy(this.astStack, this.astPtr + 1, tokens, 0, length);
        this.listLength = 0;
        return declarationFactory.createPseudoTokensFrom(tokens, this.compilationUnit.compilationResult());
    }

    private void swapAstStack() {
        ASTNode next;
        ASTNode top = this.astStack[this.astPtr];
        this.astStack[this.astPtr] = next = this.astStack[this.astPtr - 1];
        this.astStack[this.astPtr - 1] = top;
    }

    private void consumeInterTypeFieldHeaderIllegallyAttemptingToUseATypePattern(String badToken) {
        this.consumeInterTypeFieldHeader(false);
        MethodDeclaration errorNode = (MethodDeclaration)this.astStack[this.astPtr];
        this.problemReporter().parseErrorDeleteToken(errorNode.sourceStart - 2, errorNode.sourceStart, 12, badToken.toCharArray(), badToken);
    }

    private void consumeInterTypeConstructorHeaderNameIllegallyUsingTypePattern(String badToken) {
        this.consumeInterTypeConstructorHeaderName(false, false);
        MethodDeclaration errorNode = (MethodDeclaration)this.astStack[this.astPtr];
        this.problemReporter().parseErrorDeleteToken(errorNode.sourceStart - 2, errorNode.sourceStart, 12, badToken.toCharArray(), badToken);
    }

    private void consumeInterTypeMethodHeaderNameIllegallyUsingTypePattern(String badToken) {
        this.consumeInterTypeMethodHeaderName(false, false);
        MethodDeclaration errorNode = (MethodDeclaration)this.astStack[this.astPtr];
        this.problemReporter().parseErrorDeleteToken(errorNode.sourceStart - 2, errorNode.sourceStart, 12, badToken.toCharArray(), badToken);
    }

    private void consumeAroundHeaderNameMissingReturnType() {
        this.problemReporter().parseErrorInsertToComplete(this.scanner.startPosition, this.scanner.currentPosition, "return type", "around advice declaration");
        this.restartRecovery = true;
    }

    private void consumeBadHeader() {
        this.problemReporter().parseErrorReplaceTokens(this.scanner.startPosition, this.scanner.currentPosition, "valid member declaration");
        this.restartRecovery = true;
    }

    @Override
    protected void consumeSimpleAssertStatement() {
        super.consumeSimpleAssertStatement();
    }

    private void convertTypeParametersToSingleTypeReferences() {
        int typeParameterIndex = 0;
        while (typeParameterIndex < this.genericsLengthStack[this.genericsLengthPtr]) {
            TypeParameter tp = (TypeParameter)this.genericsStack[this.genericsPtr - typeParameterIndex];
            SingleTypeReference str = new SingleTypeReference(tp.name, tp.declarationSourceStart);
            this.genericsStack[this.genericsPtr - typeParameterIndex] = str;
            ++typeParameterIndex;
        }
    }

    public Parser() {
    }

    public Parser(ProblemReporter problemReporter, boolean optimizeStringLiterals) {
        super(problemReporter, optimizeStringLiterals);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected boolean shouldTryToRecover() {
        ASTNode aSTNode;
        int index = 0;
        while (index < this.astStack.length && (aSTNode = this.astStack[index++]) != null) {
            void node;
            if (declarationFactory.shouldTryToRecover((ASTNode)node)) continue;
            return false;
        }
        return true;
    }

    protected void pushOnAspectIntStack(int pos) {
        int stackLength = this.aspectIntStack.length;
        if (++this.aspectIntPtr >= stackLength) {
            this.aspectIntStack = new int[stackLength + 255];
            System.arraycopy(this.aspectIntStack, 0, this.aspectIntStack, 0, stackLength);
        }
        this.aspectIntStack[this.aspectIntPtr] = pos;
    }

    public static interface IDeclarationFactory {
        public MessageSend createProceed(MessageSend var1);

        public TypeDeclaration createAspect(CompilationResult var1);

        public void setPrivileged(TypeDeclaration var1, boolean var2);

        public void setPerClauseFrom(TypeDeclaration var1, ASTNode var2, Parser var3);

        public void setDominatesPatternFrom(TypeDeclaration var1, ASTNode var2, Parser var3);

        public ASTNode createPseudoTokensFrom(ASTNode[] var1, CompilationResult var2);

        public MethodDeclaration createMethodDeclaration(CompilationResult var1);

        public ConstructorDeclaration createConstructorDeclaration(CompilationResult var1);

        public MethodDeclaration createPointcutDeclaration(CompilationResult var1);

        public MethodDeclaration createAroundAdviceDeclaration(CompilationResult var1);

        public MethodDeclaration createAfterAdviceDeclaration(CompilationResult var1);

        public MethodDeclaration createBeforeAdviceDeclaration(CompilationResult var1);

        public ASTNode createPointcutDesignator(Parser var1, ASTNode var2);

        public void setPointcutDesignatorOnAdvice(MethodDeclaration var1, ASTNode var2);

        public void setPointcutDesignatorOnPointcut(MethodDeclaration var1, ASTNode var2);

        public void setExtraArgument(MethodDeclaration var1, Argument var2);

        public boolean isAfterAdvice(MethodDeclaration var1);

        public void setAfterThrowingAdviceKind(MethodDeclaration var1);

        public void setAfterReturningAdviceKind(MethodDeclaration var1);

        public MethodDeclaration createDeclareDeclaration(CompilationResult var1, ASTNode var2, Parser var3);

        public MethodDeclaration createDeclareAnnotationDeclaration(CompilationResult var1, ASTNode var2, Annotation var3, Parser var4, char var5);

        public MethodDeclaration createInterTypeFieldDeclaration(CompilationResult var1, TypeReference var2);

        public MethodDeclaration createInterTypeMethodDeclaration(CompilationResult var1);

        public MethodDeclaration createInterTypeConstructorDeclaration(CompilationResult var1);

        public void setSelector(MethodDeclaration var1, char[] var2);

        public void setDeclaredModifiers(MethodDeclaration var1, int var2);

        public void setInitialization(MethodDeclaration var1, Expression var2);

        public void setOnType(MethodDeclaration var1, TypeReference var2);

        public ASTNode createPseudoToken(Parser var1, String var2, boolean var3);

        public ASTNode createIfPseudoToken(Parser var1, Expression var2);

        public void setLiteralKind(ASTNode var1, String var2);

        public boolean shouldTryToRecover(ASTNode var1);

        public TypeDeclaration createIntertypeMemberClassDeclaration(CompilationResult var1);

        public void setOnType(TypeDeclaration var1, TypeReference var2);
    }
}

