/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.util.Comparator;

public class ComparatorFactory {
    public static ComparatorFactory INSTANCE = new ComparatorFactory();

    public Comparator<Double> doubleComparatorWithPrecision(final double precision) {
        Comparator<Double> closeToComparator = new Comparator<Double>(){

            @Override
            public int compare(Double o1, Double o2) {
                if (Math.abs(o1 - o2) < precision) {
                    return 0;
                }
                return o1 - o2 > 0.0 ? 1 : -1;
            }

            public String toString() {
                return "double comparator at precision " + precision;
            }
        };
        return closeToComparator;
    }

    public Comparator<Float> floatComparatorWithPrecision(final float precision) {
        Comparator<Float> closeToComparator = new Comparator<Float>(){

            @Override
            public int compare(Float o1, Float o2) {
                if (Math.abs(o1.floatValue() - o2.floatValue()) < precision) {
                    return 0;
                }
                return o1.floatValue() - o2.floatValue() > 0.0f ? 1 : -1;
            }

            public String toString() {
                return "float comparator at precision " + precision;
            }
        };
        return closeToComparator;
    }
}

