/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.presentation;

import java.util.Formatter;
import org.assertj.core.presentation.DefaultToString;
import org.assertj.core.presentation.Representation;

public class UnicodeRepresentation
implements Representation {
    @Override
    public String toStringOf(Object object) {
        if (object instanceof String) {
            return this.toStringOf((String)object);
        }
        if (object instanceof Character) {
            return this.toStringOf((Character)object);
        }
        return DefaultToString.toStringOf(this, object);
    }

    private String toStringOf(Character string) {
        return this.escapeUnicode(string.toString());
    }

    private String toStringOf(String string) {
        return this.escapeUnicode(string);
    }

    private String escapeUnicode(String input) {
        StringBuilder b = new StringBuilder(input.length());
        Formatter formatter = new Formatter(b);
        for (char c : input.toCharArray()) {
            if (c < '\u0080') {
                b.append(c);
                continue;
            }
            formatter.format("\\u%04x", c);
        }
        formatter.close();
        return b.toString();
    }
}

