/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal.cglib.transform.impl;

import org.assertj.core.internal.cglib.asm.$Type;
import org.assertj.core.internal.cglib.core.CodeEmitter;
import org.assertj.core.internal.cglib.core.Constants;
import org.assertj.core.internal.cglib.core.Signature;
import org.assertj.core.internal.cglib.core.TypeUtils;
import org.assertj.core.internal.cglib.transform.ClassEmitterTransformer;

public class AccessFieldTransformer
extends ClassEmitterTransformer {
    private Callback callback;

    public AccessFieldTransformer(Callback callback) {
        this.callback = callback;
    }

    public void declare_field(int access, String name, $Type type, Object value) {
        super.declare_field(access, name, type, value);
        String property = TypeUtils.upperFirst(this.callback.getPropertyName(this.getClassType(), name));
        if (property != null) {
            String string = String.valueOf(property);
            CodeEmitter e = this.begin_method(1, new Signature(string.length() != 0 ? "get".concat(string) : new String("get"), type, Constants.TYPES_EMPTY), null);
            e.load_this();
            e.getfield(name);
            e.return_value();
            e.end_method();
            String string2 = String.valueOf(property);
            e = this.begin_method(1, new Signature(string2.length() != 0 ? "set".concat(string2) : new String("set"), $Type.VOID_TYPE, new $Type[]{type}), null);
            e.load_this();
            e.load_arg(0);
            e.putfield(name);
            e.return_value();
            e.end_method();
        }
    }

    public static interface Callback {
        public String getPropertyName($Type var1, String var2);
    }
}

