/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.junit.ant;

import java.io.File;
import java.net.URL;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Delete;
import org.apache.tools.ant.taskdefs.TempFile;
import org.apache.tools.ant.taskdefs.XSLTProcess;
import org.apache.tools.ant.taskdefs.optional.junit.AggregateTransformer;
import org.apache.tools.ant.taskdefs.optional.junit.XMLResultAggregator;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.resources.FileResource;
import org.apache.tools.ant.types.resources.URLResource;
import org.apache.tools.ant.util.FileUtils;
import org.assertj.core.util.Strings;

public class ReportTransformer
extends AggregateTransformer {
    private static final String XSL_FILE_PATH = "org/fest/swing/junit/ant/";
    private Path classpath;
    private final List<XSLTProcess.Param> params = new CopyOnWriteArrayList<XSLTProcess.Param>();
    private static final FileUtils FILE_UTILS = FileUtils.getFileUtils();
    private static int counter;

    public ReportTransformer(Task task) {
        super(task);
    }

    public XSLTProcess.Param createParam() {
        XSLTProcess.Param p = new XSLTProcess.Param();
        this.params.add(p);
        return p;
    }

    public void transform() throws BuildException {
        this.checkOptions();
        TempFile tempFileTask = this.tempFileTask();
        XSLTProcess xsltTask = this.xsltTask();
        File outputFile = this.outputFile(tempFileTask);
        xsltTask.setOut(outputFile);
        this.createNewParams(xsltTask);
        this.createOutputDirParam(xsltTask);
        long startingTime = System.currentTimeMillis();
        try {
            xsltTask.execute();
        }
        catch (Exception e) {
            throw new BuildException(Strings.concat((Object[])new Object[]{"Errors while applying transformations: ", e.getMessage()}), (Throwable)e);
        }
        long transformTime = System.currentTimeMillis() - startingTime;
        this.task.log(Strings.concat((Object[])new Object[]{"Transform time: ", String.valueOf(transformTime), " ms"}));
        this.delete(outputFile);
    }

    private XSLTProcess xsltTask() {
        XSLTProcess xsltTask = new XSLTProcess();
        xsltTask.bindToOwner(this.task);
        xsltTask.setClasspath(this.classpath);
        xsltTask.setXslResource(this.getStylesheet());
        xsltTask.setIn(((XMLResultAggregator)this.task).getDestinationFile());
        return xsltTask;
    }

    protected Resource getStylesheet() {
        String xslname = "junit-frames.xsl";
        if ("noframes".equals(this.format)) {
            xslname = "junit-noframes.xsl";
        }
        if (this.styleDir == null) {
            URLResource stylesheet = new URLResource();
            URL stylesheetURL = ((Object)((Object)this)).getClass().getClassLoader().getResource(Strings.concat((Object[])new Object[]{XSL_FILE_PATH, xslname}));
            stylesheet.setURL(stylesheetURL);
            return stylesheet;
        }
        FileResource stylesheet = new FileResource();
        File stylesheetFile = new File(this.styleDir, xslname);
        stylesheet.setFile(stylesheetFile);
        return stylesheet;
    }

    private TempFile tempFileTask() {
        TempFile tempFileTask = new TempFile();
        tempFileTask.bindToOwner(this.task);
        return tempFileTask;
    }

    private File outputFile(TempFile tempFileTask) {
        Project project = this.task.getProject();
        if (this.format.equals("frames")) {
            String tempFileProperty = Strings.concat((Object[])new Object[]{((Object)((Object)this)).getClass().getName(), String.valueOf(counter++)});
            this.setUpTempFileTask(tempFileTask, tempFileProperty);
            return new File(project.getProperty(tempFileProperty));
        }
        return new File(this.toDir, "junit-noframes.html");
    }

    private void setUpTempFileTask(TempFile tempFileTask, String tempFileProperty) {
        Project project = this.task.getProject();
        File tmp = FILE_UTILS.resolveFile(project.getBaseDir(), project.getProperty("java.io.tmpdir"));
        tempFileTask.setDestDir(tmp);
        tempFileTask.setProperty(tempFileProperty);
        tempFileTask.execute();
    }

    private void createNewParams(XSLTProcess xsltTask) {
        for (XSLTProcess.Param param : this.params) {
            XSLTProcess.Param p = xsltTask.createParam();
            p.setProject(this.task.getProject());
            p.setName(param.getName());
            p.setExpression(param.getExpression());
        }
    }

    private void createOutputDirParam(XSLTProcess xsltTask) {
        XSLTProcess.Param p = xsltTask.createParam();
        p.setProject(this.task.getProject());
        p.setName("output.dir");
        p.setExpression(this.toDir.getAbsolutePath());
    }

    private void delete(File outputFile) {
        if (!this.format.equals("frames")) {
            return;
        }
        Delete deleteTask = new Delete();
        deleteTask.bindToOwner(this.task);
        deleteTask.setFile(outputFile);
        deleteTask.execute();
    }

    public void setClasspath(Path classpath) {
        this.createClasspath().append(classpath);
    }

    public void setClasspathRef(Reference r) {
        this.createClasspath().setRefid(r);
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.task.getProject());
        }
        return this.classpath.createPath();
    }
}

