/*
 * Decompiled with CFR 0.152.
 */
package org.atteo.evo.classindex;

import com.google.common.base.Charsets;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;

public class ClassIndex {
    public static final String SUBCLASS_INDEX_PREFIX = "META-INF/services/";
    public static final String ANNOTATED_INDEX_PREFIX = "META-INF/annotations/";
    public static final String PACKAGE_INDEX_NAME = "jaxb.index";

    private ClassIndex() {
    }

    public static <T> Iterable<Class<? extends T>> getSubclasses(Class<T> superClass) {
        Iterable<Class<?>> classes = ClassIndex.readIndexFile(SUBCLASS_INDEX_PREFIX + superClass.getCanonicalName());
        ArrayList<Class<T>> subclasses = new ArrayList<Class<T>>();
        for (Class<?> klass : classes) {
            if (!superClass.isAssignableFrom(klass)) {
                throw new RuntimeException("Class '" + klass + "' is not a subclass of '" + superClass.getCanonicalName() + "'");
            }
            subclasses.add(klass);
        }
        return subclasses;
    }

    public static Iterable<Class<?>> getPackageClasses(String packageName) {
        return ClassIndex.readIndexFile(packageName.replace(".", "/") + "/" + PACKAGE_INDEX_NAME);
    }

    public static Iterable<Class<?>> getAnnotated(Class<? extends Annotation> annotation) {
        return ClassIndex.readIndexFile(ANNOTATED_INDEX_PREFIX + annotation.getCanonicalName());
    }

    private static Iterable<Class<?>> readIndexFile(String resourceFile) {
        HashSet classes = new HashSet();
        try {
            Enumeration<URL> resources = Thread.currentThread().getContextClassLoader().getResources(resourceFile);
            while (resources.hasMoreElements()) {
                URL resource = resources.nextElement();
                BufferedReader reader = new BufferedReader(new InputStreamReader(resource.openStream(), Charsets.UTF_8));
                String line = reader.readLine();
                while (line != null) {
                    Class<?> klass;
                    try {
                        klass = Thread.currentThread().getContextClassLoader().loadClass(line);
                    }
                    catch (ClassNotFoundException e) {
                        throw new RuntimeException("Evo Class Index: Class not found '" + line + "' listed in '" + resource.toExternalForm() + "'", e);
                    }
                    classes.add(klass);
                    line = reader.readLine();
                }
                reader.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Evo Class Index: Cannot read class index", e);
        }
        return classes;
    }
}

