/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.examples;

import com.google.common.util.concurrent.ListenableFuture;
import java.net.InetAddress;
import org.bitcoinj.core.AbstractBlockChain;
import org.bitcoinj.core.Block;
import org.bitcoinj.core.BlockChain;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.core.Peer;
import org.bitcoinj.core.PeerAddress;
import org.bitcoinj.core.PeerGroup;
import org.bitcoinj.core.Sha256Hash;
import org.bitcoinj.params.TestNet3Params;
import org.bitcoinj.store.BlockStore;
import org.bitcoinj.store.MemoryBlockStore;
import org.bitcoinj.utils.BriefLogFormatter;

public class FetchBlock {
    public static void main(String[] args) throws Exception {
        BriefLogFormatter.init();
        System.out.println("Connecting to node");
        TestNet3Params params = TestNet3Params.get();
        MemoryBlockStore blockStore = new MemoryBlockStore((NetworkParameters)params);
        BlockChain chain = new BlockChain((NetworkParameters)params, (BlockStore)blockStore);
        PeerGroup peerGroup = new PeerGroup((NetworkParameters)params, (AbstractBlockChain)chain);
        peerGroup.start();
        PeerAddress addr = new PeerAddress(InetAddress.getLocalHost(), params.getPort());
        peerGroup.addAddress(addr);
        peerGroup.waitForPeers(1).get();
        Peer peer = (Peer)peerGroup.getConnectedPeers().get(0);
        Sha256Hash blockHash = Sha256Hash.wrap((String)args[0]);
        ListenableFuture future = peer.getBlock(blockHash);
        System.out.println("Waiting for node to send us the requested block: " + blockHash);
        Block block = (Block)future.get();
        System.out.println(block);
        peerGroup.stopAsync();
    }
}

