/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.examples;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.EnumSet;
import org.bitcoinj.core.Coin;
import org.bitcoinj.core.ECKey;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.core.ScriptException;
import org.bitcoinj.core.Transaction;
import org.bitcoinj.core.TransactionInput;
import org.bitcoinj.core.TransactionOutput;
import org.bitcoinj.core.Utils;
import org.bitcoinj.crypto.TransactionSignature;
import org.bitcoinj.params.MainNetParams;
import org.bitcoinj.script.Script;
import org.bitcoinj.script.ScriptBuilder;
import org.bitcoinj.script.ScriptChunk;
import org.bitcoinj.script.ScriptOpCodes;
import org.bitcoinj.signers.LocalTransactionSigner;
import org.bitcoinj.signers.TransactionSigner;
import org.bitcoinj.wallet.KeyBag;
import org.bitcoinj.wallet.RedeemData;

public class GenerateLowSTests {
    public static final BigInteger HIGH_S_DIFFERENCE = new BigInteger("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEBAAEDCE6AF48A03BBFD25E8CD0364141", 16);

    public static void main(String[] argv) throws NoSuchAlgorithmException, IOException {
        MainNetParams params = new MainNetParams();
        LocalTransactionSigner signer = new LocalTransactionSigner();
        SecureRandom secureRandom = SecureRandom.getInstanceStrong();
        final ECKey key = new ECKey(secureRandom);
        KeyBag bag = new KeyBag(){

            public ECKey findKeyFromPubHash(byte[] pubkeyHash) {
                return key;
            }

            public ECKey findKeyFromPubKey(byte[] pubkey) {
                return key;
            }

            public RedeemData findRedeemDataFromScriptHash(byte[] scriptHash) {
                return null;
            }
        };
        Transaction outputTransaction = new Transaction((NetworkParameters)params);
        Transaction inputTransaction = new Transaction((NetworkParameters)params);
        TransactionOutput output = new TransactionOutput((NetworkParameters)params, inputTransaction, Coin.ZERO, key.toAddress((NetworkParameters)params));
        inputTransaction.addOutput(output);
        outputTransaction.addInput(output);
        outputTransaction.addOutput(Coin.ZERO, new ECKey(secureRandom).toAddress((NetworkParameters)params));
        GenerateLowSTests.addOutputs(outputTransaction, bag);
        TransactionSigner.ProposedTransaction proposedTransaction = new TransactionSigner.ProposedTransaction(outputTransaction);
        signer.signInputs(proposedTransaction, bag);
        TransactionInput input = proposedTransaction.partialTx.getInput(0L);
        input.verify(output);
        input.getScriptSig().correctlySpends(outputTransaction, 0L, output.getScriptPubKey(), EnumSet.of(Script.VerifyFlag.DERSIG, Script.VerifyFlag.P2SH));
        Script scriptSig = input.getScriptSig();
        TransactionSignature signature = TransactionSignature.decodeFromBitcoin((byte[])((ScriptChunk)scriptSig.getChunks().get((int)0)).data, (boolean)true, (boolean)false);
        System.out.println("[\"A transaction with a low-S signature.\"],");
        System.out.println("[[[\"" + inputTransaction.getHashAsString() + "\", " + output.getIndex() + ", \"" + GenerateLowSTests.scriptToString(output.getScriptPubKey()) + "\"]],\n" + "\"" + Utils.HEX.encode(proposedTransaction.partialTx.unsafeBitcoinSerialize()) + "\", \"" + Script.VerifyFlag.P2SH.name() + "," + Script.VerifyFlag.LOW_S.name() + "\"],");
        BigInteger highS = HIGH_S_DIFFERENCE.subtract(signature.s);
        TransactionSignature highSig = new TransactionSignature(signature.r, highS);
        input.setScriptSig(new ScriptBuilder().data(highSig.encodeToBitcoin()).data(((ScriptChunk)scriptSig.getChunks().get((int)1)).data).build());
        input.getScriptSig().correctlySpends(outputTransaction, 0L, output.getScriptPubKey(), EnumSet.of(Script.VerifyFlag.P2SH));
        System.out.println("[\"A transaction with a high-S signature.\"],");
        System.out.println("[[[\"" + inputTransaction.getHashAsString() + "\", " + output.getIndex() + ", \"" + GenerateLowSTests.scriptToString(output.getScriptPubKey()) + "\"]],\n" + "\"" + Utils.HEX.encode(proposedTransaction.partialTx.unsafeBitcoinSerialize()) + "\", \"" + Script.VerifyFlag.P2SH.name() + "\"],");
        System.out.println("[\"A transaction with a high-S signature.\"],");
        System.out.println("[[[\"" + inputTransaction.getHashAsString() + "\", " + output.getIndex() + ", \"" + GenerateLowSTests.scriptToString(output.getScriptPubKey()) + "\"]],\n" + "\"" + Utils.HEX.encode(proposedTransaction.partialTx.unsafeBitcoinSerialize()) + "\", \"" + Script.VerifyFlag.P2SH.name() + "," + Script.VerifyFlag.LOW_S.name() + "\"],");
    }

    private static void addOutputs(Transaction outputTransaction, KeyBag bag) throws ScriptException {
        int numInputs = outputTransaction.getInputs().size();
        for (int i = 0; i < numInputs; ++i) {
            TransactionInput txIn = outputTransaction.getInput((long)i);
            Script scriptPubKey = txIn.getConnectedOutput().getScriptPubKey();
            RedeemData redeemData = txIn.getConnectedRedeemData(bag);
            Preconditions.checkNotNull((Object)redeemData, (String)"Transaction exists in wallet that we cannot redeem: %s", (Object[])new Object[]{txIn.getOutpoint().getHash()});
            txIn.setScriptSig(scriptPubKey.createEmptyInputScript((ECKey)redeemData.keys.get(0), redeemData.redeemScript));
        }
    }

    private static String scriptToString(Script scriptPubKey) {
        StringBuilder buf = new StringBuilder();
        for (ScriptChunk chunk : scriptPubKey.getChunks()) {
            if (buf.length() > 0) {
                buf.append(" ");
            }
            if (chunk.isOpCode()) {
                buf.append(ScriptOpCodes.getOpCodeName((int)chunk.opcode));
                continue;
            }
            if (chunk.data != null) {
                buf.append("0x").append(Integer.toString(chunk.opcode, 16)).append(" 0x").append(Utils.HEX.encode(chunk.data));
                continue;
            }
            buf.append(chunk.toString());
        }
        return buf.toString();
    }
}

