/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.examples;

import java.io.File;
import java.util.List;
import org.bitcoinj.core.Coin;
import org.bitcoinj.core.ECKey;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.core.Transaction;
import org.bitcoinj.core.TransactionBag;
import org.bitcoinj.core.TransactionConfidence;
import org.bitcoinj.core.listeners.TransactionConfidenceEventListener;
import org.bitcoinj.kits.WalletAppKit;
import org.bitcoinj.params.TestNet3Params;
import org.bitcoinj.script.Script;
import org.bitcoinj.wallet.Wallet;
import org.bitcoinj.wallet.listeners.KeyChainEventListener;
import org.bitcoinj.wallet.listeners.ScriptsChangeEventListener;
import org.bitcoinj.wallet.listeners.WalletCoinsReceivedEventListener;
import org.bitcoinj.wallet.listeners.WalletCoinsSentEventListener;

public class Kit {
    public static void main(String[] args) {
        TestNet3Params params = TestNet3Params.get();
        WalletAppKit kit = new WalletAppKit((NetworkParameters)params, new File("."), "walletappkit-example");
        kit.startAsync();
        kit.awaitRunning();
        kit.wallet().addCoinsReceivedEventListener(new WalletCoinsReceivedEventListener(){

            public void onCoinsReceived(Wallet wallet, Transaction tx, Coin prevBalance, Coin newBalance) {
                System.out.println("-----> coins resceived: " + tx.getHashAsString());
                System.out.println("received: " + tx.getValue((TransactionBag)wallet));
            }
        });
        kit.wallet().addCoinsSentEventListener(new WalletCoinsSentEventListener(){

            public void onCoinsSent(Wallet wallet, Transaction tx, Coin prevBalance, Coin newBalance) {
                System.out.println("coins sent");
            }
        });
        kit.wallet().addKeyChainEventListener(new KeyChainEventListener(){

            public void onKeysAdded(List<ECKey> keys) {
                System.out.println("new key added");
            }
        });
        kit.wallet().addScriptsChangeEventListener(new ScriptsChangeEventListener(){

            public void onScriptsChanged(Wallet wallet, List<Script> scripts, boolean isAddingScripts) {
                System.out.println("new script added");
            }
        });
        kit.wallet().addTransactionConfidenceEventListener(new TransactionConfidenceEventListener(){

            public void onTransactionConfidenceChanged(Wallet wallet, Transaction tx) {
                System.out.println("-----> confidence changed: " + tx.getHashAsString());
                TransactionConfidence confidence = tx.getConfidence();
                System.out.println("new block depth: " + confidence.getDepthInBlocks());
            }
        });
        System.out.println("send money to: " + kit.wallet().freshReceiveAddress().toString());
    }
}

