/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.examples;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.File;
import org.bitcoinj.core.Address;
import org.bitcoinj.core.Coin;
import org.bitcoinj.core.InsufficientMoneyException;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.core.TransactionBroadcaster;
import org.bitcoinj.kits.WalletAppKit;
import org.bitcoinj.params.TestNet3Params;
import org.bitcoinj.wallet.Wallet;

public class SendRequest {
    public static void main(String[] args) throws Exception {
        TestNet3Params params = TestNet3Params.get();
        WalletAppKit kit = new WalletAppKit((NetworkParameters)params, new File("."), "sendrequest-example");
        kit.startAsync();
        kit.awaitRunning();
        System.out.println("Send money to: " + kit.wallet().currentReceiveAddress().toString());
        Coin value = Coin.parseCoin((String)"0.09");
        Address to = Address.fromBase58((NetworkParameters)params, (String)"mupBAFeT63hXfeeT4rnAUcpKHDkz1n4fdw");
        try {
            Wallet.SendResult result = kit.wallet().sendCoins((TransactionBroadcaster)kit.peerGroup(), to, value);
            System.out.println("coins sent. transaction hash: " + result.tx.getHashAsString());
        }
        catch (InsufficientMoneyException e) {
            System.out.println("Not enough coins in your wallet. Missing " + e.missing.getValue() + " satoshis are missing (including fees)");
            System.out.println("Send money to: " + kit.wallet().currentReceiveAddress().toString());
            ListenableFuture balanceFuture = kit.wallet().getBalanceFuture(value, Wallet.BalanceType.AVAILABLE);
            FutureCallback<Coin> callback = new FutureCallback<Coin>(){

                public void onSuccess(Coin balance) {
                    System.out.println("coins arrived and the wallet now has enough balance");
                }

                public void onFailure(Throwable t) {
                    System.out.println("something went wrong");
                }
            };
            Futures.addCallback((ListenableFuture)balanceFuture, (FutureCallback)callback);
        }
    }
}

