/*
 * Decompiled with CFR 0.152.
 */
package org.butterfaces.component.renderkit.html_basic.text.part;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.component.html.HtmlInputText;
import org.butterfaces.model.tree.Node;
import org.butterfaces.util.ReflectionUtil;
import org.butterfaces.util.StringUtils;
import org.butterfaces.util.TrivialComponentsReflectionUtil;

public class TrivialComponentsEntriesNodePartRenderer {
    public int renderNodes(StringBuilder stringBuilder, List<Node> nodes, int index, List<String> mustacheKeys, Map<Integer, Node> cachedNodes) {
        int newIndex = index;
        Iterator<Node> iterator = nodes.iterator();
        while (iterator.hasNext()) {
            Node node = iterator.next();
            newIndex = this.renderNode(stringBuilder, mustacheKeys, cachedNodes, newIndex, node, true);
            if (!iterator.hasNext()) continue;
            stringBuilder.append(",");
        }
        return newIndex;
    }

    public String renderEntriesAsJSON(List<Node> nodes, List<String> mustacheKeys, Map<Integer, Node> cachedNodes) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        this.renderNodes(stringBuilder, nodes, 0, mustacheKeys, cachedNodes);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public String renderNode(List<String> mustacheKeys, Map<Integer, Node> cachedNodes, int index, Node node) {
        StringBuilder renderString = new StringBuilder();
        this.renderNode(renderString, mustacheKeys, cachedNodes, index, node, false);
        return renderString.toString();
    }

    public static String getEditingMode(HtmlInputText text) {
        if (text.isReadonly()) {
            return "readonly";
        }
        if (text.isDisabled()) {
            return "disabled";
        }
        return "editable";
    }

    private int renderNode(StringBuilder stringBuilder, List<String> mustacheKeys, Map<Integer, Node> cachedNodes, int index, Node node, boolean renderChildren) {
        int newIndex = index;
        stringBuilder.append("{");
        stringBuilder.append("\"id\": " + newIndex + ",");
        if (StringUtils.isNotEmpty(node.getStyleClass())) {
            stringBuilder.append("\"styleClass\": \"" + this.escape(this.readValue(node.getStyleClass(), "styleClass", node.getData())) + "\",");
        }
        if (StringUtils.isNotEmpty(node.getImageIcon())) {
            stringBuilder.append("\"imageStyle\": \"background-image: url(" + node.getImageIcon() + ")\",");
        } else if (StringUtils.isNotEmpty(node.getGlyphiconIcon())) {
            stringBuilder.append("\"imageClass\": \"" + node.getGlyphiconIcon() + " glyphicon-node\",");
        } else {
            stringBuilder.append("\"imageStyle\": \"display:none\",");
        }
        if (StringUtils.isNotEmpty(node.getDescription())) {
            stringBuilder.append("\"description\": \"" + this.escape(this.readValue(node.getDescription(), "description", node.getData())) + "\",");
        }
        if (node.getData() != null) {
            for (String mustacheKey : mustacheKeys) {
                stringBuilder.append("\"" + mustacheKey + "\": \"" + this.escape(new TrivialComponentsReflectionUtil().getStringValueFromObject(node.getData(), mustacheKey)) + "\",");
            }
        }
        stringBuilder.append("\"expanded\": " + Boolean.toString(!cachedNodes.get(newIndex).isCollapsed()) + ",");
        stringBuilder.append("\"butterObjectToString\": \"" + this.escape(node.getData() != null ? node.getData().toString() : "") + "\",");
        stringBuilder.append("\"title\": \"" + this.escape(this.readValue(node.getTitle(), "title", node.getData())) + "\"");
        ++newIndex;
        if (node.getSubNodes().size() > 0 && renderChildren) {
            stringBuilder.append(",\"children\": [");
            newIndex = this.renderNodes(stringBuilder, node.getSubNodes(), newIndex, mustacheKeys, cachedNodes);
            stringBuilder.append("]");
        }
        stringBuilder.append("}");
        return newIndex;
    }

    private String readValue(String value, String attributeName, Object nodeValue) {
        if (StringUtils.isNotEmpty(value)) {
            return value;
        }
        if (nodeValue == null) {
            return "";
        }
        String valueFromObject = new ReflectionUtil().getStringValueFromObject(nodeValue, attributeName);
        return StringUtils.getNotNullValue(valueFromObject, "");
    }

    private String escape(String value) {
        return StringUtils.isNotEmpty(value) ? value.replace("\"", "\\\"").replace("\n", "").replace("\r", "").replace("</", "<\\/") : "";
    }
}

