/*
 * Decompiled with CFR 0.152.
 */
package org.butterfaces.component.html.table.export.writer;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.logging.Logger;
import org.butterfaces.component.html.table.export.iterator.TableExportWriterIterator;
import org.butterfaces.component.html.table.export.writer.TableExportWriter;

public class CsvWriter
implements TableExportWriter {
    public static final String NEWLINE = "\r\n";
    public static final String SEPARATOR = ";";
    public static final byte[] UTF8_BOM = new byte[]{-17, -69, -65};
    private static final Logger LOG = Logger.getLogger(CsvWriter.class.getName());
    private final String encoding;
    private boolean quotedCsvLine;

    public CsvWriter() {
        this("UTF-8", true);
    }

    public CsvWriter(String encoding) {
        this.encoding = encoding;
        this.quotedCsvLine = true;
    }

    public CsvWriter(String encoding, boolean quotedCsvLine) {
        this.encoding = encoding;
        this.quotedCsvLine = quotedCsvLine;
    }

    @Override
    public <T> void write(OutputStream outputStream, TableExportWriterIterator<T> iterator) throws IOException {
        if (!iterator.hasNext()) {
            throw new IllegalArgumentException("CSV export list is null or empty");
        }
        long startTime = GregorianCalendar.getInstance().getTimeInMillis();
        LOG.finer("Begin CSV export");
        this.writeBOM(outputStream);
        OutputStreamWriter writer = new OutputStreamWriter(outputStream, this.encoding);
        this.writeCsvLine(writer, iterator.getHeader());
        this.writeContent(writer, iterator);
        writer.flush();
        writer.close();
        long endTime = GregorianCalendar.getInstance().getTimeInMillis();
        Date time = new Date(endTime - startTime);
        SimpleDateFormat formatter = new SimpleDateFormat("mm:ss:SSS", Locale.GERMAN);
        LOG.info(String.format("CSV export was used %s to export data", iterator.getClass()));
        LOG.info(String.format("CSV export of %s data items takes %s milliseconds.", iterator.getRowCount(), formatter.format(time)));
        LOG.finer("CSV export completed");
    }

    private void writeBOM(OutputStream outputStream) throws IOException {
        if ("UTF-8".equals(this.encoding) || "UTF8".equals(this.encoding)) {
            outputStream.write(UTF8_BOM);
        }
    }

    private <T> void writeContent(Writer writer, TableExportWriterIterator<T> data) throws IOException {
        while (data.hasNext()) {
            writer.write(NEWLINE);
            List<String> row = data.nextRow();
            this.writeCsvLine(writer, row);
        }
    }

    private void writeCsvLine(Writer writer, List<String> cellContents) throws IOException {
        for (String cellContent : cellContents) {
            if (this.quotedCsvLine) {
                writer.write(34);
            }
            writer.write(cellContent.replace("\"", "\"\""));
            if (this.quotedCsvLine) {
                writer.write(34);
            }
            writer.write(SEPARATOR);
        }
    }
}

