///<reference path="../../node_modules/@types/jquery/index.d.ts"/>
///<reference path="butterfaces-guid.ts"/>
///<reference path="butterfaces-util-object.ts"/>
var ButterFaces;
(function (ButterFaces) {
    var Overlay = /** @class */ (function () {
        function Overlay(delay, isTransparentBlockingOverlayActive, selector) {
            if (delay === void 0) { delay = 500; }
            if (isTransparentBlockingOverlayActive === void 0) { isTransparentBlockingOverlayActive = true; }
            if (selector === void 0) { selector = "body"; }
            this.isHiding = true;
            this.delay = delay;
            this.isTransparentBlockingOverlayActive = isTransparentBlockingOverlayActive;
            this.selector = selector;
            console.log("ButterFaces.Overlay.constructor - creating overlay with delay is "
                + this.delay
                + ", isTransparentBlockingOverlayActive is "
                + this.isTransparentBlockingOverlayActive
                + ", selector is "
                + this.selector);
        }
        Overlay.prototype.show = function () {
            var _this = this;
            var $elementsToDisable = $(this.selector);
            ButterFaces.Overlay.fadeOutDetachtedOverlays();
            $elementsToDisable.each(function (index, elementToDisable) {
                var $elementToDisable = $(elementToDisable);
                _this.isHiding = false;
                if (!ButterFaces.Object.isNullOrUndefined($elementToDisable.attr("data-overlay-uuid"))) {
                    if (ButterFaces.Overlay.findOverlay($elementToDisable.attr("data-overlay-uuid")).length > 0) {
                        console.log("ButterFaces.Overlay.show - overlay already existing. Skip showing overlay");
                        return;
                    }
                    else {
                        $elementToDisable.removeAttr("data-overlay-uuid");
                    }
                }
                console.log("ButterFaces.Overlay.show - appending not displayed overlay to body");
                var uuid = ButterFaces.Guid.newGuid();
                var $overlay = $("<div class='butter-component-overlay' data-overlay-uuid='" + uuid + "'><div class='" + _this.calcOverlaySpinnerClass($elementToDisable) + "'></div></div>");
                $elementToDisable.attr("data-overlay-uuid", uuid);
                if (_this.selector === "body") {
                    $overlay.addClass("overlay-body");
                }
                else {
                    // TODO if blockpage is true set it to max size
                    $overlay.offset($elementToDisable.offset())
                        .width($elementToDisable.outerWidth())
                        .height($elementToDisable.outerHeight())
                        .addClass("overlay-body-child")
                        .css({ "position": "absolute" }); // IE overrides css position so set it here
                }
                $("body").append($overlay);
                if (_this.isTransparentBlockingOverlayActive) {
                    console.log("ButterFaces.Overlay.show - isTransparentBlockingOverlayActive is true, showing transparent overlay direcly");
                    $overlay.show();
                }
                window.setTimeout(function () {
                    if (!_this.isHiding && !_this.isTransparentBlockingOverlayActive) {
                        console.log("ButterFaces.Overlay.show - deferred: isTransparentBlockingOverlayActive is false, showing transparent overlay after delay");
                        $overlay.show();
                    }
                    if (!_this.isHiding) {
                        console.log("ButterFaces.Overlay.show - deferred: starting animation to make overlay intransparent");
                        $overlay
                            .stop(true)
                            .animate({
                            opacity: 1
                        }, 300, function () {
                            console.log("ButterFaces.Overlay.show - deferred: animation ended to make overlay intransparent");
                        });
                    }
                }, _this.delay);
            });
        };
        Overlay.prototype.hide = function () {
            console.log("ButterFaces.Overlay.hide - starting animation to make overlay transparent");
            var $elementsToDisable = $(this.selector);
            this.isHiding = true;
            ButterFaces.Overlay.fadeOutDetachtedOverlays();
            $elementsToDisable.each(function (index, elementToDisable) {
                var $elementToDisable = $(elementToDisable);
                var overlayUuid = $elementToDisable.attr("data-overlay-uuid");
                if (!ButterFaces.Object.isNullOrUndefined(overlayUuid) && ButterFaces.Overlay.findOverlay(overlayUuid).length > 0) {
                    var $overlay = ButterFaces.Overlay.findOverlay($elementToDisable.attr("data-overlay-uuid"));
                    ButterFaces.Overlay.fadeOutOverlay($overlay);
                }
            });
        };
        Overlay.prototype.calcOverlaySpinnerClass = function (element) {
            if (element.outerHeight() < 55) {
                return "butter-component-spinner tiny";
            }
            if (element.outerHeight() < 105) {
                return "butter-component-spinner small";
            }
            return "butter-component-spinner";
        };
        Overlay.hideAll = function () {
            console.log("ButterFaces.Overlay.hideAll - starting animation to make all overlays transparent");
            ButterFaces.Overlay.fadeOutDetachtedOverlays();
            ButterFaces.Overlay.fadeOutAttachtedOverlays();
        };
        Overlay.fadeOutDetachtedOverlays = function () {
            // remove unbinded elements
            $(".butter-component-overlay").each(function (index, elementToCheck) {
                var $overlay = $(elementToCheck);
                var uuidToCheck = $(elementToCheck).attr("data-overlay-uuid");
                if ($("[data-overlay-uuid=" + uuidToCheck + "]").length === 1) {
                    ButterFaces.Overlay.fadeOutOverlay($overlay);
                }
            });
        };
        Overlay.fadeOutAttachtedOverlays = function () {
            // remove binded elements
            $(".butter-component-overlay").each(function (index, elementToCheck) {
                var $overlay = $(elementToCheck);
                var uuidToCheck = $(elementToCheck).attr("data-overlay-uuid");
                var elements = $("[data-overlay-uuid=" + uuidToCheck + "]");
                if (elements.length > 1) {
                    ButterFaces.Overlay.fadeOutOverlay($overlay);
                    elements.each(function (index, element) {
                        var $element = $(element);
                        $element.removeAttr("data-overlay-uuid");
                    });
                }
            });
        };
        Overlay.fadeOutOverlay = function ($overlay) {
            $overlay
                .stop(true)
                .animate({
                opacity: 0
            }, 300, function () {
                $overlay.remove();
                console.log("ButterFaces.Overlay.hide - animation ended to make overlay transparent, OVERLAY REMOVED");
            });
        };
        Overlay.findOverlay = function (uuid) {
            return $("body .butter-component-overlay[data-overlay-uuid='" + uuid + "']");
        };
        return Overlay;
    }());
    ButterFaces.Overlay = Overlay;
})(ButterFaces || (ButterFaces = {}));

//# sourceMappingURL=data:application/json;charset=utf8;base64,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
