/*
 * Decompiled with CFR 0.152.
 */
package org.butterfaces.component.renderkit.html_basic.table;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.AjaxBehavior;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.FacesRenderer;
import org.butterfaces.component.base.renderer.HtmlBasicRenderer;
import org.butterfaces.component.behavior.JsfAjaxRequest;
import org.butterfaces.component.html.table.HtmlColumn;
import org.butterfaces.component.html.table.HtmlTable;
import org.butterfaces.component.html.table.HtmlTableToolbar;
import org.butterfaces.component.partrenderer.RenderUtils;
import org.butterfaces.component.renderkit.html_basic.table.cache.TableColumnCache;
import org.butterfaces.model.table.TableColumnOrdering;
import org.butterfaces.model.table.TableColumnVisibility;
import org.butterfaces.model.table.json.JsonToModelConverter;
import org.butterfaces.resolver.ClientBehaviorResolver;
import org.butterfaces.resolver.UIComponentResolver;
import org.butterfaces.resolver.WebXmlParameters;
import org.butterfaces.util.StringUtils;

@FacesRenderer(componentFamily="org.butterfaces.component.family", rendererType="org.butterfaces.renderkit.html_basic.TableHeaderRenderer")
public class TableToolbarRenderer
extends HtmlBasicRenderer {
    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        if (!component.isRendered()) {
            return;
        }
        super.encodeBegin(context, component);
        HtmlTableToolbar tableToolbar = (HtmlTableToolbar)component;
        ResponseWriter responseWriter = context.getResponseWriter();
        HtmlTable table = this.getTableComponent(tableToolbar);
        if (table == null) {
            throw new IllegalStateException("Could not find table component with id '" + tableToolbar.getTableId() + "'.");
        }
        responseWriter.startElement("div", (UIComponent)tableToolbar);
        this.writeIdAttribute(context, responseWriter, (UIComponent)tableToolbar);
        responseWriter.writeAttribute("class", (Object)"butter-table-toolbar", null);
        responseWriter.writeAttribute("data-table-html-id", (Object)table.getClientId(), null);
    }

    @Override
    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        if (component.getChildCount() > 0) {
            ResponseWriter responseWriter = context.getResponseWriter();
            responseWriter.startElement("div", component);
            responseWriter.writeAttribute("class", (Object)"butter-table-toolbar-custom pull-left", null);
            super.encodeChildren(context, component);
            responseWriter.endElement("div");
        }
    }

    @Override
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        super.encodeEnd(context, component);
        HtmlTableToolbar tableHeader = (HtmlTableToolbar)component;
        HtmlTable table = this.getTableComponent(tableHeader);
        ResponseWriter responseWriter = context.getResponseWriter();
        WebXmlParameters webXmlParameters = new WebXmlParameters(context.getExternalContext());
        responseWriter.startElement("div", (UIComponent)tableHeader);
        responseWriter.startElement("div", (UIComponent)tableHeader);
        responseWriter.writeAttribute("class", (Object)"btn-group pull-right table-toolbar-default", null);
        this.renderFacet(context, component, "default-options-left");
        this.renderTableToolbarRefreshButton(responseWriter, tableHeader, table, webXmlParameters);
        this.renderFacet(context, component, "default-options-center");
        this.renderTableToolbarToggleColumnButton(responseWriter, tableHeader, table, webXmlParameters);
        this.renderFacet(context, component, "default-options-right");
        responseWriter.endElement("div");
        responseWriter.endElement("div");
        responseWriter.endElement("div");
        RenderUtils.renderJQueryPluginCall(component.getClientId(), "fixBootstrapDropDown()", responseWriter, component);
    }

    private void renderFacet(FacesContext context, UIComponent component, String facetName) throws IOException {
        UIComponent leftFacet = this.getFacet(component, facetName);
        if (leftFacet != null) {
            leftFacet.encodeAll(context);
        }
    }

    @Override
    public void decode(FacesContext context, UIComponent component) {
        HtmlTableToolbar tableToolbar = (HtmlTableToolbar)component;
        Map behaviors = tableToolbar.getClientBehaviors();
        if (behaviors.isEmpty()) {
            return;
        }
        ExternalContext external = context.getExternalContext();
        Map params = external.getRequestParameterMap();
        String behaviorEvent = (String)params.get("javax.faces.behavior.event");
        HtmlTable table = this.getTableComponent(tableToolbar);
        String tableUniqueIdentifier = table.getModelUniqueIdentifier();
        if (behaviorEvent != null) {
            if ("toggle".equals(behaviorEvent) && table.getTableColumnVisibilityModel() != null) {
                TableColumnVisibility visibility = new JsonToModelConverter().convertTableColumnVisibility(tableUniqueIdentifier, (String)params.get("params"));
                table.getTableColumnVisibilityModel().update(visibility);
            } else if (behaviorEvent.equals("refresh")) {
                if (tableToolbar.getTableToolbarRefreshListener() != null) {
                    tableToolbar.getTableToolbarRefreshListener().onPreRefresh();
                }
            } else if ("order".equals(behaviorEvent) && table.getTableOrderingModel() != null) {
                TableColumnOrdering ordering = new JsonToModelConverter().convertTableColumnOrdering(tableUniqueIdentifier, (String)params.get("params"));
                table.getTableOrderingModel().update(ordering);
            }
        }
    }

    public boolean getRendersChildren() {
        return true;
    }

    private void renderTableToolbarToggleColumnButton(ResponseWriter writer, HtmlTableToolbar tableToolbar, HtmlTable table, WebXmlParameters webXmlParameters) throws IOException {
        AjaxBehavior toggleAjaxBehavior = ClientBehaviorResolver.resolveActiveAjaxBehavior(tableToolbar, "toggle");
        AjaxBehavior orderAjaxBehavior = ClientBehaviorResolver.resolveActiveAjaxBehavior(tableToolbar, "order");
        if (toggleAjaxBehavior != null && table.getTableColumnVisibilityModel() != null || orderAjaxBehavior != null && table.getTableOrderingModel() != null) {
            writer.startElement("div", (UIComponent)tableToolbar);
            writer.writeAttribute("class", (Object)"btn-group", null);
            writer.startElement("a", (UIComponent)tableToolbar);
            writer.writeAttribute("class", (Object)"btn btn-outline-secondary dropdown-toggle", null);
            writer.writeAttribute("data-toggle", (Object)"dropdown", null);
            writer.writeAttribute("title", (Object)tableToolbar.getColumnOptionsTooltip(), null);
            writer.writeAttribute("role", (Object)"button", null);
            writer.startElement("i", (UIComponent)tableToolbar);
            writer.writeAttribute("class", (Object)webXmlParameters.getOptionsGlyphicon(), null);
            writer.endElement("i");
            writer.startElement("span", (UIComponent)tableToolbar);
            writer.writeAttribute("class", (Object)"caret", null);
            writer.endElement("span");
            writer.endElement("a");
            writer.startElement("ul", (UIComponent)tableToolbar);
            writer.writeAttribute("class", (Object)"dropdown-menu dropdown-menu-form butter-table-toolbar-columns", null);
            writer.writeAttribute("role", (Object)"menu", null);
            TableColumnCache tableColumnCache = table.getTableColumnCache(FacesContext.getCurrentInstance());
            int columnNumber = 0;
            for (HtmlColumn cachedColumn : tableColumnCache.getCachedColumns()) {
                List<String> rerenderIds;
                writer.startElement("li", (UIComponent)tableToolbar);
                writer.writeAttribute("class", (Object)"butter-table-toolbar-column-option", "styleClass");
                writer.writeAttribute("data-original-column", (Object)columnNumber, null);
                writer.writeAttribute("data-column-model-identifier", (Object)cachedColumn.getModelUniqueIdentifier(), null);
                if (toggleAjaxBehavior != null && table.getTableColumnVisibilityModel() != null) {
                    rerenderIds = JsfAjaxRequest.createRerenderIds(tableToolbar, "toggle");
                    rerenderIds.add(table.getClientId());
                    this.renderToggleColumnInput(writer, tableToolbar, rerenderIds, cachedColumn, table, webXmlParameters);
                }
                writer.startElement("label", (UIComponent)tableToolbar);
                writer.writeAttribute("class", (Object)"checkbox", "styleClass");
                writer.writeAttribute("title", (Object)cachedColumn.getLabel(), "title");
                writer.writeText((Object)cachedColumn.getLabel(), null);
                writer.endElement("label");
                if (orderAjaxBehavior != null && table.getTableOrderingModel() != null) {
                    rerenderIds = JsfAjaxRequest.createRerenderIds(tableToolbar, "order");
                    rerenderIds.add(table.getClientId());
                    this.renderOrderColumnSpan(writer, tableToolbar, rerenderIds, columnNumber, webXmlParameters);
                }
                writer.endElement("li");
                ++columnNumber;
            }
            writer.endElement("ul");
            writer.endElement("div");
        }
    }

    private void renderOrderColumnSpan(ResponseWriter writer, HtmlTableToolbar tableToolbar, List<String> renderIds, int columnNumber, WebXmlParameters webXmlParameters) throws IOException {
        String ajaxColumnOrderLeft = TableToolbarRenderer.createModelJavaScriptCall(tableToolbar.getClientId(), renderIds, "orderColumn", this.isAjaxDisableRenderReqionOnRequest(tableToolbar, webXmlParameters), "true, " + columnNumber);
        String ajaxColumnOrderRight = TableToolbarRenderer.createModelJavaScriptCall(tableToolbar.getClientId(), renderIds, "orderColumn", this.isAjaxDisableRenderReqionOnRequest(tableToolbar, webXmlParameters), "false, " + columnNumber);
        writer.startElement("span", (UIComponent)tableToolbar);
        writer.writeAttribute("class", (Object)("butter-table-toolbar-column-order-item butter-table-toolbar-column-order-item-up " + webXmlParameters.getOrderLeftGlyphicon()), "styleClass");
        writer.writeAttribute("onclick", (Object)ajaxColumnOrderLeft, null);
        writer.endElement("span");
        writer.startElement("span", (UIComponent)tableToolbar);
        writer.writeAttribute("class", (Object)("butter-table-toolbar-column-order-item butter-table-toolbar-column-order-item-down " + webXmlParameters.getOrderRightGlyphicon()), "styleClass");
        writer.writeAttribute("onclick", (Object)ajaxColumnOrderRight, null);
        writer.endElement("span");
    }

    private Boolean isAjaxDisableRenderReqionOnRequest(HtmlTableToolbar toolbar, WebXmlParameters parameters) {
        Boolean disableRegion = toolbar.isAjaxDisableRenderRegionsOnRequest();
        return disableRegion != null ? disableRegion.booleanValue() : parameters.isAjaxDisableRenderRegionsOnRequest();
    }

    private void renderToggleColumnInput(ResponseWriter writer, HtmlTableToolbar tableToolbar, List<String> renderIds, HtmlColumn cachedColumn, HtmlTable table, WebXmlParameters webXmlParameters) throws IOException {
        writer.startElement("input", (UIComponent)tableToolbar);
        writer.writeAttribute("type", (Object)"checkbox", null);
        String ajax = TableToolbarRenderer.createModelJavaScriptCall(tableToolbar.getClientId(), renderIds, "toggleColumnVisibilty", this.isAjaxDisableRenderReqionOnRequest(tableToolbar, webXmlParameters), null);
        writer.writeAttribute("onclick", (Object)ajax, null);
        if (!table.isHideColumn(cachedColumn)) {
            writer.writeAttribute("checked", (Object)"checked", null);
        }
        writer.endElement("input");
    }

    public static String createModelJavaScriptCall(String clientId, List<String> renderIds, String javaScriptMethodName, boolean ajaxDisableRenderRegionsOnRequest, String optionalParameter) {
        StringBuilder ajax = new StringBuilder("jQuery(document.getElementById('");
        ajax.append(clientId);
        ajax.append("'))." + javaScriptMethodName + "([");
        ajax.append(StringUtils.joinWithCommaSeparator(renderIds, true));
        if (StringUtils.isNotEmpty(optionalParameter)) {
            ajax.append("], " + ajaxDisableRenderRegionsOnRequest + ", " + optionalParameter + ");");
        } else {
            ajax.append("], " + ajaxDisableRenderRegionsOnRequest + ");");
        }
        return ajax.toString();
    }

    private void renderTableToolbarRefreshButton(ResponseWriter writer, HtmlTableToolbar tableToolbar, HtmlTable table, WebXmlParameters webXmlParameters) throws IOException {
        String eventName = "refresh";
        AjaxBehavior ajaxBehavior = ClientBehaviorResolver.findFirstActiveAjaxBehavior(tableToolbar, "refresh");
        if (ajaxBehavior != null) {
            JsfAjaxRequest jsfAjaxRequest = new JsfAjaxRequest(tableToolbar.getClientId(), true).setRender(tableToolbar, "refresh").addRender(table.getClientId()).setEvent("refresh").addOnEventHandler(ajaxBehavior.getOnevent()).addOnErrorHandler(ajaxBehavior.getOnerror()).setBehaviorEvent("refresh");
            if (this.isAjaxDisableRenderReqionOnRequest(tableToolbar, webXmlParameters).booleanValue()) {
                ArrayList<String> renderIds = new ArrayList<String>(ajaxBehavior.getRender());
                renderIds.add(table.getClientId());
                StringBuilder onEvent = new StringBuilder("ButterFaces.Ajax.disableElementsOnRequest(data, [");
                onEvent.append(StringUtils.joinWithCommaSeparator(renderIds, true));
                onEvent.append("])");
                jsfAjaxRequest.addOnEventHandler(onEvent.toString());
            }
            writer.startElement("a", (UIComponent)tableToolbar);
            writer.writeAttribute("class", (Object)"btn btn-outline-secondary", null);
            writer.writeAttribute("role", (Object)"button", null);
            writer.writeAttribute("title", (Object)tableToolbar.getRefreshTooltip(), null);
            writer.writeAttribute("onclick", (Object)jsfAjaxRequest.toString(), null);
            writer.startElement("i", (UIComponent)tableToolbar);
            writer.writeAttribute("class", (Object)webXmlParameters.getRefreshGlyphicon(), null);
            writer.endElement("i");
            writer.endElement("a");
        }
    }

    private HtmlTable getTableComponent(HtmlTableToolbar tableHeader) {
        return new UIComponentResolver().findComponent(tableHeader.getTableId(), HtmlTable.class);
    }
}

