///<reference path="../../node_modules/@types/jee-jsf/index.d.ts"/>
///<reference path="butterfaces-overlay.ts"/>
var ButterFaces;
(function (ButterFaces) {
    var Ajax = /** @class */ (function () {
        function Ajax() {
        }
        Ajax.sendRequest = function (clientId, event, renderIds, /*optional string */ params, disableRenderIds) {
            jsf.ajax.request(clientId, event, {
                "javax.faces.behavior.event": event,
                render: renderIds.join(", "),
                params: params,
                onevent: (function (data) {
                    // console.log(data);
                    if (disableRenderIds) {
                        ButterFaces.Ajax.disableElementsOnRequest(data, renderIds);
                    }
                })
            });
        };
        Ajax.disableElementsOnRequest = function (data, ids) {
            var status = data.status;
            // console.log(data);
            // console.log(ids);
            switch (status) {
                case "begin": // Before the ajax request is sent.
                    // console.log('ajax request begin');
                    for (var i = 0; i < ids.length; i++) {
                        var $elementToDisable = $(document.getElementById(ids[i]));
                        if ($elementToDisable.length !== 0) {
                            // console.log('disable ' + ids[i]);
                            new ButterFaces.Overlay(0, false, document.getElementById(ids[i])).show();
                            // console.log('disablee ' + ids[i]);
                        }
                    }
                    break;
                case "complete": // After the ajax response is arrived.
                    // console.log('ajax request complete');
                    break;
                case "success": // After update of HTML DOM based on ajax response..
                    // console.log('ajax request success');
                    for (var i = 0; i < ids.length; i++) {
                        var $elementToEmable = $(document.getElementById(ids[i]));
                        if ($elementToEmable.length !== 0) {
                            // console.log('enable ' + ids[i]);
                            new ButterFaces.Overlay(0, false, document.getElementById(ids[i])).hide();
                            // console.log('enabled ' + ids[i]);
                        }
                    }
                    break;
            }
        };
        return Ajax;
    }());
    ButterFaces.Ajax = Ajax;
})(ButterFaces || (ButterFaces = {}));

//# sourceMappingURL=data:application/json;charset=utf8;base64,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
