///<reference path="../type-definition/jsf-ajax/index.d.ts"/>
///<reference path="butterfaces-overlay.ts"/>
var ButterFaces;
(function (ButterFaces) {
    var Ajax = /** @class */ (function () {
        function Ajax() {
        }
        Ajax.sendRequest = function (clientId, event, renderIds, /*optional string */ params, disableRenderIds) {
            jsf.ajax.request(clientId, event, {
                "javax.faces.behavior.event": event,
                render: renderIds.join(", "),
                params: params,
                "butterfaces.params": params,
                onevent: (function (data) {
                    // console.log(data);
                    if (disableRenderIds) {
                        ButterFaces.Ajax.disableElementsOnRequest(data, renderIds);
                    }
                })
            });
        };
        Ajax.disableElementsOnRequest = function (data, ids) {
            var status = data.status;
            // console.log(data);
            // console.log(ids);
            switch (status) {
                case "begin": // Before the ajax request is sent.
                    // console.log('ajax request begin');
                    for (var i = 0; i < ids.length; i++) {
                        var $elementToDisable = $(document.getElementById(ids[i]));
                        if ($elementToDisable.length !== 0) {
                            // console.log('disable ' + ids[i]);
                            new ButterFaces.Overlay(0, false, document.getElementById(ids[i])).show();
                            // console.log('disablee ' + ids[i]);
                        }
                    }
                    break;
                case "complete": // After the ajax response is arrived.
                    // console.log('ajax request complete');
                    break;
                case "success": // After update of HTML DOM based on ajax response..
                    // console.log('ajax request success');
                    for (var i = 0; i < ids.length; i++) {
                        var $elementToEmable = $(document.getElementById(ids[i]));
                        if ($elementToEmable.length !== 0) {
                            // console.log('enable ' + ids[i]);
                            new ButterFaces.Overlay(0, false, document.getElementById(ids[i])).hide();
                            // console.log('enabled ' + ids[i]);
                        }
                    }
                    break;
            }
        };
        return Ajax;
    }());
    ButterFaces.Ajax = Ajax;
})(ButterFaces || (ButterFaces = {}));

//# sourceMappingURL=data:application/json;charset=utf8;base64,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
