/*
 * Decompiled with CFR 0.152.
 */
package org.cassandraunit;

import com.datastax.oss.driver.api.core.CqlSession;
import org.cassandraunit.CQLDataLoader;
import org.cassandraunit.CassandraCQLUnit;
import org.cassandraunit.dataset.CQLDataSet;
import org.cassandraunit.utils.EmbeddedCassandraServerHelper;
import org.junit.After;
import org.junit.Before;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCassandraUnit4CQLTestCase {
    private static final Logger log = LoggerFactory.getLogger(CQLDataLoader.class);
    private CassandraCQLUnit cassandraUnit;
    private boolean initialized = false;
    private CqlSession session;

    public AbstractCassandraUnit4CQLTestCase() {
        this.cassandraUnit = new CassandraCQLUnit(this.getDataSet());
    }

    public AbstractCassandraUnit4CQLTestCase(String configurationFileName) {
        this.cassandraUnit = new CassandraCQLUnit(this.getDataSet(), configurationFileName);
    }

    @Before
    public void before() throws Exception {
        if (!this.initialized) {
            this.cassandraUnit.before();
            this.session = this.cassandraUnit.session;
            this.initialized = true;
        }
    }

    @After
    public void after() {
        EmbeddedCassandraServerHelper.cleanEmbeddedCassandra();
    }

    public abstract CQLDataSet getDataSet();

    public CqlSession getSession() {
        return this.session;
    }
}

