/*
 * Decompiled with CFR 0.152.
 */
package org.catools.zapi.parser;

import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;
import org.catools.common.text.CStringUtil;
import org.catools.zapi.exception.CZApiClientException;
import org.catools.zapi.model.CZApiCycle;
import org.catools.zapi.model.CZApiProjects;
import org.catools.zapi.model.CZApiVersion;
import org.catools.zapi.parser.CZApiBaseParser;

public class CZApiCycleParser
extends CZApiBaseParser {
    public static CZApiCycle parse(CZApiProjects projects, Response response) {
        try {
            JsonPath json = response.body().jsonPath();
            CZApiCycle cycle = new CZApiCycle();
            cycle.setId(json.getLong("id"));
            cycle.setProject(projects.getById(json.getLong("projectId")));
            cycle.setVersion(new CZApiVersion(json.getLong("versionId"), json.getString("versionName")));
            cycle.setDescription(json.getString("description"));
            cycle.setStartDate(CZApiCycleParser.getDate(json, "startDate"));
            cycle.setEndDate(CZApiCycleParser.getDate(json, "endDate"));
            cycle.setEnvironment(json.getString("environment"));
            cycle.setBuild(json.getString("get"));
            cycle.setName(json.getString("name"));
            cycle.setModifiedBy(CStringUtil.removeEnd((String)json.getString("modifiedBy"), (String)"(Inactive)"));
            return cycle;
        }
        catch (Throwable t) {
            throw new CZApiClientException("Could not parse input to JSON Array. input: " + response.body().asString(), t);
        }
    }
}

