/*
 * Decompiled with CFR 0.152.
 */
package org.catools.zapi.rest;

import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.specification.RequestSpecification;
import org.catools.common.extensions.verify.CVerify;
import org.catools.zapi.configs.CZApiConfigs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CZApiRestClient {
    protected static final Logger logger = LoggerFactory.getLogger((String)CZApiRestClient.class.getName());

    protected Response get(String path) {
        return this.get(RestAssured.given().baseUri(CZApiConfigs.ZApi.getZApiUri()).basePath(path));
    }

    protected Response get(RequestSpecification request) {
        return this.verifyResponse((Response)this.decorate(request).get());
    }

    protected Response post(RequestSpecification request) {
        return this.verifyResponse((Response)this.decorate(request).post());
    }

    protected Response put(RequestSpecification request) {
        return this.verifyResponse((Response)this.decorate(request).put());
    }

    private Response verifyResponse(Response response) {
        int statusCode = response.statusCode();
        if (statusCode < 200 || statusCode > 204) {
            new CVerify((Logger)CZApiRestClient.logger).Int.betweenInclusive((Number)statusCode, (Number)200, (Number)204, "Request processed successfully.", new Object[0]);
        }
        return response;
    }

    protected RequestSpecification decorate(RequestSpecification request) {
        return request.auth().preemptive().basic(CZApiConfigs.ZApi.getUserName(), CZApiConfigs.ZApi.getPassword()).contentType(ContentType.JSON);
    }
}

