/*
 * Decompiled with CFR 0.152.
 */
package org.catools.zapi.rest.execution;

import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.specification.RequestSpecification;
import java.util.Collection;
import org.catools.common.collections.CList;
import org.catools.common.collections.CSet;
import org.catools.common.testng.model.CExecutionStatus;
import org.catools.zapi.configs.CZApiConfigs;
import org.catools.zapi.exception.CZApiException;
import org.catools.zapi.model.CZApiCycle;
import org.catools.zapi.model.CZApiExecutions;
import org.catools.zapi.rest.CZApiRestClient;
import org.codehaus.jettison.json.JSONObject;

public class CZApiExecutionClient
extends CZApiRestClient {
    public void addTestsToCycle(CSet<String> issueKeys, CZApiCycle cycle, int partitionSize) {
        this.addTestsToCycle(cycle.getProject().getId(), cycle.getVersion().getId(), cycle.getId(), issueKeys, partitionSize);
    }

    public void addTestsToCycle(Long projectId, Long versionId, Long cycleId, CSet<String> issueKeys, int partitionSize) {
        for (CList keys : issueKeys.partition(partitionSize)) {
            JSONObject entity;
            try {
                entity = new JSONObject().put("issues", (Collection)keys).put("method", (Object)"1").put("cycleId", (Object)cycleId).put("projectId", (Object)projectId).put("versionId", (Object)versionId);
            }
            catch (Throwable t) {
                throw new CZApiException("Failed to build JSONObject", t);
            }
            RequestSpecification specification = RestAssured.given().baseUri(CZApiConfigs.ZApi.getZApiUri()).basePath("/execution/addTestsToCycle").body(entity.toString());
            this.post(specification);
        }
    }

    public void updateBulkStatus(CZApiExecutions exections, CExecutionStatus status) {
        this.updateBulkStatus((CSet<Long>)exections.mapToSet(e -> e.getId()), status);
    }

    public void updateBulkStatus(CSet<Long> executionIds, CExecutionStatus status) {
        this.updateBulkStatus(executionIds, status, 50);
    }

    public void updateBulkStatus(CSet<Long> executionIds, CExecutionStatus status, int partitionSize) {
        try {
            for (CList ids : executionIds.partition(partitionSize)) {
                JSONObject entity = new JSONObject().put("executions", (Collection)ids).put("status", CZApiConfigs.ZApi.getStatusMap().get((Object)status.name()));
                RequestSpecification specification = RestAssured.given().baseUri(CZApiConfigs.ZApi.getZApiUri()).basePath("/execution/updateBulkStatus").body(entity.toString());
                Response response = this.put(specification);
                logger.debug("response code:" + response.statusCode() + ", message:" + response.body().asString());
            }
        }
        catch (Throwable t) {
            throw new CZApiException("Could not update execution statuses", t);
        }
    }
}

