/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reactor.client.v3.serviceinstances;

import org.cloudfoundry.client.v3.serviceInstances.ListServiceInstancesRequest;
import org.cloudfoundry.client.v3.serviceInstances.ListServiceInstancesResponse;
import org.cloudfoundry.client.v3.serviceInstances.ListSharedSpacesRelationshipRequest;
import org.cloudfoundry.client.v3.serviceInstances.ListSharedSpacesRelationshipResponse;
import org.cloudfoundry.client.v3.serviceInstances.ServiceInstancesV3;
import org.cloudfoundry.client.v3.serviceInstances.ShareServiceInstanceRequest;
import org.cloudfoundry.client.v3.serviceInstances.ShareServiceInstanceResponse;
import org.cloudfoundry.client.v3.serviceInstances.UnshareServiceInstanceRequest;
import org.cloudfoundry.reactor.ConnectionContext;
import org.cloudfoundry.reactor.TokenProvider;
import org.cloudfoundry.reactor.client.v3.AbstractClientV3Operations;
import reactor.core.publisher.Mono;

public final class ReactorServiceInstancesV3
extends AbstractClientV3Operations
implements ServiceInstancesV3 {
    public ReactorServiceInstancesV3(ConnectionContext connectionContext, Mono<String> root, TokenProvider tokenProvider) {
        super(connectionContext, root, tokenProvider);
    }

    public Mono<ListServiceInstancesResponse> list(ListServiceInstancesRequest request) {
        return this.get(request, ListServiceInstancesResponse.class, builder -> builder.pathSegment(new String[]{"service_instances"})).checkpoint();
    }

    public Mono<ListSharedSpacesRelationshipResponse> listSharedSpacesRelationship(ListSharedSpacesRelationshipRequest request) {
        return this.get(request, ListSharedSpacesRelationshipResponse.class, builder -> builder.pathSegment(new String[]{"service_instances", request.getServiceInstanceId(), "relationships", "shared_spaces"})).checkpoint();
    }

    public Mono<ShareServiceInstanceResponse> share(ShareServiceInstanceRequest request) {
        return this.post(request, ShareServiceInstanceResponse.class, builder -> builder.pathSegment(new String[]{"service_instances", request.getServiceInstanceId(), "relationships", "shared_spaces"})).checkpoint();
    }

    public Mono<Void> unshare(UnshareServiceInstanceRequest request) {
        return this.delete(request, Void.class, builder -> builder.pathSegment(new String[]{"service_instances", request.getServiceInstanceId(), "relationships", "shared_spaces", request.getSpaceId()})).checkpoint();
    }
}

