/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reactor.uaa.clients;

import org.cloudfoundry.reactor.ConnectionContext;
import org.cloudfoundry.reactor.TokenProvider;
import org.cloudfoundry.reactor.uaa.AbstractUaaOperations;
import org.cloudfoundry.uaa.clients.BatchChangeSecretRequest;
import org.cloudfoundry.uaa.clients.BatchChangeSecretResponse;
import org.cloudfoundry.uaa.clients.BatchCreateClientsRequest;
import org.cloudfoundry.uaa.clients.BatchCreateClientsResponse;
import org.cloudfoundry.uaa.clients.BatchDeleteClientsRequest;
import org.cloudfoundry.uaa.clients.BatchDeleteClientsResponse;
import org.cloudfoundry.uaa.clients.BatchUpdateClientsRequest;
import org.cloudfoundry.uaa.clients.BatchUpdateClientsResponse;
import org.cloudfoundry.uaa.clients.ChangeSecretRequest;
import org.cloudfoundry.uaa.clients.ChangeSecretResponse;
import org.cloudfoundry.uaa.clients.Clients;
import org.cloudfoundry.uaa.clients.CreateClientRequest;
import org.cloudfoundry.uaa.clients.CreateClientResponse;
import org.cloudfoundry.uaa.clients.DeleteClientRequest;
import org.cloudfoundry.uaa.clients.DeleteClientResponse;
import org.cloudfoundry.uaa.clients.GetClientRequest;
import org.cloudfoundry.uaa.clients.GetClientResponse;
import org.cloudfoundry.uaa.clients.GetMetadataRequest;
import org.cloudfoundry.uaa.clients.GetMetadataResponse;
import org.cloudfoundry.uaa.clients.ListClientsRequest;
import org.cloudfoundry.uaa.clients.ListClientsResponse;
import org.cloudfoundry.uaa.clients.ListMetadatasRequest;
import org.cloudfoundry.uaa.clients.ListMetadatasResponse;
import org.cloudfoundry.uaa.clients.MixedActionsRequest;
import org.cloudfoundry.uaa.clients.MixedActionsResponse;
import org.cloudfoundry.uaa.clients.UpdateClientRequest;
import org.cloudfoundry.uaa.clients.UpdateClientResponse;
import org.cloudfoundry.uaa.clients.UpdateMetadataRequest;
import org.cloudfoundry.uaa.clients.UpdateMetadataResponse;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Mono;

public final class ReactorClients
extends AbstractUaaOperations
implements Clients {
    public ReactorClients(ConnectionContext connectionContext, Mono<String> root, TokenProvider tokenProvider) {
        super(connectionContext, root, tokenProvider);
    }

    public Mono<BatchChangeSecretResponse> batchChangeSecret(BatchChangeSecretRequest request) {
        return this.post(request, BatchChangeSecretResponse.class, builder -> builder.pathSegment(new String[]{"oauth", "clients", "tx", "secret"})).checkpoint();
    }

    public Mono<BatchCreateClientsResponse> batchCreate(BatchCreateClientsRequest request) {
        return this.post(request, BatchCreateClientsResponse.class, builder -> builder.pathSegment(new String[]{"oauth", "clients", "tx"})).checkpoint();
    }

    public Mono<BatchDeleteClientsResponse> batchDelete(BatchDeleteClientsRequest request) {
        return this.post(request, BatchDeleteClientsResponse.class, builder -> builder.pathSegment(new String[]{"oauth", "clients", "tx", "delete"})).checkpoint();
    }

    public Mono<BatchUpdateClientsResponse> batchUpdate(BatchUpdateClientsRequest request) {
        return this.put(request, BatchUpdateClientsResponse.class, builder -> builder.pathSegment(new String[]{"oauth", "clients", "tx"})).checkpoint();
    }

    public Mono<ChangeSecretResponse> changeSecret(ChangeSecretRequest request) {
        return this.put(request, ChangeSecretResponse.class, builder -> builder.pathSegment(new String[]{"oauth", "clients", request.getClientId(), "secret"})).checkpoint();
    }

    public Mono<CreateClientResponse> create(CreateClientRequest request) {
        return this.post(request, CreateClientResponse.class, builder -> builder.pathSegment(new String[]{"oauth", "clients"})).checkpoint();
    }

    public Mono<DeleteClientResponse> delete(DeleteClientRequest request) {
        return this.delete(request, DeleteClientResponse.class, builder -> builder.pathSegment(new String[]{"oauth", "clients", request.getClientId()})).checkpoint();
    }

    public Mono<GetClientResponse> get(GetClientRequest request) {
        return this.get((Object)request, GetClientResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"oauth", "clients", request.getClientId()})).checkpoint();
    }

    public Mono<GetMetadataResponse> getMetadata(GetMetadataRequest request) {
        return this.get((Object)request, GetMetadataResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"oauth", "clients", request.getClientId(), "meta"})).checkpoint();
    }

    public Mono<ListClientsResponse> list(ListClientsRequest request) {
        return this.get((Object)request, ListClientsResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"oauth", "clients"})).checkpoint();
    }

    public Mono<ListMetadatasResponse> listMetadatas(ListMetadatasRequest request) {
        return this.get((Object)request, ListMetadatasResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"oauth", "clients", "meta"})).checkpoint();
    }

    public Mono<MixedActionsResponse> mixedActions(MixedActionsRequest request) {
        return this.post(request, MixedActionsResponse.class, builder -> builder.pathSegment(new String[]{"oauth", "clients", "tx", "modify"})).checkpoint();
    }

    public Mono<UpdateClientResponse> update(UpdateClientRequest request) {
        return this.put(request, UpdateClientResponse.class, builder -> builder.pathSegment(new String[]{"oauth", "clients", request.getClientId()})).checkpoint();
    }

    public Mono<UpdateMetadataResponse> updateMetadata(UpdateMetadataRequest request) {
        return this.put(request, UpdateMetadataResponse.class, builder -> builder.pathSegment(new String[]{"oauth", "clients", request.getClientId(), "meta"})).checkpoint();
    }
}

